/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossrecord;

import eu.europa.ec.jrc.qcs.dao.FieldDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.GenericCrossRecordRule;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhereCondition {
    protected int[] fieldIDs;
    protected String fullFileName;
    protected static FieldDAO fieldDAO;
    protected static Logger logger;

    public WhereCondition() {
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        fieldDAO = (FieldDAO)((Object)daoFactory.getDAO(DAO.FIELD));
    }

    public WhereCondition(int[] fieldIDs) {
        this();
        this.fieldIDs = fieldIDs;
    }

    public String getFileName() {
        String sep = "";
        StringBuilder builder = new StringBuilder();
        for (int fieldID : this.fieldIDs) {
            Field field = (Field)fieldDAO.getByID(fieldID);
            builder.append(sep);
            builder.append(field.getName());
            sep = "-";
        }
        builder.append(".csv");
        return builder.toString();
    }

    public String getFirstColumn() {
        Field field = this.getFirstField();
        if (field == null) {
            return null;
        }
        return field.getName();
    }

    public Field getFirstField() {
        if (this.fieldIDs == null) {
            return null;
        }
        if (this.fieldIDs.length == 0) {
            return null;
        }
        int firstFieldID = this.fieldIDs[0];
        Field field = (Field)fieldDAO.getByID(firstFieldID);
        return field;
    }

    public int[] getFieldIDs() {
        return this.fieldIDs;
    }

    public void setFieldIDs(int[] fieldIDs) {
        this.fieldIDs = fieldIDs;
    }

    public String getFullFileName() {
        return this.fullFileName;
    }

    public void setFullFileName(String fullFileName) {
        this.fullFileName = fullFileName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WhereCondition other = (WhereCondition)obj;
        return Arrays.equals(this.fieldIDs, other.fieldIDs);
    }

    public String toString() {
        String sep = "";
        StringBuilder builder = new StringBuilder("sort on fieldID: ");
        for (int fieldID : this.fieldIDs) {
            builder.append(sep);
            builder.append(fieldID);
            sep = "-";
        }
        return builder.toString();
    }

    static {
        logger = LoggerFactory.getLogger(GenericCrossRecordRule.class);
    }
}

