/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossrecord;

import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecordCSV;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutputDetail;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleRuntimeException;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.CandidateRecord;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.CrossRecordMatch;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.CrossRecordResult;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.EquivalenceContext;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.EquivalenceCriterion;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.EquivalenceGroups;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.GenericCrossRecordRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericEquivalentRecordsRule
extends GenericCrossRecordRule {
    protected Map<Integer, EquivalenceContext> equivalenceContexts;
    protected List<EquivalenceCriterion> criteria;
    protected List<CrossRecordMatch> crossRecordMatches;
    protected int maxCriterionID;
    protected Set<String> secondaryIDs;
    protected Map<String, EquivalenceData> secondaryIDsByReason;
    public static final String DUP_LABEL = "_DUP";
    private static Logger logger = LoggerFactory.getLogger(GenericEquivalentRecordsRule.class);

    public GenericEquivalentRecordsRule(RuleDefinition ruleDefinition) {
        super(ruleDefinition);
        this.setLongDescription("Checks if the input dataset contains some equivalent records.\nTwo or more records are considered \"equivalent\" is all involved field's values (in all records) belong to the same equivalance group. This rule supports more than one equivalance context, where one equivalence context is defined by a set of equivalance groups (one equivalance group is the equivalance class for one single field).\nMoreover, for each equivalence context this rule allows to specify one or more criteria used to define some logical condition for being equivalant.\nSince detailed definition of this rule is quite complex, plase see specific documentation for further details.");
        String label = this.getModelName() + " (ruleID=" + this.getId() + ")";
        if (logger.isTraceEnabled()) {
            logger.trace("Constructor() - Forwarding action to init() method");
        }
        if (!this.init()) {
            String message = "Initialization failed for rule: " + label;
            logger.error(message);
            throw new InvalidRuleConfiguration(message);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Initialization OK for rule: " + label);
        }
    }

    public abstract boolean init();

    public boolean resetCriteria() {
        this.maxCriterionID = 0;
        this.criteria = new ArrayList<EquivalenceCriterion>();
        this.equivalenceContexts = new HashMap<Integer, EquivalenceContext>();
        return true;
    }

    public boolean loadEquivalenceCriteria(String fileName) {
        boolean loaded;
        String configurationPath = this.ruleConfiguration.getConfigurationPath();
        if (logger.isTraceEnabled()) {
            logger.trace("loadEquivalenceCriteria(file) - Loading criteria file: " + fileName);
        }
        if (!(loaded = this.loadEquivalenceCriteria(configurationPath, fileName))) {
            String path = configurationPath.replace("config", "configuration");
            if (logger.isWarnEnabled()) {
                logger.warn("loadEquivalenceCriteria(file) - File not found in directory : " + configurationPath);
                logger.warn("loadEquivalenceCriteria(file) - Retry with                  : " + path + "/" + fileName);
            }
            loaded = this.loadEquivalenceCriteria(path, fileName);
        }
        return loaded;
    }

    public boolean loadEquivalenceCriteria(String basePath, String fileName) {
        List<DataRecordCSV> allCriteria = null;
        if (logger.isDebugEnabled()) {
            logger.debug("loadEquivalenceCriteria(path) - Trying with path: " + basePath + "/" + fileName);
        }
        try {
            allCriteria = this.readCSVFile(basePath, fileName);
        }
        catch (MissingResourceException e) {
            if (basePath.contains("config")) {
                logger.warn("loadEquivalenceCriteria(path) - External configuration path is not defined");
            } else {
                logger.error("loadEquivalenceCriteria(path) - Error loading configuration file : " + fileName + " : " + e.getMessage());
                logger.error("loadEquivalenceCriteria(path) - Configuration path               : " + basePath);
            }
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("loadEquivalenceCriteria(path) - Logical criteria logics: " + this.getFormattedList(allCriteria));
        }
        for (DataRecordCSV logicRule : allCriteria) {
            EquivalenceCriterion criterion = new EquivalenceCriterion(logicRule);
            this.criteria.add(criterion);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("loadEquivalenceCriteria(path) - Loaded criterion:\n\t" + String.valueOf(criterion));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("loadEquivalenceCriteria(path) - Loaded " + this.criteria.size() + " logical criteria");
        }
        return true;
    }

    @Override
    public boolean initAcceptableFile() {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        SchemaView schemaView = ruleConfiguration.getTargetSchemaView();
        if (logger.isDebugEnabled()) {
            logger.debug("initAcceptableFile() - Target schema view: " + String.valueOf(schemaView));
        }
        DataRecord headerRecord = schemaView.getHeader();
        headerRecord.push("N/A", "Line");
        this.openCSVFile(this.workingDirectory, this.acceptableRecordsFileName, false);
        DataRecordCSV dataRecordCSV = (DataRecordCSV)headerRecord;
        this.fileHandlerCSV.writeNextLine(dataRecordCSV);
        return true;
    }

    protected EquivalenceContext createEquivalenceGroups(int contextID, List<? extends DataRecord> list) {
        EquivalenceContext equivalenceContext;
        if (this.equivalenceContexts == null) {
            this.equivalenceContexts = new HashMap<Integer, EquivalenceContext>();
            logger.warn("createEquivalenceGroups(): created new \"equivalenceContexts\" map");
        }
        if ((equivalenceContext = this.equivalenceContexts.get(contextID)) == null) {
            equivalenceContext = new EquivalenceContext(contextID);
            this.equivalenceContexts.put(contextID, equivalenceContext);
            logger.warn("createEquivalenceGroups(): created new \"equivalenceContext\" entry for contextID " + contextID);
        }
        for (int i = 0; i < list.size(); ++i) {
            EquivalenceGroups<String> equivalenceGroups;
            DataRecord group_entry = list.get(i);
            int field_id = this.parseIntegerValue(group_entry.getValue(2));
            if (logger.isTraceEnabled()) {
                logger.trace("createEquivalentGroups() - group_entry[" + contextID + "][" + i + "]=" + String.valueOf(group_entry));
            }
            if (logger.isTraceEnabled()) {
                logger.trace("createEquivalentGroups() - GroupID: " + group_entry.getValue(0) + " (" + group_entry.getValue(2) + ") -> " + group_entry.getValue(3));
            }
            if (equivalenceContext.containsKey(field_id)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("createEquivalentGroups() - EquivalenceGroups map object " + field_id + " already created...");
                }
                equivalenceGroups = equivalenceContext.get(field_id);
                equivalenceGroups.put(group_entry);
                continue;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("createEquivalentGroups() - NEW map (EquivalenceGroups) for field: " + field_id);
            }
            equivalenceGroups = new EquivalenceGroups<String>(String.class);
            equivalenceGroups.put(group_entry);
            equivalenceContext.put(field_id, equivalenceGroups);
        }
        return equivalenceContext;
    }

    public boolean filterRecord(EquivalenceCriterion criterion, CandidateRecord candidateRecord) {
        String prefix = this.getClassName() + " - filterRecord() - ";
        String primaryKey = this.getPrimaryKeyBySchemaPerspective(candidateRecord);
        int contextID = this.getContextID(criterion);
        this.getMatchedGroups(candidateRecord, contextID);
        List<Integer> allFields = criterion.getFieldIDs();
        if (this.isDebugEnabledForCurrentBunch(2)) {
            logger.debug(prefix + "Starting loop over all fields for record: " + primaryKey);
        }
        for (int fieldID : allFields) {
            if (this.isDebugEnabledForCurrentBunch(2)) {
                logger.debug(prefix + "Getting groups for fieldID " + fieldID + " in context " + contextID + " (criterion " + criterion.getCriterionID() + ")");
            }
            Set<Integer> matchedGroups = candidateRecord.getGroupsIDsByFieldID(contextID, fieldID);
            if (this.isDebugEnabledForCurrentBunch(2)) {
                logger.debug(prefix + "Applying filter to fieldID " + fieldID + " -> matchedGroups = " + String.valueOf(matchedGroups) + " in context " + contextID);
            }
            if (matchedGroups != null && matchedGroups.size() > 0) continue;
            if (this.isDebugEnabledForCurrentBunch(2)) {
                int criterionID = criterion.getCriterionID();
                String comment = " because field " + fieldID + " does not belong to any group (in context " + contextID + ")";
                logger.debug(prefix + "Record " + primaryKey + " does not address criterion " + criterionID + comment);
                if (criterionID == this.getMaxCriterionID()) {
                    logger.debug(prefix + "REFUSED_RECORD " + primaryKey + " because record does not address any cross-record criterion");
                }
            }
            return false;
        }
        if (this.isDebugEnabledForCurrentBunch(2)) {
            String comment = " because all involved fields belong to at least one equivalence group in context " + contextID;
            logger.debug(prefix + "ACCEPTED_RECORD " + primaryKey + comment);
            logger.debug(prefix + "record_groups: " + this.getGroupsIncidence2020(candidateRecord));
        }
        candidateRecord.setPassed(criterion, true);
        return true;
    }

    protected CandidateRecord getMatchedGroups(CandidateRecord candidateRecord, int contextID) {
        EquivalenceContext equivalenceContext = this.equivalenceContexts.get(contextID);
        String prefix = this.getClassName() + " - getMatchedGroups() - ";
        String primaryKey = this.getPrimaryKeyBySchemaPerspective(candidateRecord);
        for (Map.Entry<Integer, EquivalenceGroups<String>> map : equivalenceContext.entrySet()) {
            int fieldID = map.getKey();
            EquivalenceGroups<String> equivalenceGroups = map.getValue();
            if (logger.isTraceEnabled()) {
                logger.trace(prefix + "EquivalenceGroups: " + fieldID + " -> " + String.valueOf(equivalenceGroups));
            }
            String value = this.getFieldValue((DataRecord)candidateRecord, fieldID);
            Set<Integer> groupIDs = equivalenceGroups.get(value);
            if (this.isDebugEnabledForCurrentBunch(2)) {
                logger.debug(prefix + "Record " + primaryKey + " - ContextID " + contextID + " - fieldID = " + fieldID + " (" + value + ") -> groups: " + String.valueOf(groupIDs));
            }
            if (groupIDs == null) continue;
            candidateRecord.addGroupsIDs(contextID, fieldID, groupIDs);
        }
        if (this.isDebugEnabledForCurrentBunch(2) && candidateRecord.getNumberOfMatchedGroups(contextID) <= 0) {
            logger.debug(prefix + "NO_EQUIVALENCE_GROUP for all fields of record " + primaryKey);
        }
        return candidateRecord;
    }

    protected List<CrossRecordMatch> checkBunchOfRecords(List<DataRecord> bunch) {
        String prefix = this.getClassName() + " - checkBunchOfRecords() - ";
        ArrayList<CrossRecordMatch> duplicates = new ArrayList<CrossRecordMatch>();
        if (bunch == null || bunch.size() == 0) {
            logger.warn(prefix + "Invoked with empty list");
            return duplicates;
        }
        DataRecord firstRecord = bunch.get(0);
        String mainRecordID = this.getMainKeyBySchemaPerspective(firstRecord);
        if (this.isDebugEnabledForCurrentBunch(1) || this.isDebugEnabledForCurrentBunch(2)) {
            logger.debug("");
            logger.debug(prefix + "********* CHECKING_BUNCH for recordID " + mainRecordID + " (" + bunch.size() + " records) *********");
        }
        Iterator<DataRecord> bunchIterator = bunch.iterator();
        ArrayList<CandidateRecord> filteredBunch = new ArrayList<CandidateRecord>();
        while (bunchIterator.hasNext()) {
            boolean passed = false;
            DataRecord record = bunchIterator.next();
            CandidateRecord candidateRecord = new CandidateRecord(record, this.getMaxCriterionID());
            String primaryRecordID = this.getPrimaryKeyBySchemaPerspective(candidateRecord);
            if (this.isDebugEnabledForCurrentBunch(2)) {
                logger.debug("");
                logger.debug(prefix + "********* Applying all criteria to record " + primaryRecordID + " *********");
            }
            for (EquivalenceCriterion equivalenceCriterion : this.getCriteria()) {
                if (this.isDebugEnabledForCurrentBunch(2)) {
                    logger.debug(prefix + "Filtering record " + primaryRecordID + " for criterion " + equivalenceCriterion.getCriterionID() + " -> record: " + candidateRecord.toShortString());
                }
                passed = this.filterRecord(equivalenceCriterion, candidateRecord);
                if (this.isDebugEnabledForCurrentBunch(2) && passed) {
                    logger.debug(prefix + "Record " + primaryRecordID + ", criterion " + equivalenceCriterion.getCriterionID() + ": filter_ok  -> " + String.valueOf(candidateRecord));
                    logger.debug(prefix + "passed_candidate_record: " + this.getGroupsIncidence2020(candidateRecord));
                }
                if (!passed || filteredBunch.contains(candidateRecord)) continue;
                filteredBunch.add(candidateRecord);
            }
            if (!this.isDebugEnabledForCurrentBunch(2) || passed) continue;
            logger.debug(prefix + "Record " + primaryRecordID + " did not match a filter for at least one criterion -> NOT_ADDED_TO_FILTERED_BUNCH");
        }
        if (this.isDebugEnabledForCurrentBunch(2) || this.isDebugEnabledForCurrentBunch(3)) {
            logger.debug("");
            logger.debug(prefix + "Bunch size for record " + mainRecordID + " after_filtering: " + filteredBunch.size());
            for (CandidateRecord candidateRecord : filteredBunch) {
                logger.debug(prefix + "accepted_candidate_record: " + this.getGroupsIncidence2020(candidateRecord));
            }
        }
        for (int currentRecordIndex = 0; currentRecordIndex < filteredBunch.size(); ++currentRecordIndex) {
            CandidateRecord currentFiltered = (CandidateRecord)filteredBunch.get(currentRecordIndex);
            for (int otherRecordIndex = currentRecordIndex + 1; otherRecordIndex < filteredBunch.size(); ++otherRecordIndex) {
                boolean firstComparison;
                EquivalenceCriterion criterion;
                CrossRecordResult result = null;
                CandidateRecord otherFiltered = (CandidateRecord)filteredBunch.get(otherRecordIndex);
                Iterator<EquivalenceCriterion> iterator = this.getCriteria().iterator();
                while (iterator.hasNext() && !(result = this.compareRecords(currentFiltered, otherFiltered, criterion = iterator.next(), firstComparison = otherRecordIndex == currentRecordIndex + 1 && criterion.getCriterionID() == 1)).isMatched()) {
                }
                if (this.isDebugEnabledForCurrentBunch(3)) {
                    String string = result.isMatched() ? "MATCHED" : "not matched";
                    logger.debug(prefix + "Last criterion result: " + String.valueOf(result));
                    logger.debug(prefix + "All criterions result: " + string + "\n");
                }
                if (!result.isMatched()) continue;
                CrossRecordMatch crossRecordMatch = new CrossRecordMatch(this, currentFiltered, otherFiltered);
                CrossRecordMatch secondMatch = new CrossRecordMatch(this, otherFiltered, currentFiltered);
                crossRecordMatch.setMatchResult(result);
                secondMatch.setMatchResult(result);
                duplicates.add(crossRecordMatch);
                duplicates.add(secondMatch);
                this.crossRecordMatches.add(crossRecordMatch);
                this.crossRecordMatches.add(secondMatch);
                if (!this.isDebugEnabled(12)) continue;
                logger.debug(prefix + "CrossRecordMatch info  : " + this.getAllMatchingInfo(crossRecordMatch));
            }
        }
        return duplicates;
    }

    protected CrossRecordResult compareRecords(CandidateRecord first, CandidateRecord second, EquivalenceCriterion criterion, boolean firstComparison) {
        String prefix = this.getClassName() + " - compareRecords() - ";
        int criterionID = criterion.getCriterionID();
        List<Integer> involvedFieldIDs = criterion.getFieldIDs();
        String firstKey = this.getPrimaryKeyBySchemaPerspective(first);
        String secondKey = this.getPrimaryKeyBySchemaPerspective(second);
        if (this.isDebugEnabledForCurrentBunch(3)) {
            if (firstComparison) {
                logger.debug("-----------------------------------------------------------------");
            }
            logger.debug(prefix + "Comparing: " + firstKey + " vs " + secondKey + " (criterion " + criterionID + ")");
        }
        CrossRecordResult result = new CrossRecordResult(criterionID);
        HashMap<Integer, Boolean> allConditions = new HashMap<Integer, Boolean>();
        if (firstKey.equals(secondKey)) {
            if (this.isDebugEnabledForCurrentBunch(3)) {
                logger.debug(prefix + "The two records have the same composite primary key: -> not matched ");
            }
            return result;
        }
        Iterator<Object> iterator = involvedFieldIDs.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            Set<Integer> firstGroups = first.getGroupsIDsByFieldID(criterionID, n);
            Set<Integer> secondGroups = second.getGroupsIDsByFieldID(criterionID, n);
            HashSet<Integer> intersection = null;
            if (firstGroups != null && secondGroups != null) {
                intersection = new HashSet<Integer>(firstGroups);
                intersection.retainAll(secondGroups);
                result.putIntersection(n, intersection);
                boolean common = intersection != null && intersection.size() > 0;
                allConditions.put(n, common);
            } else {
                allConditions.put(n, false);
            }
            if (!this.isDebugEnabledForCurrentBunch(3)) continue;
            String twoValues = this.getFieldValue((DataRecord)first, n) + " vs " + this.getFieldValue((DataRecord)second, n);
            logger.debug(prefix + "*** Field " + n + " -> " + twoValues);
            logger.debug(prefix + "1st record in groups = " + String.valueOf(firstGroups));
            logger.debug(prefix + "2nd record in groups = " + String.valueOf(secondGroups));
            logger.debug(prefix + "Intersection         = " + String.valueOf(intersection));
        }
        result.setMatched(true);
        for (Map.Entry entry : allConditions.entrySet()) {
            boolean fieldCondition = (Boolean)entry.getValue();
            if (this.isDebugEnabledForCurrentBunch(3)) {
                logger.debug(prefix + "Intersection for field " + String.valueOf(entry.getKey()) + " = " + String.valueOf(entry.getValue()));
            }
            if (fieldCondition) continue;
            result.setMatched(false);
            break;
        }
        if (this.isDebugEnabledForCurrentBunch(3)) {
            logger.debug(prefix + "Equivalence criterion   " + criterionID + " = " + result.isMatched());
        }
        return result;
    }

    protected int getNumberOfCriterian() {
        if (this.criteria == null) {
            return 0;
        }
        return this.criteria.size();
    }

    protected int getMaxCriterionID() {
        if (this.maxCriterionID > 0) {
            return this.maxCriterionID;
        }
        if (this.criteria == null) {
            return 0;
        }
        for (EquivalenceCriterion criterion : this.criteria) {
            if (criterion.getCriterionID() <= this.maxCriterionID) continue;
            this.maxCriterionID = criterion.getCriterionID();
        }
        return this.maxCriterionID;
    }

    protected EquivalenceCriterion getCriterionByID(int criterionID) {
        List<EquivalenceCriterion> criteria = this.getCriteria();
        for (EquivalenceCriterion criterion : criteria) {
            if (criterion.getCriterionID() != criterionID) continue;
            return criterion;
        }
        return null;
    }

    protected int getContextID(EquivalenceCriterion criterion) {
        int contextID = 0;
        Set<EquivalenceContext> contextsReferredByCriterion = criterion.getEquivalenceContexts();
        if (contextsReferredByCriterion.size() != 1) {
            String message = "Criterion " + criterion.getCriterionID() + " refers " + contextsReferredByCriterion.size() + " contexts.QCS 2.x paradigm supports only 1 context for each criterion!\nPlease check rule hard-coded configuration (e.g. the init() method).";
            logger.error(message);
            throw new RuleRuntimeException(message);
        }
        EquivalenceContext equivalenceContext = contextsReferredByCriterion.iterator().next();
        contextID = equivalenceContext.getContextID();
        return contextID;
    }

    protected boolean removeCrossRecordMatch(CrossRecordMatch crossRecordMatch) {
        String mainRecordID = crossRecordMatch.getMainKey();
        String prefix = " - removeCrossRecordMatch() - ";
        boolean debug_filter = this.isDebugEnabledForCurrentBunch(2);
        boolean debug_exceptions = this.isDebugEnabledForCurrentBunch(8) || this.isDebugEnabledForCurrentBunch(4) || this.isDebugEnabledForCurrentBunch(5) || this.isDebugEnabledForCurrentBunch(6) || this.isDebugEnabledForCurrentBunch(7);
        boolean debug = debug_filter;
        debug = debug_exceptions;
        if (debug) {
            logger.debug(prefix + " Removing CrossRecordMatch: " + String.valueOf(crossRecordMatch));
        }
        if (debug) {
            String suffix = mainRecordID + " (" + this.crossRecordMatches.size() + ")";
            logger.debug(prefix + "Candidate list before removing exceptions for record ID: " + suffix);
            for (CrossRecordMatch match2 : this.crossRecordMatches) {
                if (!mainRecordID.equals(match2.getMainKey())) continue;
                logger.debug(prefix + "MATCH - " + match2.toLongString());
            }
        }
        boolean removed = this.crossRecordMatches.removeIf(match -> match.primaryKey.equals(crossRecordMatch.primaryKey));
        if (debug) {
            String suffix = mainRecordID + " (" + this.crossRecordMatches.size() + ")";
            logger.debug(prefix + "Candidate list after removing exceptions for record ID: " + suffix);
            for (CrossRecordMatch match3 : this.crossRecordMatches) {
                if (!mainRecordID.equals(match3.getMainKey())) continue;
                logger.debug(prefix + "MATCH - " + match3.toLongString());
            }
        }
        if (debug) {
            logger.debug(prefix + " Removed ? " + removed);
        }
        return removed;
    }

    protected void mergeCrossRecordMatches(List<CrossRecordMatch> crossRecordMatches) {
        String prefix = this.getClassName() + " - mergeCrossRecordMatches() - ";
        if (this.isDebugEnabledForCurrentBunch(9)) {
            logger.debug("");
            logger.debug(prefix + "Before merge      : " + String.valueOf(this.crossRecordMatches));
        }
        this.crossRecordMatches.addAll(crossRecordMatches);
        if (this.isDebugEnabledForCurrentBunch(9)) {
            logger.debug(prefix + "After merge       : " + String.valueOf(this.crossRecordMatches));
        }
    }

    protected Map<String, List<CrossRecordMatch>> groupByEquivalence(List<CrossRecordMatch> crossRecordsMatchesInBunch) {
        if (crossRecordsMatchesInBunch == null || crossRecordsMatchesInBunch.isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace("groupByEquivalence() - Found null list of cross record matches -> returnin null");
            }
            return null;
        }
        HashMap<String, List<CrossRecordMatch>> matchByEquivalentGroups = new HashMap<String, List<CrossRecordMatch>>();
        if (logger.isTraceEnabled()) {
            logger.trace("groupByEquivalence() - Producing MatchByEquivalentGroups for list of matches: " + String.valueOf(crossRecordsMatchesInBunch));
        }
        for (CrossRecordMatch crossRecordMatch : crossRecordsMatchesInBunch) {
            String equivalentGroupsKey;
            ArrayList<CrossRecordMatch> matchesWithSameEquivalentGroups;
            CrossRecordResult crossRecordResult = crossRecordMatch.getMatchResult();
            if (logger.isTraceEnabled()) {
                logger.trace("groupByEquivalence() - Evaluating CrossRecordMatch: " + String.valueOf(crossRecordMatch));
            }
            if ((matchesWithSameEquivalentGroups = (ArrayList<CrossRecordMatch>)matchByEquivalentGroups.get(equivalentGroupsKey = crossRecordResult.getAllGroupsAsKey())) == null || matchesWithSameEquivalentGroups.isEmpty()) {
                matchesWithSameEquivalentGroups = new ArrayList<CrossRecordMatch>();
                matchByEquivalentGroups.put(equivalentGroupsKey, matchesWithSameEquivalentGroups);
            }
            matchesWithSameEquivalentGroups.add(crossRecordMatch);
            if (!logger.isTraceEnabled()) continue;
            logger.trace("groupByEquivalence() - Handled CrossRecordMatch with key: " + equivalentGroupsKey);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("groupByEquivalence() - Produced MatchByEquivalentGroups map : " + String.valueOf(matchByEquivalentGroups));
        }
        return matchByEquivalentGroups;
    }

    protected CrossRecordMatch findCrossRecordMatchByPrimaryKey(List<CrossRecordMatch> list, String key) {
        if (list == null) {
            return null;
        }
        if (key == null) {
            return null;
        }
        for (CrossRecordMatch crossRecordMatch : list) {
            String primaryKey = crossRecordMatch.getPrimaryKey();
            if (!key.equals(primaryKey)) continue;
            return crossRecordMatch;
        }
        return null;
    }

    protected List<CrossRecordMatch> findAllCrossRecordMatchByMainKey(List<CrossRecordMatch> list, String key) {
        if (list == null) {
            return null;
        }
        if (key == null) {
            return null;
        }
        ArrayList<CrossRecordMatch> result = new ArrayList<CrossRecordMatch>();
        for (CrossRecordMatch crossRecordMatch : list) {
            String mainKey = crossRecordMatch.getMainKey();
            if (!key.equals(mainKey)) continue;
            result.add(crossRecordMatch);
        }
        return result;
    }

    protected RuleOutput produceRichRuleOutput(CrossRecordMatch crossRecordMatch) {
        CandidateRecord firstRecord = crossRecordMatch.getFirstRecord();
        RuleOutput ruleOutput = super.produceRuleOutput(firstRecord);
        List<RuleOutputDetail> ruleOutputDetails = ruleOutput.getAllRuleOutputDetail();
        if (logger.isTraceEnabled()) {
            logger.trace("produceRichRuleOutput() - Produced standard RuleOutput. Detached ? " + ruleOutput.isDetached());
        }
        List<CandidateRecord> otherRecords = crossRecordMatch.getOtherRecords();
        Field field_1 = this.ruleConfiguration.getFieldByPosition(1);
        Field field_2 = this.ruleConfiguration.getFieldByPosition(2);
        String label_1 = field_1.getName() + DUP_LABEL;
        String label_2 = field_2.getName() + DUP_LABEL;
        if (logger.isTraceEnabled()) {
            logger.trace("produceRichRuleOutput() - Adding matching information");
        }
        for (CandidateRecord record : otherRecords) {
            String key_1 = this.getFieldValue((DataRecord)record, field_1);
            String key_2 = this.getFieldValue((DataRecord)record, field_2);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(field_1, key_1));
            fieldValues.add(new FieldValue(field_2, key_2));
            ruleOutputDetails.add(new RuleOutputDetail(label_1, key_1));
            ruleOutputDetails.add(new RuleOutputDetail(label_2, key_2));
        }
        return ruleOutput;
    }

    public static boolean isDuplicateField(String fieldName) {
        if (fieldName == null) {
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("isDuplicateField() - Checking field name: " + fieldName + " (" + fieldName.contains(DUP_LABEL) + ")");
        }
        return fieldName.contains(DUP_LABEL);
    }

    public void initSecondaryIDs() {
        this.secondaryIDs = new HashSet<String>();
        this.secondaryIDsByReason = new HashMap<String, EquivalenceData>();
        if (this.isDebugEnabled(9)) {
            // empty if block
        }
    }

    public boolean addSecondaryID(String reason, int typeId, Set<String> set) {
        String prefix = this.getClassName() + " - addSecondaryID() - ";
        if (!this.hasSecondaryIDs()) {
            this.initSecondaryIDs();
        }
        if (this.isDebugEnabledForCurrentBunch(9)) {
            logger.debug("");
            logger.debug(prefix + "SET/MAP (after init)            : " + String.valueOf(this.secondaryIDs) + "/" + String.valueOf(this.secondaryIDsByReason));
        }
        boolean addedToMap = false;
        boolean addedToSet = this.secondaryIDs.addAll(set);
        if (this.isDebugEnabledForCurrentBunch(9)) {
            logger.debug(prefix + "secondaryIDs (after addAll)     : " + String.valueOf(this.secondaryIDs) + " (addedToSet ? " + addedToSet + ")");
        }
        if (this.secondaryIDsByReason.containsKey(reason)) {
            EquivalenceData equivalenceData = this.secondaryIDsByReason.get(reason);
            Set<String> currentSet = equivalenceData.getSecondaryIDs();
            addedToMap = currentSet.addAll(set);
        } else {
            EquivalenceData equivalenceData = new EquivalenceData(set, typeId);
            EquivalenceData result = this.secondaryIDsByReason.put(reason, equivalenceData);
            boolean bl = addedToMap = result == null;
        }
        if (this.isDebugEnabledForCurrentBunch(9)) {
            logger.debug(prefix + "secondaryIDsByReason (map)      : " + String.valueOf(this.secondaryIDsByReason) + " (addedToMap ? " + addedToMap + ")");
        }
        return addedToSet & addedToMap;
    }

    public boolean hasSecondaryIDs() {
        return this.getSecondaryIDs() != null & this.getEquivalenceDataByReason() != null;
    }

    public boolean hasSharedSecondaryIDs() {
        Set<String> intersection = this.getSharedSecondaryIDsWithDifferentType();
        String prefix = this.getClassName() + " - hasSharedSecondaryIDs() - ";
        boolean debug = this.isDebugEnabledForCurrentBunch(9);
        boolean hasIntersection = intersection != null & !intersection.isEmpty();
        if (debug) {
            logger.debug(prefix + "Intersection      : " + String.valueOf(intersection));
            logger.debug(prefix + "Has intersection  ? " + hasIntersection);
        }
        return hasIntersection;
    }

    public Set<String> getSharedSecondaryIDs() {
        HashSet<String> commonIds = new HashSet<String>();
        String prefix = this.getClassName() + " - getSharedSecondaryIDs() - ";
        boolean debug = this.isDebugEnabledForCurrentBunch(9);
        if (!this.secondaryIDsByReason.isEmpty()) {
            int mapSize = this.secondaryIDsByReason.size();
            if (debug) {
                logger.debug("");
                logger.debug(prefix + "Initial map       : " + String.valueOf(this.secondaryIDsByReason) + " [size=" + mapSize + "]");
            }
            if (mapSize <= 1) {
                if (debug) {
                    logger.debug(prefix + "Only ONE equivalence -> no intersection");
                }
                return commonIds;
            }
            Iterator<EquivalenceData> typeIterator = this.secondaryIDsByReason.values().iterator();
            HashSet<String> alreadySeenIds = new HashSet<String>();
            while (typeIterator.hasNext()) {
                EquivalenceData equivalenceData = typeIterator.next();
                Set<String> secondaryIds = equivalenceData.getSecondaryIDs();
                for (String id : secondaryIds) {
                    if (!alreadySeenIds.contains(id)) continue;
                    commonIds.add(id);
                }
                alreadySeenIds.addAll(secondaryIds);
            }
            if (debug) {
                logger.debug(prefix + "Common ids        : " + String.valueOf(commonIds));
            }
        }
        return commonIds;
    }

    public Set<String> getSharedSecondaryIDsWithDifferentType() {
        HashSet<String> commonElements = new HashSet<String>();
        String prefix = this.getClassName() + " - getSharedSecondaryIDsWithDifferentType() - ";
        boolean debug = this.isDebugEnabledForCurrentBunch(9);
        if (!this.secondaryIDsByReason.isEmpty()) {
            int mapSize = this.secondaryIDsByReason.size();
            if (debug) {
                logger.debug("");
                logger.debug(prefix + "Initial map       : " + String.valueOf(this.secondaryIDsByReason) + " [size=" + mapSize + "]");
            }
            if (mapSize <= 1) {
                if (debug) {
                    logger.debug(prefix + "Only ONE equivalence -> no intersection");
                }
                return commonElements;
            }
            Iterator<EquivalenceData> typeIterator = this.secondaryIDsByReason.values().iterator();
            EquivalenceData firstEquivalenceData = typeIterator.next();
            HashSet<Integer> types = new HashSet<Integer>();
            types.add(firstEquivalenceData.getTypeId());
            while (typeIterator.hasNext()) {
                EquivalenceData equivalenceData = typeIterator.next();
                types.add(equivalenceData.getTypeId());
            }
            int numberOfTypeIds = types.size();
            if (debug) {
                logger.debug(prefix + "Logical typeId    : " + String.valueOf(types) + " (size=" + numberOfTypeIds + ")");
            }
            if (numberOfTypeIds == 1) {
                if (debug) {
                    logger.debug(prefix + "Only 1 condition  : no intersection");
                }
                return commonElements;
            }
            Iterator<EquivalenceData> setsIterator = this.secondaryIDsByReason.values().iterator();
            commonElements.addAll(firstEquivalenceData.getSecondaryIDs());
            if (debug) {
                logger.debug(prefix + "Common elements   : " + String.valueOf(commonElements));
            }
            while (setsIterator.hasNext()) {
                EquivalenceData equivalenceData = setsIterator.next();
                commonElements.retainAll(equivalenceData.getSecondaryIDs());
                if (!debug) continue;
                logger.debug(prefix + "After retain      : " + String.valueOf(commonElements));
            }
        } else if (debug) {
            logger.debug(prefix + "Found empty map (secondaryIDsByReason)");
        }
        return commonElements;
    }

    public Map<Integer, EquivalenceContext> getEquivalenceContexts() {
        return this.equivalenceContexts;
    }

    public List<EquivalenceCriterion> getCriteria() {
        return this.criteria;
    }

    public List<CrossRecordMatch> getCrossRecordMatches() {
        return this.crossRecordMatches;
    }

    public Set<String> getSecondaryIDs() {
        return this.secondaryIDs;
    }

    public Map<String, EquivalenceData> getEquivalenceDataByReason() {
        return this.secondaryIDsByReason;
    }

    public void setCriteria(List<EquivalenceCriterion> criteria) {
        this.criteria = criteria;
    }

    public void setMaxCriterionID(int maxCriterionID) {
        this.maxCriterionID = maxCriterionID;
    }

    public String getAllMatchingInfo(CrossRecordMatch crossRecordMatch) {
        StringBuilder line = new StringBuilder(this.getMatchingInfo(crossRecordMatch));
        CrossRecordResult matchResult = crossRecordMatch.getMatchResult();
        String groups = matchResult.getAllGroups();
        int criterionID = matchResult.getCriterionID();
        line.append("(criterionID=");
        line.append(criterionID);
        line.append(").");
        line.append(" Common groups: ");
        line.append(groups);
        return line.toString();
    }

    public String getMatchingInfo(CrossRecordMatch crossRecordMatch) {
        StringBuilder line = new StringBuilder();
        CandidateRecord firstRecord = crossRecordMatch.getFirstRecord();
        String firstKey = this.getPrimaryKeyBySchemaPerspective(firstRecord);
        line.append("Record ");
        line.append(firstKey);
        line.append(" matches with");
        StringBuilder otherRecords = new StringBuilder(" ");
        List<CandidateRecord> otherFilteredRecords = crossRecordMatch.getOtherRecords();
        if (otherFilteredRecords.size() == 1) {
            line.append(" record");
        } else {
            line.append(otherFilteredRecords.size());
            line.append(" records (");
        }
        String sep = "";
        for (CandidateRecord otherFiltered : otherFilteredRecords) {
            String otherKey = this.getPrimaryKeyBySchemaPerspective(otherFiltered);
            otherRecords.append(sep);
            otherRecords.append(otherKey);
            sep = ", ";
        }
        if (otherFilteredRecords.size() <= 1) {
            otherRecords.append(" ");
        } else {
            otherRecords.append(") ");
        }
        line.append((CharSequence)otherRecords);
        return line.toString();
    }

    protected String getGroupsIncidence2020(CandidateRecord record) {
        int fieldID = 81;
        int criterionID = 1;
        Set<Integer> currentGroups = record.getGroupsIDsByFieldID(criterionID, fieldID);
        String message = this.getPrimaryKeyBySchemaPerspective(record) + " -> groups = " + String.valueOf(currentGroups);
        return message;
    }

    public static class EquivalenceData {
        private int typeId;
        private Set<String> secondaryIDs;

        public EquivalenceData(Set<String> secondaryIDs, int typeId) {
            this.secondaryIDs = secondaryIDs;
            this.typeId = typeId;
        }

        public int getTypeId() {
            return this.typeId;
        }

        public void setTypeId(int typeId) {
            this.typeId = typeId;
        }

        public Set<String> getSecondaryIDs() {
            return this.secondaryIDs;
        }

        public void setSecondaryIDs(Set<String> secondaryIDs) {
            this.secondaryIDs = secondaryIDs;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getSecondaryIDs());
            builder.append(",type=");
            builder.append(this.getTypeId());
            return builder.toString();
        }
    }
}

