/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossrecord;

import eu.europa.ec.jrc.qcs.dao.model.MessageType;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecordCSV;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleTarget;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import eu.europa.ec.jrc.qcs.engine.DataSetReader;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.rule.GenericRule;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleRuntimeException;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.WhereCondition;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericCrossRecordRule
extends GenericRule {
    protected DataSetReader dataSetReader;
    protected WhereCondition whereCondition;
    protected List<DataRecord> bunch;
    protected List<DataRecord> matchedRecords;
    protected boolean enableInstrumentation;
    protected String acceptableRecordsFileName;
    protected String acceptableRecordsFullName;
    protected String acceptableRecordsPrefix = "qcs_acceptable_by_rule_";
    protected String workingDirectory = "temp/acceptable/";
    protected String customDirectory = "temp/custom/";
    protected DataRecord acceptingRecord;
    protected String bunchID;
    protected int debugLevel;
    protected String debugMainRecordID;
    protected String debugPrimaryKey;
    public static final int DEBUG_NONE = 0;
    public static final int DEBUG_BUNCH = 1;
    public static final int DEBUG_FILTER = 2;
    public static final int DEBUG_CRITERIA = 3;
    public static final int DEBUG_EXCEPTION_1 = 4;
    public static final int DEBUG_EXCEPTION_2 = 5;
    public static final int DEBUG_EXCEPTION_3 = 6;
    public static final int DEBUG_EXCEPTION_4 = 7;
    public static final int DEBUG_ALL_EXCEPTIONS = 8;
    public static final int DEBUG_AFTER_EXCEPTIONS = 9;
    public static final int DEBUG_ACCEPTABLE = 10;
    public static final int DEBUG_MATCHED = 12;
    public static final int DEBUG_OUTPUT = 13;
    public static final int DEBUG_MERGE = 14;
    protected static Logger logger = LoggerFactory.getLogger(GenericCrossRecordRule.class);

    public GenericCrossRecordRule(RuleDefinition ruleDefinition) {
        super(ruleDefinition);
        int ruleID = ruleDefinition.getId();
        this.acceptableRecordsFileName = this.acceptableRecordsPrefix + ruleID + ".csv";
        String currentDir = System.getProperty("user.dir");
        this.acceptableRecordsFullName = currentDir + "/" + this.workingDirectory + this.acceptableRecordsFileName;
        this.checkWorkingDirectory(this.workingDirectory);
        this.checkWorkingDirectory(this.customDirectory);
    }

    @Override
    public boolean validate() {
        Object message;
        if (this.ruleConfiguration.getRuleTarget() != RuleTarget.SOME_FIELDS) {
            message = "Cross-records rules cannot be set to " + String.valueOf((Object)this.ruleConfiguration.getRuleTarget()) + ". Forcing it to " + String.valueOf((Object)RuleTarget.SOME_FIELDS);
            this.ruleConfiguration.setRuleTarget(RuleTarget.SOME_FIELDS);
            if (logger.isWarnEnabled()) {
                logger.warn((String)message);
            }
        }
        if (!super.validate()) {
            message = "Cross-records rule with invalid configuration (generic validation failed)";
            logger.error((String)message);
            return false;
        }
        return true;
    }

    protected int getOriginalLineNumber(int lineNumber, DataRecord record) {
        int actualLineNumber;
        if (!this.hasWhereCondition()) {
            return lineNumber;
        }
        int actualLineColumn = record.getSize() - 1;
        String actualLineAsString = record.getValue(actualLineColumn);
        try {
            actualLineNumber = Integer.parseInt(actualLineAsString);
        }
        catch (NumberFormatException e) {
            actualLineNumber = lineNumber;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getOriginalLineNumber() - Sorted line number: " + lineNumber + " -> " + actualLineNumber);
        }
        return actualLineNumber;
    }

    protected void setOriginalLineNumber(DataRecord record) {
        if (!this.hasWhereCondition()) {
            return;
        }
        String lastValue = record.pop();
        record.unshift("Line_Number", lastValue);
        if (logger.isDebugEnabled()) {
            logger.debug("setOriginalLineNumber() - Original line number: " + lastValue);
        }
    }

    private void checkWorkingDirectory(String directory) {
        File file = new File(directory);
        if (!file.exists()) {
            if (file.mkdir()) {
                if (logger.isInfoEnabled()) {
                    logger.info("checkWorkingDirectory() - Working directory created: " + directory);
                }
            } else {
                logger.error("checkWorkingDirectory() - Failed to create working directory: " + directory);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("checkWorkingDirectory() - checked : " + directory + " (OK)");
        }
    }

    public abstract boolean initAcceptableFile();

    public void saveAcceptableRecord(DataRecord record, List<RuleOutput> issues) {
        this.acceptingRecord = record;
        if (this.isAcceptableRecord(issues)) {
            DataRecordCSV dataRecordCSV = (DataRecordCSV)record;
            this.fileHandlerCSV.writeNextLine(dataRecordCSV);
        } else if (logger.isDebugEnabled()) {
            logger.debug("saveAcceptableRecord() - Refused record: " + record.toShortString());
        }
    }

    public boolean isAcceptableRecord(List<RuleOutput> issues) {
        if (issues == null) {
            return true;
        }
        if (issues.size() == 0) {
            return true;
        }
        boolean isValid = true;
        for (RuleOutput ruleOutput : issues) {
            MessageType messageType = ruleOutput.getMessageType();
            if (MessageType.WARNING == messageType) continue;
            isValid = false;
            break;
        }
        Field patientIDField = this.ruleConfiguration.getFieldByPosition(1);
        String patientID = this.getFieldValue(this.acceptingRecord, patientIDField);
        if (this.isDebugEnabledForCurrentBunch(10)) {
            logger.debug("isAcceptableRecord() - Applied standard criterion on record " + patientID + " -> result: " + isValid);
        }
        return isValid;
    }

    public void commitAcceptableRecords() {
        this.fileHandlerCSV.closeWriter();
        if (logger.isInfoEnabled()) {
            logger.info("commitAcceptableRecords() - closed acceptable file: " + this.acceptableRecordsFileName);
        }
    }

    protected int getIndexOfFirstField() {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        SchemaView schemaView = ruleConfiguration.getTargetSchemaView();
        if (this.whereCondition != null) {
            Field field = this.whereCondition.getFirstField();
            int fieldID = field.getId();
            int fieldPosition = schemaView.getFieldPosition(fieldID);
            return fieldPosition - 1;
        }
        String message = "No where condition: impossibile to get first key field";
        logger.error(message);
        throw new RuleRuntimeException(message);
    }

    protected String getCompositeKey(DataRecord record) {
        Field field_1 = this.ruleConfiguration.getFieldByPosition(1);
        Field field_2 = this.ruleConfiguration.getFieldByPosition(2);
        String key_1 = this.getFieldValue(record, field_1);
        String key_2 = this.getFieldValue(record, field_2);
        StringBuilder builder = new StringBuilder();
        builder.append(key_1);
        builder.append("_");
        builder.append(key_2);
        return builder.toString();
    }

    protected RuleOutput produceRuleOutput(DataRecord record) {
        Field field_1 = this.ruleConfiguration.getFieldByPosition(1);
        Field field_2 = this.ruleConfiguration.getFieldByPosition(2);
        String key_1 = this.getFieldValue(record, field_1);
        String key_2 = this.getFieldValue(record, field_2);
        ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
        fieldValues.add(new FieldValue(field_1, key_1));
        fieldValues.add(new FieldValue(field_2, key_2));
        RuleOutput ruleOutput = this.addErrorDetail(fieldValues);
        return ruleOutput;
    }

    public void addMatchedRecord(RuleOutput ruleOutput, DataRecord record) {
        if (this.validationEngine.isSaveReferenceData()) {
            this.addReferenceData(ruleOutput, record);
        }
        this.addMatchedRecord(record);
    }

    public void addMatchedRecord(DataRecord record) {
        if (this.matchedRecords == null) {
            this.resetMatchedRecords();
        }
        this.setOriginalLineNumber(record);
        this.matchedRecords.add(record);
    }

    public void resetMatchedRecords() {
        this.matchedRecords = new ArrayList<DataRecord>();
    }

    public boolean hasWhereCondition() {
        return this.whereCondition != null;
    }

    public void setWhereCondition(WhereCondition whereCondition) {
        if (logger.isDebugEnabled()) {
            logger.debug("setWhereCondition() for rule ID " + this.getId() + " -> Input where condition: " + String.valueOf(whereCondition));
        }
        this.whereCondition = whereCondition;
    }

    public DataSetReader getDataSetReader() {
        return this.dataSetReader;
    }

    public void setDataSetReader(DataSetReader dataSetReader) {
        this.dataSetReader = dataSetReader;
    }

    public WhereCondition getWhereCondition() {
        return this.whereCondition;
    }

    public List<DataRecord> getInvalidRecords() {
        return this.matchedRecords;
    }

    public String getAcceptableRecordsPrefix() {
        return this.acceptableRecordsPrefix;
    }

    public void setAcceptableRecordsPrefix(String acceptableRecordsPrefix) {
        this.acceptableRecordsPrefix = acceptableRecordsPrefix;
    }

    public String getAcceptableRecordsFileName() {
        return this.acceptableRecordsFileName;
    }

    public void setAcceptableRecordsFileName(String acceptableRecordsFileName) {
        this.acceptableRecordsFileName = acceptableRecordsFileName;
    }

    public String getAcceptableRecordsFullName() {
        return this.acceptableRecordsFullName;
    }

    public void setAcceptableRecordsFullName(String acceptableRecordsFullName) {
        this.acceptableRecordsFullName = acceptableRecordsFullName;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getCustomDirectory() {
        return this.customDirectory;
    }

    public void setCustomDirectory(String customDirectory) {
        this.customDirectory = customDirectory;
    }

    public String getBunchID() {
        return this.bunchID;
    }

    public void setBunchID(String bunchID) {
        this.bunchID = bunchID;
    }

    @Override
    protected void setDefaultConfiguration() {
        this.ruleConfiguration = new RuleConfiguration();
        this.ruleConfiguration.setRuleTarget(RuleTarget.SOME_FIELDS);
    }

    public abstract Logger getLogger();

    public boolean isDebugEnabled() {
        return this.isDebugEnabledForCurrentBunch(0);
    }

    public boolean isDebugEnabled(int level) {
        Logger logger = this.getLogger();
        boolean result = logger.isDebugEnabled();
        if (level >= 0) {
            result = level == this.debugLevel;
        }
        return result;
    }

    public boolean isDebugEnabledForCurrentBunch(int level) {
        Logger logger = this.getLogger();
        boolean result = logger.isDebugEnabled();
        boolean verbose = false;
        String recordID = this.getBunchID();
        if (verbose) {
            logger.info("isDebugEnabled(1) - Evaluating level " + level + " for recordID: " + recordID);
        }
        if (!result) {
            return false;
        }
        if (level >= 0) {
            boolean bl = result = level == this.debugLevel;
        }
        if (recordID == null) {
            if (verbose) {
                logger.info("isDebugEnabled(2) - Evaluating level " + level + " for recordID: " + recordID);
            }
            return result;
        }
        if (this.debugMainRecordID != null) {
            if (verbose) {
                logger.info("isDebugEnabled(3) - Evaluating level " + level + " for recordID: " + recordID);
            }
            return result && this.debugMainRecordID.equalsIgnoreCase(recordID);
        }
        if (this.debugPrimaryKey != null) {
            if (verbose) {
                logger.info("isDebugEnabled(4) - Evaluating level " + level + " for recordID: " + recordID);
            }
            return result && this.debugPrimaryKey.equalsIgnoreCase(recordID);
        }
        return result;
    }

    protected <T> List<String> sortCollection(Set<T> input) {
        HashSet<String> converted = new HashSet<String>();
        Iterator<T> iterator = input.iterator();
        T first = iterator.next();
        if (first instanceof String) {
            converted.add((String)first);
            while (iterator.hasNext()) {
                converted.add((String)iterator.next());
            }
        } else {
            logger.error("sortCollection() - For the time being only String collections are supported");
            return null;
        }
        ArrayList<String> sortedList = new ArrayList<String>(converted);
        Collections.sort(sortedList);
        if (logger.isDebugEnabled()) {
            logger.debug("sortCollection() - Sorted collection:\n" + String.valueOf(sortedList));
        }
        return sortedList;
    }

    protected void logMemoryStatus(int counter) {
    }

    protected String getFormattedList(List<? extends DataRecord> list) {
        int number = 0;
        StringBuilder builder = new StringBuilder("\n");
        for (DataRecord dataRecord : list) {
            builder.append(++number);
            builder.append(") ");
            builder.append(dataRecord.toShortString());
            builder.append("\n");
        }
        return builder.toString();
    }

    protected String getBunchInformation(List<DataRecord> bunch) {
        if (bunch == null) {
            return "Null bunch";
        }
        int bunchSize = bunch.size();
        if (bunchSize < 1) {
            return "Empty bunch (size = " + bunchSize + ")";
        }
        String EOL = "\n";
        StringBuilder builder = new StringBuilder("(size: ");
        builder.append(bunchSize);
        builder.append(")");
        builder.append(EOL);
        String separator = "";
        for (int i = 0; i < bunchSize; ++i) {
            DataRecord record = bunch.get(i);
            builder.append(separator);
            builder.append(String.format("%2s", i + 1));
            builder.append(") ");
            builder.append(record.toShortString());
            separator = EOL;
        }
        return builder.toString();
    }
}

