/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossrecord;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalSorter {
    private FileReader inputReader;
    private BufferedReader inputBuffer;
    private FileReader helperReader;
    private BufferedReader helperBuffer;
    private FileWriter outputWriter;
    private BufferedWriter outputBuffer;
    private String fileName;
    private String filePath;
    private String workPath;
    private String outputPath;
    private String outputFile;
    private int bunchSize = 1000;
    private String targetName = "column";
    private boolean addLineNumber = true;
    private boolean removeLineNumber = false;
    private boolean alphaNumeric = true;
    private static final String workDir = "parts";
    private static final String sortedDir = "sorted";
    private static final String separator = ";";
    private static final String fileSeparator = "/";
    private static final String fileExtension = "csv";
    public static final String LINE = "Line";
    protected static Logger logger = LoggerFactory.getLogger(ExternalSorter.class);

    public ExternalSorter(String workingPath) {
        this.workPath = workingPath;
        String bunchSizeString = "1000";
        int sizeValue = Integer.parseInt(bunchSizeString);
        if (sizeValue > 0) {
            this.bunchSize = sizeValue;
            if (logger.isDebugEnabled()) {
                logger.debug("Init() - Set sorting bunch size   : " + this.bunchSize);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("Init() - Using default bunch size : " + this.bunchSize);
        }
    }

    public String sortFile(String fullPath, String columnToOrder) {
        this.setTargetName(columnToOrder);
        File file = new File(fullPath);
        this.fileName = file.getName();
        if (logger.isDebugEnabled()) {
            logger.debug("sortFile(2) - Checking file        : " + fullPath);
        }
        this.filePath = fullPath.contains(fileSeparator) ? fullPath.substring(0, fullPath.lastIndexOf(fileSeparator)) : fullPath.substring(0, fullPath.lastIndexOf("\\"));
        if (this.filePath == null || this.filePath.length() == 0) {
            this.filePath = fullPath.substring(0, fullPath.lastIndexOf(File.separator));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("sortFile(2) - Sorting file        : " + this.filePath + fileSeparator + this.fileName + " [" + this.fileName + "]");
        }
        return this.sortFile(columnToOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sortFile(String columnToOrder) {
        String mergedFile = null;
        try {
            String inputFile = this.filePath + fileSeparator + this.fileName;
            if (logger.isDebugEnabled()) {
                logger.debug("sortFile(3) - Sorting file        : " + inputFile);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("sortFile(3) - Target file name    : " + this.fileName + " [" + columnToOrder + "]");
            }
            FileReader inputFileReader = new FileReader(inputFile);
            BufferedReader inputBufferedReader = new BufferedReader(inputFileReader);
            Object[] header = inputBufferedReader.readLine().split(separator);
            header = this.addLineNumber((String[])header, LINE);
            if (logger.isTraceEnabled()) {
                logger.trace("sortFile(3) - File header         : " + Arrays.toString(header));
            }
            int indexToCompare = this.getIndexForColumn((String[])header, columnToOrder);
            List<String[]> rowsAsArray = new ArrayList<String[]>();
            if (logger.isTraceEnabled()) {
                logger.trace("sortFile(3) - Merging index       : " + indexToCompare);
            }
            int partNumber = 0;
            Object[] array = header;
            int lineNumber = 1;
            if (indexToCompare < 0) {
                Object message = "Sorting column not found in the input dataset. Please check coherence between procotol and dataset!\n";
                message = (String)message + "\tTarget column    : " + columnToOrder + "\n";
                message = (String)message + "\tDataset's header : " + Arrays.toString(header) + "\n";
                logger.warn((String)message);
                inputBufferedReader.close();
                inputFileReader.close();
                String string = null;
                return string;
            }
            this.checkWorkingDirectory(this.workPath + "/parts");
            this.checkWorkingDirectory(this.workPath + "/sorted");
            if (this.outputPath != null) {
                this.checkWorkingDirectory(this.outputPath);
            }
            while (array != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("sortFile(3) - Starting for cyle for partNumber : " + partNumber);
                }
                for (int i = 0; i < this.bunchSize; ++i) {
                    String line = inputBufferedReader.readLine();
                    if (line == null) {
                        array = null;
                        break;
                    }
                    ++lineNumber;
                    if (logger.isDebugEnabled()) {
                        logger.debug("sortFile - " + lineNumber + ") Line : " + line);
                    }
                    array = line.split(separator, -1);
                    if (((array = this.addLineNumber((String[])array, String.valueOf(lineNumber))) == null || array.length != header.length) && logger.isDebugEnabled()) {
                        logger.debug("sortFile(3) - Wrong number of elements in line: " + ExternalSorter.printArray((String[])array));
                    }
                    rowsAsArray.add((String[])array);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("sortFile(3) - Row  : " + ExternalSorter.printArray((String[])array));
                }
                rowsAsArray = this.sortListOfArrays(rowsAsArray, indexToCompare);
                String partFile = this.getPartFileFullPath(partNumber);
                FileWriter fileWriter = new FileWriter(partFile);
                if (logger.isDebugEnabled()) {
                    logger.debug("sortFile(3) - Writing part file   : " + partFile);
                }
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                bufferedWriter.write(this.flattenArray((String[])header, separator) + "\n");
                for (int i = 0; i < rowsAsArray.size(); ++i) {
                    bufferedWriter.append(this.flattenArray(rowsAsArray.get(i), separator) + "\n");
                }
                bufferedWriter.close();
                ++partNumber;
                rowsAsArray.clear();
            }
            mergedFile = this.mergeFiles(this.filePath, this.fileName, partNumber, indexToCompare);
            inputBufferedReader.close();
            inputFileReader.close();
        }
        catch (Exception e) {
            logger.error("sortFile exception " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            this.closeAll();
        }
        return mergedFile;
    }

    private String mergeFiles(String filePath, String fileName, int numFiles, int compareIndex) {
        String targetFile = this.getTargetFileFullPath(fileName);
        try {
            int i;
            ArrayList<FileReader> mergeFileReader = new ArrayList<FileReader>();
            ArrayList<BufferedReader> mergeBufferedReader = new ArrayList<BufferedReader>();
            ArrayList<String[]> fileRows = new ArrayList<String[]>();
            if (logger.isDebugEnabled()) {
                logger.debug("mergeFiles() - Target file        : " + targetFile);
            }
            FileWriter fileWriter = new FileWriter(targetFile);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            boolean someFileHasRows = false;
            for (int fileIndex = 0; fileIndex < numFiles; ++fileIndex) {
                String line;
                String partFile = this.getPartFileFullPath(fileIndex);
                mergeFileReader.add(new FileReader(partFile));
                mergeBufferedReader.add(new BufferedReader((Reader)mergeFileReader.get(fileIndex)));
                String[] header = ((BufferedReader)mergeBufferedReader.get(fileIndex)).readLine().split(separator);
                header = this.removeLineNumber(header);
                if (logger.isDebugEnabled()) {
                    logger.debug("mergeFiles() - Writing header : " + ExternalSorter.printArray(header));
                }
                if (fileIndex == 0) {
                    bufferedWriter.write(this.flattenArray(header, separator) + "\n");
                }
                if ((line = ((BufferedReader)mergeBufferedReader.get(fileIndex)).readLine()) != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("mergeFiles() - Writing FIRST row : " + line);
                    }
                    fileRows.add(this.splitRow(line));
                    someFileHasRows = true;
                    continue;
                }
                fileRows.add(null);
            }
            while (someFileHasRows) {
                String line;
                int i2;
                int minIndex;
                String min;
                String[] row = (String[])fileRows.get(0);
                if (row != null) {
                    min = row[compareIndex];
                    minIndex = 0;
                } else {
                    min = null;
                    minIndex = -1;
                }
                for (i2 = 1; i2 < fileRows.size(); ++i2) {
                    row = (String[])fileRows.get(i2);
                    if (min != null) {
                        if (row == null || !this.isLeftMinorOfRight(row[compareIndex], min, true)) continue;
                        minIndex = i2;
                        min = ((String[])fileRows.get(i2))[compareIndex];
                        continue;
                    }
                    if (row == null) continue;
                    min = row[compareIndex];
                    minIndex = i2;
                }
                if (minIndex < 0) {
                    someFileHasRows = false;
                } else {
                    String[] record = this.removeLineNumber((String[])fileRows.get(minIndex));
                    if (logger.isTraceEnabled()) {
                        logger.trace("mergeFiles - Writing row (adjusted) : " + ExternalSorter.printArray(record));
                    }
                    bufferedWriter.append(this.flattenArray(record, separator) + "\n");
                    line = ((BufferedReader)mergeBufferedReader.get(minIndex)).readLine();
                    if (line != null) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("mergeFiles - Preparing another row : " + line);
                        }
                        fileRows.set(minIndex, this.splitRow(line));
                    } else {
                        fileRows.set(minIndex, null);
                    }
                }
                for (i2 = 0; i2 < fileRows.size(); ++i2) {
                    someFileHasRows = false;
                    if (fileRows.get(i2) == null) continue;
                    if (minIndex < 0) {
                        logger.error("mergeFiles() - Mininum index <= 0 and row not null" + this.flattenArray((String[])fileRows.get(i2), " "));
                    }
                    someFileHasRows = true;
                    break;
                }
                if (someFileHasRows) continue;
                for (i2 = 0; i2 < fileRows.size(); ++i2) {
                    if (fileRows.get(i2) != null || (line = ((BufferedReader)mergeBufferedReader.get(i2)).readLine()) == null) continue;
                    someFileHasRows = true;
                    fileRows.set(i2, this.splitRow(line));
                }
            }
            bufferedWriter.close();
            fileWriter.close();
            for (i = 0; i < mergeBufferedReader.size(); ++i) {
                ((BufferedReader)mergeBufferedReader.get(i)).close();
            }
            for (i = 0; i < mergeFileReader.size(); ++i) {
                ((FileReader)mergeFileReader.get(i)).close();
            }
        }
        catch (Exception e) {
            logger.error("mergeFiles() - Generic error: " + e.getMessage());
        }
        return targetFile;
    }

    private List<String[]> sortListOfArrays(List<String[]> list, int index) {
        List<String[]> left = new ArrayList<String[]>();
        List<String[]> right = new ArrayList<String[]>();
        if (list.size() <= 1) {
            return list;
        }
        int middle = list.size() / 2;
        for (int i = 0; i < middle; ++i) {
            left.add(list.get(i));
        }
        for (int j = middle; j < list.size(); ++j) {
            right.add(list.get(j));
        }
        left = this.sortListOfArrays(left, index);
        right = this.sortListOfArrays(right, index);
        return this.merge(left, right, index);
    }

    private List<String[]> merge(List<String[]> left, List<String[]> right, int index) {
        int i;
        ArrayList<String[]> result = new ArrayList<String[]>();
        if (logger.isDebugEnabled()) {
            logger.debug("");
            logger.debug("merge() - Index : " + index);
            logger.debug("merge() - Left list:\n" + ExternalSorter.printListOfArray(left));
            logger.debug("merge() - Right list:\n" + ExternalSorter.printListOfArray(right));
        }
        while (left.size() > 0 && right.size() > 0) {
            if (this.isLeftMinorOfRight(left.get(0)[index], right.get(0)[index], false)) {
                result.add(left.get(0));
                left.remove(0);
                continue;
            }
            result.add(right.get(0));
            right.remove(0);
        }
        if (left.size() > 0) {
            for (i = 0; i < left.size(); ++i) {
                result.add(left.get(i));
            }
        }
        if (right.size() > 0) {
            for (i = 0; i < right.size(); ++i) {
                result.add(right.get(i));
            }
        }
        return result;
    }

    private boolean isLeftMinorOfRight(String left, String right, boolean strict) {
        boolean result = false;
        if (this.alphaNumeric) {
            result = strict ? left.compareTo(right) < 0 : left.compareTo(right) <= 0;
        } else {
            try {
                int leftValue = Integer.parseInt(left);
                int rightValue = Integer.parseInt(right);
                result = strict ? leftValue < rightValue : leftValue <= rightValue;
            }
            catch (NumberFormatException e) {
                logger.error("isLeftMinorOfRight() - Wrong input type (not numeric): " + left + " <= " + right);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("isLeftMinorOfRight() - Compared : " + left + " <= " + right + "     " + result);
        }
        return result;
    }

    private void checkWorkingDirectory(String workingPath) {
        File file = new File(workingPath);
        if (!file.exists()) {
            if (file.mkdir()) {
                if (logger.isInfoEnabled()) {
                    logger.info("checkWorkingDirectory() - Working directory created: " + workingPath);
                }
            } else {
                logger.error("checkWorkingDirectory() - Failed to create working directory: " + workingPath);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("checkWorkingDirectory() - checked : " + workingPath + " (OK)");
        }
    }

    protected String[] splitRow(String line) {
        String[] array = line.split(separator, -1);
        if (logger.isTraceEnabled()) {
            logger.trace("splitRow(): " + ExternalSorter.printArray(array));
        }
        return array;
    }

    protected String[] fixArray(String[] array) {
        throw new UnsupportedOperationException("Placeholder method, not implemented yet!");
    }

    protected String[] addLineNumber(String[] array, String value) {
        if (this.addLineNumber) {
            if (logger.isTraceEnabled()) {
                logger.trace("addLineNumber() - Adding line number to file: " + this.fileName + " (line = " + value + ")");
            }
            return this.pushArray(array, value);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("addLineNumber() - Ignoring line number for file: " + this.fileName + " (line = " + value + ")");
        }
        return array;
    }

    protected String[] removeLineNumber(String[] array) {
        if (this.removeLineNumber) {
            if (logger.isTraceEnabled()) {
                logger.trace("removeLineNumber() - Removing line number from file: " + this.fileName);
            }
            return Arrays.copyOf(array, array.length - 1);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("removeLineNumber() - Ignoring line number from file: " + this.fileName);
        }
        return array;
    }

    protected String[] pushArray(String[] array, String value) {
        String[] pushed = new String[array.length + 1];
        for (int i = 0; i < array.length; ++i) {
            pushed[i] = array[i];
        }
        pushed[i] = new String(value);
        return pushed;
    }

    public void putRow(String relation, String row, String extension) {
        try {
            if (this.outputWriter == null) {
                this.outputWriter = new FileWriter(relation + extension);
                this.outputBuffer = new BufferedWriter(this.outputWriter);
                this.outputBuffer.write(row);
            } else {
                this.outputBuffer.append(row);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("putRow(): " + row);
            }
        }
        catch (Exception e) {
            logger.error("putRow: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private String flattenArray(String[] arr, String delimiter) {
        String sep = "";
        StringBuilder builder = new StringBuilder("");
        if (logger.isDebugEnabled()) {
            logger.debug("flattenArray() - input size : " + arr.length);
            logger.debug("flattenArray() - input  : " + ExternalSorter.printArray(arr));
        }
        for (int i = 0; i < arr.length; ++i) {
            builder.append(sep);
            builder.append(arr[i]);
            if (sep.length() != 0) continue;
            sep = delimiter;
        }
        return builder.toString().trim();
    }

    private int getIndexForColumn(String[] array, String value) {
        int index = -1;
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equalsIgnoreCase(value)) continue;
            index = i;
            break;
        }
        return index;
    }

    protected void closeAll() {
        try {
            if (this.inputReader != null) {
                this.inputReader.close();
            }
            if (this.inputBuffer != null) {
                this.inputBuffer.close();
            }
            if (this.helperReader != null) {
                this.helperReader.close();
            }
            if (this.helperBuffer != null) {
                this.helperBuffer.close();
            }
            if (this.outputWriter != null) {
                this.outputWriter.close();
            }
            if (this.outputBuffer != null) {
                this.outputBuffer.close();
            }
        }
        catch (IOException e) {
            logger.error("closeAll: error releasing resources: " + e.getMessage());
        }
        catch (NullPointerException e) {
            logger.warn("closeAll: nothing to close");
        }
    }

    protected String getFileNameWithoutExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        String[] tokens = fileName.split("\\.");
        if (tokens == null || tokens.length == 0) {
            return null;
        }
        return tokens[0];
    }

    protected String getPartFileFullPath(int index) {
        String partFile = this.workPath + "/parts/" + this.targetName + ".part" + index + ".csv";
        if (logger.isDebugEnabled()) {
            logger.debug("getPartFileFullPath() - Produced file's part full path:" + partFile);
        }
        return partFile;
    }

    protected String getTargetFileFullPath(String fileName) {
        if (logger.isDebugEnabled()) {
            logger.debug("getTargetFileFullPath() - Input fileName: " + fileName);
        }
        Object actualTargetName = this.outputFile == null ? this.getFileNameWithoutExtension(fileName) + "-by-" + this.targetName + ".csv" : this.outputFile;
        String targetFile = this.outputPath == null ? this.workPath + "sorted/" + (String)actualTargetName : this.outputPath + (String)actualTargetName;
        if (logger.isDebugEnabled()) {
            logger.debug("getTargetFileFullPath() - Produced target full path: " + targetFile);
        }
        return targetFile;
    }

    public boolean addsLineNumber() {
        return this.addLineNumber;
    }

    public boolean removeLineNumber() {
        return this.removeLineNumber;
    }

    public String getWorkPath() {
        return this.workPath;
    }

    public void setWorkPath(String workPath) {
        this.workPath = workPath;
    }

    public int getBunchSize() {
        return this.bunchSize;
    }

    public void setBunchSize(int bunchSize) {
        this.bunchSize = bunchSize;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public void setAddLineNumber(boolean addLineNumber) {
        this.addLineNumber = addLineNumber;
    }

    public void setRemoveLineNumber(boolean removeLineNumber) {
        this.removeLineNumber = removeLineNumber;
    }

    public boolean isAlphaNumeric() {
        return this.alphaNumeric;
    }

    public void setAlphaNumeric(boolean alphaNumeric) {
        this.alphaNumeric = alphaNumeric;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    protected static String printListOfArray(List<String[]> list) {
        String sep = "";
        StringBuilder builder = new StringBuilder();
        for (String[] array : list) {
            String arrayAsString = ExternalSorter.printArray(array);
            builder.append(sep);
            builder.append("\t");
            builder.append(arrayAsString);
            sep = "\n";
        }
        return builder.toString();
    }

    protected static String printArray(String[] array) {
        String sep = "";
        StringBuilder builder = new StringBuilder();
        for (String s : array) {
            builder.append(sep);
            builder.append(s);
            if (sep.length() != 0) continue;
            sep = separator;
        }
        return builder.toString();
    }
}

