/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossrecord;

import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EquivalenceGroups<T> {
    protected Map<T, Set<Integer>> map;
    protected Class<T> type = null;
    public static final int GROUP_ID = 0;
    public static final int GROUP_NAME = 1;
    public static final int FIELD_ID = 2;
    public static final int VALUE = 3;
    private static Logger logger = LoggerFactory.getLogger(EquivalenceGroups.class);

    public EquivalenceGroups(Class<T> type) {
        this.type = type;
        this.map = new HashMap<T, Set<Integer>>();
    }

    public void put(DataRecord record) {
        int groupID;
        String value = null;
        if ("String".equals(this.type.getSimpleName())) {
            value = record.getValue(3);
        }
        String groupIDString = record.getValue(0);
        try {
            groupID = Integer.parseInt(groupIDString);
        }
        catch (NumberFormatException e) {
            logger.error("put() - Wrong integer groupID: " + groupIDString);
            return;
        }
        this.put(value, groupID);
    }

    public Set<Integer> get(T key) {
        return this.map.get(key);
    }

    private void put(T key, Integer groupID) {
        Set<Integer> set = this.map.get(key);
        if (set == null) {
            set = new HashSet<Integer>();
            this.map.put(key, set);
        }
        set.add(groupID);
    }

    public Set<Integer> put(T key, Set<Integer> value) {
        return this.map.put(key, value);
    }

    public int size() {
        return this.map.size();
    }

    public Set<Map.Entry<T, Set<Integer>>> entrySet() {
        return this.map.entrySet();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<T> keySet() {
        return this.map.keySet();
    }

    public Map<T, Set<Integer>> getMap() {
        return this.map;
    }

    public void setMap(Map<T, Set<Integer>> map) {
        this.map = map;
    }

    public Class<T> getType() {
        return this.type;
    }

    public void setType(Class<T> type) {
        this.type = type;
    }

    public String toString() {
        return this.map.toString();
    }
}

