/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossrecord;

import eu.europa.ec.jrc.qcs.dao.model.GenericEntity;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecordCSV;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.EquivalenceContext;
import eu.europa.ec.jrc.qcs.engine.rule.syntax.BooleanRule;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EquivalenceCriterion
extends GenericEntity {
    private int criterionID;
    private BooleanRule condition;
    private List<Integer> fieldIDs;
    private Set<EquivalenceContext> equivalenceContexts;

    public EquivalenceCriterion(DataRecordCSV line) {
        String criterionIDAsString = line.getValue(0);
        this.criterionID = this.parseIntegerValue(criterionIDAsString);
        this.condition = new BooleanRule(line);
    }

    public void setEquivalenceContexts(EquivalenceContext equivalenceContext) {
        if (this.equivalenceContexts == null) {
            this.equivalenceContexts = new HashSet<EquivalenceContext>();
        }
        this.equivalenceContexts.add(equivalenceContext);
    }

    public int getCriterionID() {
        return this.criterionID;
    }

    public void setCriterionID(int criterionID) {
        this.criterionID = criterionID;
    }

    public Set<EquivalenceContext> getEquivalenceContexts() {
        return this.equivalenceContexts;
    }

    public void setEquivalenceContexts(Set<EquivalenceContext> equivalenceContexts) {
        this.equivalenceContexts = equivalenceContexts;
    }

    public BooleanRule getCondition() {
        return this.condition;
    }

    public void setCondition(BooleanRule condition) {
        this.condition = condition;
    }

    public List<Integer> getFieldIDs() {
        return this.fieldIDs;
    }

    public void setFieldIDs(List<Integer> fieldIDs) {
        this.fieldIDs = fieldIDs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.criterionID);
        builder.append("-> condition: ");
        builder.append(this.condition.toShortString(true));
        if (this.fieldIDs != null) {
            builder.append("-> fieldIDs: ");
            builder.append(this.fieldIDs);
        }
        if (this.equivalenceContexts != null) {
            builder.append(", contextIDs: ");
            for (EquivalenceContext equivalenceContext : this.equivalenceContexts) {
                builder.append(equivalenceContext.getContextID());
                builder.append(" ");
            }
        }
        return builder.toString();
    }
}

