/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossrecord;

import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.EquivalenceGroups;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EquivalenceContext {
    protected int contextID;
    protected Map<Integer, EquivalenceGroups<String>> map;
    private String configurationFile;
    private boolean shortSyntax;
    private static Logger logger = LoggerFactory.getLogger(EquivalenceContext.class);

    public EquivalenceContext(int contextID) {
        this.contextID = contextID;
        this.map = new HashMap<Integer, EquivalenceGroups<String>>();
    }

    public EquivalenceContext(int contextID, String configurationFile, boolean shortSyntax) {
        this(contextID);
        this.configurationFile = configurationFile;
        this.shortSyntax = shortSyntax;
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public EquivalenceGroups<String> get(Object key) {
        return this.map.get(key);
    }

    public EquivalenceGroups<String> put(Integer key, EquivalenceGroups<String> value) {
        return this.map.put(key, value);
    }

    public Set<Map.Entry<Integer, EquivalenceGroups<String>>> entrySet() {
        return this.map.entrySet();
    }

    public Set<Integer> getAllFieldIDs() {
        HashSet<Integer> result = new HashSet<Integer>();
        for (Map.Entry<Integer, EquivalenceGroups<String>> entry : this.entrySet()) {
            result.add(entry.getKey());
        }
        return result;
    }

    public Set<String> getAllValues(int fieldID) {
        EquivalenceGroups<String> groups = this.get(fieldID);
        return groups.keySet();
    }

    public int getContextID() {
        return this.contextID;
    }

    public void setContextID(int contextID) {
        this.contextID = contextID;
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public void setConfigurationFile(String configurationFile) {
        this.configurationFile = configurationFile;
    }

    public boolean isShortSyntax() {
        return this.shortSyntax;
    }

    public void setShortSyntax(boolean shortSyntax) {
        this.shortSyntax = shortSyntax;
    }

    public String printMap() {
        return this.printMap(false);
    }

    public String printMap(boolean asColumn) {
        StringBuilder builder = new StringBuilder("EquivalenceGroups for contextID ");
        builder.append(String.valueOf(this.contextID));
        builder.append("\n");
        String eol = "";
        if (asColumn) {
            for (Map.Entry<Integer, EquivalenceGroups<String>> entry : this.entrySet()) {
                EquivalenceGroups<String> groups = entry.getValue();
                Map<String, Set<Integer>> map = groups.getMap();
                builder.append("EquivalenceGroups for field ID: ");
                builder.append(entry.getKey());
                builder.append(" (");
                builder.append(map.size());
                builder.append(" items)\n");
                int index = 0;
                for (Map.Entry<String, Set<Integer>> set : map.entrySet()) {
                    builder.append(eol);
                    builder.append(++index);
                    builder.append(") ");
                    builder.append(set);
                    eol = "\n";
                }
            }
        } else {
            for (Map.Entry<Integer, EquivalenceGroups<String>> entry : this.entrySet()) {
                builder.append(eol);
                builder.append("EquivalenceGroups[" + String.valueOf(entry.getKey()) + "] -> " + String.valueOf(entry.getValue()));
                eol = "\n";
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("printMap() - Prepared string with all entries in context: " + this.contextID);
        }
        return builder.toString();
    }
}

