/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossrecord;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CrossRecordResult {
    protected int criterionID;
    protected boolean matched;
    protected Map<Integer, Set<Integer>> map = new HashMap<Integer, Set<Integer>>();

    public CrossRecordResult(int criterionID) {
        this.criterionID = criterionID;
    }

    public String getAllGroups() {
        StringBuilder builder = new StringBuilder();
        String sep = "";
        for (Map.Entry<Integer, Set<Integer>> entry : this.map.entrySet()) {
            int fieldID = entry.getKey();
            Set<Integer> groups = entry.getValue();
            builder.append(sep);
            builder.append(fieldID);
            builder.append("->");
            builder.append(groups);
            sep = ", ";
        }
        return builder.toString();
    }

    public String getAllGroupsAsKey() {
        StringBuilder builder = new StringBuilder();
        String sep = "";
        for (Map.Entry<Integer, Set<Integer>> entry : this.map.entrySet()) {
            int fieldID = entry.getKey();
            Set<Integer> groups = entry.getValue();
            String groupsAsKey = groups.toString().replaceAll("\\s+", "");
            builder.append(sep);
            builder.append(fieldID);
            builder.append("_");
            builder.append(groupsAsKey);
            sep = "-";
        }
        return builder.toString();
    }

    public Set<Integer> getIntersection(Object key) {
        return this.map.get(key);
    }

    public Set<Integer> putIntersection(Integer key, Set<Integer> value) {
        return this.map.put(key, value);
    }

    public int getCriterionID() {
        return this.criterionID;
    }

    public void setCriterionID(int criterionID) {
        this.criterionID = criterionID;
    }

    public boolean isMatched() {
        return this.matched;
    }

    public void setMatched(boolean matched) {
        this.matched = matched;
    }

    public Map<Integer, Set<Integer>> getMap() {
        return this.map;
    }

    public void setMap(Map<Integer, Set<Integer>> map) {
        this.map = map;
    }

    public String toString() {
        String string = "Criterion " + this.criterionID + " = " + this.isMatched();
        return string;
    }
}

