/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossrecord;

import eu.europa.ec.jrc.qcs.engine.rule.RuleRuntimeException;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.CandidateRecord;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.CrossRecordResult;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.GenericEquivalentRecordsRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossRecordMatch {
    protected String primaryKey;
    protected String mainKey;
    protected String secondaryKey;
    protected CrossRecordResult matchResult;
    protected CandidateRecord firstRecord;
    protected List<CandidateRecord> otherRecords = new ArrayList<CandidateRecord>();
    protected GenericEquivalentRecordsRule equivalentRecordsRule;
    private static Logger logger = LoggerFactory.getLogger(CrossRecordMatch.class);

    public CrossRecordMatch(CrossRecordMatch crossRecordMatch) {
        this.setEquivalentRecordsRule(crossRecordMatch.getEquivalentRecordsRule());
        this.setPrimaryKey(crossRecordMatch.getPrimaryKey());
        this.setFirstRecord(crossRecordMatch.getOtherRecord());
        this.addOtherRecord(crossRecordMatch.getFirstRecord());
    }

    public CrossRecordMatch(GenericEquivalentRecordsRule rule, CandidateRecord firstRecord) {
        this.equivalentRecordsRule = rule;
        this.firstRecord = firstRecord;
    }

    public CrossRecordMatch(GenericEquivalentRecordsRule rule, CandidateRecord first, CandidateRecord second) {
        this(rule, first);
        this.addOtherRecord(second);
        String mainKey_1 = rule.getMainKeyBySchemaPerspective(first);
        String mainKey_2 = rule.getMainKeyBySchemaPerspective(second);
        if (!mainKey_1.equalsIgnoreCase(mainKey_2)) {
            String message = "Wrong CrossRecordMatch: different main keys: " + mainKey_1 + "/" + mainKey_2;
            logger.error(message);
            throw new RuleRuntimeException(message);
        }
        this.mainKey = mainKey_1;
        if (logger.isTraceEnabled()) {
            logger.trace("Constructor() - main key: " + this.mainKey);
        }
        this.primaryKey = rule.getPrimaryKeyBySchemaPerspective(first);
        this.secondaryKey = rule.getFirstCompositeKeyBySchemaPerspective(first);
        String secondaryKey_2 = rule.getFirstCompositeKeyBySchemaPerspective(second);
        if (this.secondaryKey.equalsIgnoreCase(secondaryKey_2) && logger.isWarnEnabled()) {
            logger.warn("Constructor() - Same secondary key: " + this.mainKey + "-" + this.secondaryKey);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Constructor() - secondary keys: " + this.secondaryKey + "/" + secondaryKey_2);
        }
        String otherKey = rule.getPrimaryKeyBySchemaPerspective(second);
        if (logger.isTraceEnabled()) {
            logger.trace("Constructor() - primary keys: " + this.primaryKey + " / " + otherKey);
        }
    }

    public int getSize() {
        List<CandidateRecord> allRecords = this.getAllRecords();
        if (allRecords == null) {
            return 0;
        }
        return allRecords.size();
    }

    public List<CandidateRecord> getAllRecords() {
        ArrayList<CandidateRecord> allRecords = new ArrayList<CandidateRecord>();
        allRecords.add(this.firstRecord);
        allRecords.addAll(this.otherRecords);
        return allRecords;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getMainKey() {
        return this.mainKey;
    }

    public void setMainKey(String mainKey) {
        this.mainKey = mainKey;
    }

    public String getSecondaryKey() {
        return this.secondaryKey;
    }

    public void setSecondaryKey(String secondaryKey) {
        this.secondaryKey = secondaryKey;
    }

    public CandidateRecord getFirstRecord() {
        return this.firstRecord;
    }

    public void setFirstRecord(CandidateRecord record) {
        this.firstRecord = record;
    }

    public List<CandidateRecord> getOtherRecords() {
        return this.otherRecords;
    }

    public void setOtherRecords(List<CandidateRecord> records) {
        this.otherRecords = records;
    }

    public CrossRecordResult getMatchResult() {
        return this.matchResult;
    }

    public void setMatchResult(CrossRecordResult matchResult) {
        this.matchResult = matchResult;
    }

    public GenericEquivalentRecordsRule getEquivalentRecordsRule() {
        return this.equivalentRecordsRule;
    }

    public void setEquivalentRecordsRule(GenericEquivalentRecordsRule equivalentRecordsRule) {
        this.equivalentRecordsRule = equivalentRecordsRule;
    }

    public boolean addOtherRecord(CandidateRecord record) {
        return this.otherRecords.add(record);
    }

    public CandidateRecord getOtherRecord() {
        return this.otherRecords.get(0);
    }

    public CandidateRecord getOtherRecord(int index) {
        return this.otherRecords.get(index);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mainKey == null ? 0 : this.mainKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CrossRecordMatch other = (CrossRecordMatch)obj;
        return !(this.primaryKey == null ? other.primaryKey != null : !this.primaryKey.equals(other.primaryKey));
    }

    public boolean equalsMain(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CrossRecordMatch other = (CrossRecordMatch)obj;
        return !(this.mainKey == null ? other.mainKey != null : !this.mainKey.equals(other.mainKey));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.primaryKey != null) {
            builder.append("PK=");
            builder.append(this.primaryKey);
        } else {
            builder.append("NO primaryKey");
        }
        if (this.firstRecord != null) {
            builder.append(" (");
            builder.append(this.firstRecord.getSize());
            builder.append(" ");
        } else {
            builder.append("No record");
        }
        builder.append("fields)");
        return builder.toString();
    }

    public String toLongString() {
        StringBuilder builder = new StringBuilder();
        if (this.primaryKey != null) {
            builder.append("PK=");
            builder.append(this.primaryKey);
        } else {
            builder.append("NO primaryKey");
        }
        String sep = "";
        if (this.otherRecords != null && this.otherRecords.size() > 0) {
            builder.append(" -> Equivalent record(s): ");
            for (CandidateRecord candidateRecord : this.otherRecords) {
                builder.append(sep);
                String otherKey = this.equivalentRecordsRule.getPrimaryKeyBySchemaPerspective(candidateRecord);
                builder.append(otherKey);
                sep = ",";
            }
        }
        return builder.toString();
    }
}

