/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossrecord;

import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecordCSV;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.EquivalenceCriterion;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.EquivalenceGroups;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CandidateRecord
extends DataRecordCSV {
    protected Map<Integer, EquivalenceGroups<Integer>> groupsByContextID;
    protected Map<Integer, Boolean> passed;
    protected int maxCriterionID;
    private static Logger logger = LoggerFactory.getLogger(CandidateRecord.class);

    public CandidateRecord(DataRecord record, int maxCriterionID) {
        super(record);
        this.maxCriterionID = maxCriterionID;
        this.init();
    }

    @Override
    public void init() {
        this.passed = new HashMap<Integer, Boolean>();
        this.groupsByContextID = new HashMap<Integer, EquivalenceGroups<Integer>>();
        for (int criterionID = 1; criterionID <= this.maxCriterionID; ++criterionID) {
            this.setPassed(criterionID, false);
        }
    }

    public EquivalenceGroups<Integer> getEquivalenceGroups(int contextID) {
        EquivalenceGroups<Integer> groupsIDs;
        boolean debug = logger.isDebugEnabled();
        if (debug) {
            logger.info("getEquivalenceGroups() - GroupsByContextID: " + String.valueOf(this.groupsByContextID));
        }
        if ((groupsIDs = this.groupsByContextID.get(contextID)) == null) {
            groupsIDs = new EquivalenceGroups<Integer>(Integer.class);
            this.putEquivalenceGroups(contextID, groupsIDs);
        }
        if (debug) {
            logger.info("getEquivalenceGroups() - Record: " + this.toShortString() + " contextID = " + contextID + " -> " + String.valueOf(groupsIDs));
        }
        return groupsIDs;
    }

    protected void putEquivalenceGroups(int contextID, EquivalenceGroups<Integer> groupsIDs) {
        this.groupsByContextID.put(contextID, groupsIDs);
    }

    public int getNumberOfMatchedGroups(int contextID) {
        EquivalenceGroups<Integer> equivalenceGroups = this.getEquivalenceGroups(contextID);
        return equivalenceGroups.size();
    }

    public Set<Integer> addGroupsIDs(int contextID, int fieldID, Set<Integer> groups) {
        EquivalenceGroups<Integer> equivalenceGroups = this.getEquivalenceGroups(contextID);
        return equivalenceGroups.put((Integer)fieldID, groups);
    }

    public Set<Integer> getGroupsIDsByFieldID(int contextID, int fieldID) {
        boolean debug = false;
        String fieldValue = "N/A";
        if (debug) {
            logger.info("");
            logger.info("getGroupsIDsByFieldID() - record    : " + this.toShortString() + " (contextID " + contextID + ")");
            logger.info("getGroupsIDsByFieldID() - fieldID   : " + fieldID + " (value = " + fieldValue + ")");
        }
        EquivalenceGroups<Integer> groupsIDs = this.getEquivalenceGroups(contextID);
        if (debug) {
            logger.info("getGroupsIDsByFieldID() - groupsIDs : " + String.valueOf(groupsIDs));
        }
        Set<Integer> result = groupsIDs.get(fieldID);
        if (debug) {
            logger.info("getGroupsIDsByFieldID() - result    : " + String.valueOf(result));
        }
        return result;
    }

    public Boolean isPassed(EquivalenceCriterion criterion) {
        if (criterion == null) {
            return false;
        }
        return this.isPassed(criterion.getCriterionID());
    }

    public Boolean isPassed(int criterionID) {
        return this.passed.get(criterionID) == null ? false : this.passed.get(criterionID);
    }

    public Boolean setPassed(EquivalenceCriterion criterion, boolean value) {
        if (criterion == null) {
            return false;
        }
        return this.setPassed(criterion.getCriterionID(), value);
    }

    public Boolean setPassed(int criterionID, boolean value) {
        return this.passed.put(criterionID, value);
    }

    public String toLongString() {
        StringBuilder builder = new StringBuilder();
        for (int criterionID = 1; criterionID <= this.maxCriterionID; ++criterionID) {
            builder.append("CriterionID ");
            builder.append(criterionID);
            builder.append(" -> ");
            builder.append(this.getEquivalenceGroups(criterionID));
            builder.append(" ");
        }
        return builder.toString();
    }

    public Set<Integer> getAllGroupsIDs(int criterionID) {
        EquivalenceGroups<Integer> equivalenceGroups = this.getEquivalenceGroups(criterionID);
        return CandidateRecord.getAllGroupsIDs(equivalenceGroups);
    }

    public static Set<Integer> getAllGroupsIDs(EquivalenceGroups<Integer> map) {
        HashSet<Integer> allGroups = new HashSet<Integer>();
        for (Map.Entry<Integer, Set<Integer>> entry : map.entrySet()) {
            Set<Integer> groups = entry.getValue();
            allGroups.addAll(groups);
        }
        return allGroups;
    }
}

