/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossrecord;

import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleType;
import eu.europa.ec.jrc.qcs.engine.DataSetReader;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.RuleRuntimeException;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.WhereCondition;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.encr2014.CrossRecordRule;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicDuplicatesRule
extends CrossRecordRule {
    protected Set<String> set;
    protected static Logger logger = LoggerFactory.getLogger(BasicDuplicatesRule.class);

    public BasicDuplicatesRule(RuleDefinition ruleDefinition) {
        super(ruleDefinition);
        this.setLongDescription("Checks that the input dataset does not contain duplicate records, where being duplicates means having exactly the same values in all fields of the composite key. Such composite key is composed by concatenation of the fields defined in the WhereCondition.\nImplementation: all input records are fetched and compared (without any \"load bunch\" feature).");
    }

    @Override
    public boolean initAcceptableFile() {
        logger.warn("initAcceptableFile() - Not required by this cross-record rule");
        return false;
    }

    @Override
    public List<RuleOutput> applyCheck() {
        DataRecord record;
        this.set = new HashSet<String>();
        FileConnection connection = this.getFileConnection();
        File file = connection.getFile();
        String originalFile = file.getAbsolutePath();
        String targetFile = this.whereCondition.getFullFileName();
        if (targetFile == null) {
            String message = "WhereCondition used by " + this.toShortString() + " has a NULL target file";
            throw new RuleRuntimeException(message);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.toShortString() + " (where condition " + String.valueOf(this.whereCondition) + ") -> applying on: " + targetFile);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.toShortString() + " original file: " + originalFile);
        }
        this.dataSetReader = new DataSetReader();
        this.dataSetReader.setMaxRows(0);
        this.dataSetReader.setFilePath(targetFile);
        this.dataSetReader.resetDataset();
        boolean foundFirst = false;
        DataRecord previousRecord = null;
        ArrayList<RuleOutput> duplicates = new ArrayList<RuleOutput>();
        while (this.dataSetReader.hasNext() && (record = this.dataSetReader.getNextDataRecord()) != null) {
            String compositeKey = this.getCompositeKey(record);
            int lineNumber = this.dataSetReader.getCounter();
            int originalLineNumber = this.getOriginalLineNumber(lineNumber, record);
            if (previousRecord != null && logger.isDebugEnabled()) {
                logger.debug(originalLineNumber + ") " + String.valueOf(record) + " (previous: " + previousRecord.getValue(1));
            }
            boolean unique = this.set.add(compositeKey);
            if (logger.isDebugEnabled()) {
                logger.debug(originalLineNumber + ") " + compositeKey + " -> " + unique);
            }
            if (!unique) {
                if (!foundFirst) {
                    int previousLineNumber = this.getOriginalLineNumber(lineNumber - 1, previousRecord);
                    RuleOutput previousOutput = this.produceRuleOutput(previousRecord);
                    previousOutput.setLineNumber(previousLineNumber);
                    duplicates.add(previousOutput);
                    this.addMatchedRecord(previousRecord);
                    foundFirst = true;
                    if (logger.isDebugEnabled()) {
                        logger.debug(previousLineNumber + ") FIRST_DUPLICATE: " + compositeKey);
                    }
                }
                RuleOutput ruleOutput = this.produceRuleOutput(record);
                ruleOutput.setLineNumber(originalLineNumber);
                duplicates.add(ruleOutput);
                this.addMatchedRecord(record);
                if (logger.isDebugEnabled()) {
                    logger.debug(originalLineNumber + ") NEXT_DUPLICATES: " + compositeKey);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(originalLineNumber + ") DUPLICATE: " + String.valueOf(ruleOutput));
                }
            }
            previousRecord = record;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.toShortString() + " analyzed whole dataset. Found " + duplicates.size() + " duplicates");
        }
        return duplicates;
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param_1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_PATIENT_ID.id, false);
        RuleParameter param_2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_TUMOUR_ID.id, false);
        defaultRuleParameters.add(param_1);
        defaultRuleParameters.add(param_2);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        this.ruleConfiguration.setRuleType(RuleType.DUPLICATES);
        int[] fieldIDs = new int[]{DefaultFieldIDencr2014.INCIDENCE_PATIENT_ID.id, DefaultFieldIDencr2014.INCIDENCE_TUMOUR_ID.id};
        WhereCondition whereCondition = new WhereCondition(fieldIDs);
        this.setWhereCondition(whereCondition);
        if (logger.isDebugEnabled()) {
            logger.debug("setDefaultConfiguration() for rule ID " + this.getId() + " -> Set where condition: " + String.valueOf(this.whereCondition));
        }
    }

    @Override
    public Logger getLogger() {
        return logger;
    }
}

