/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2020;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VitalStatusBoDAutopsy
extends CrossFieldRule {
    protected static Logger logger = LoggerFactory.getLogger(VitalStatusBoDAutopsy.class);

    public VitalStatusBoDAutopsy(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule validates that Vital Status, BoD and Autopsy and consistent and applies if vit_status=1, BoD=0 and autopsy!=1.\n\n");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field vital_status_field = ruleConfiguration.getFieldByPosition(1);
        Field bod_field = ruleConfiguration.getFieldByPosition(2);
        Field autopsy_field = ruleConfiguration.getFieldByPosition(3);
        String vital_status = this.getFieldValue(vital_status_field);
        String bod = this.getFieldValue(bod_field);
        String autopsy = this.getFieldValue(autopsy_field);
        if (logger.isDebugEnabled()) {
            logger.debug("applyCheck(E-VSBD) - Autopsy raw value: " + autopsy);
        }
        if (this.isEmpty(vital_status)) {
            return this.getRuleOutput();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("applyCheck(E-VSBD) - Checking preparatory conditions");
        }
        if (!this.isValidAndNotUnknownField(vital_status_field, vital_status)) {
            return this.getRuleOutput();
        }
        if (!this.isValidAndNotUnknownField(bod_field, bod)) {
            return this.getRuleOutput();
        }
        if (!this.isValidAndNotUnknownField(autopsy_field, autopsy)) {
            return this.getRuleOutput();
        }
        int autopsy_int = this.parseIntegerValue(autopsy);
        int vital_status_int = this.parseIntegerValue(vital_status);
        int bod_int = this.parseIntegerValue(bod);
        if (logger.isDebugEnabled()) {
            logger.debug("applyCheck(E-VSBD) - Vital status: " + vital_status_int);
        }
        if (!(this.isValidAndNotUnknownField(vital_status_field, vital_status) && this.isValidAndNotUnknownField(bod_field, bod) && this.isValidAndNotUnknownField(autopsy_field, autopsy))) {
            return this.getRuleOutput();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("applyCheck(E-VSBD) - Apply logic");
        }
        if (vital_status_int == 1 && (bod_int == 0 || autopsy_int == 1)) {
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(vital_status_field, vital_status));
            fieldValues.add(new FieldValue(bod_field, bod));
            fieldValues.add(new FieldValue(autopsy_field, autopsy));
            this.addErrorDetail(fieldValues);
            return this.getRuleOutput();
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2020.INCIDENCE_VITAL_STATUS.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2020.INCIDENCE_BOD.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2020.INCIDENCE_AUTOPSY.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MANDATORY.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MAX_SIZE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_UNKNOWN_VALUE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_RANGE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
    }
}

