/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020;

import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2020;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultSchemaID;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleException;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.GradeBehaviourRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopographyMorphologyGradeBehaviour
extends GradeBehaviourRule {
    protected static Logger logger = LoggerFactory.getLogger(TopographyMorphologyGradeBehaviour.class);

    public TopographyMorphologyGradeBehaviour(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule validates the combination of Topography, Morphology, Behaviour and Grade.\n\nThe general rule states that only malignant tumours (Behaviour=3) should be graded, that is: if Behaviour < 3 and Grade != 9, the W-BEGR warning is raised.\nHowever, for some speficic Topography and Morphology combinations, it's allowed to have Behaviour < 3 and some specific Grade values (see Table 5). If a record does match the Topography and Morphology which would allow to have Behaviour < 3 and a Grade value, but does not have the correct Grade value, a W-TBGR warnign is raised.");
        if (!this.init()) {
            throw new InvalidRuleException("Initialization error");
        }
    }

    @Override
    protected boolean init() {
        return super.init();
    }

    @Override
    public List<RuleOutput> applyCheck() {
        String grade;
        String behaviour;
        String morphology;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field topography_field = ruleConfiguration.getFieldByPosition(1);
        Field morphology_field = ruleConfiguration.getFieldByPosition(2);
        Field behaviour_field = ruleConfiguration.getFieldByPosition(3);
        Field grade_field = ruleConfiguration.getFieldByPosition(4);
        String topography = this.getFieldValue(topography_field);
        if (this.containOneEmptyElement(new String[]{topography, morphology = this.getFieldValue(morphology_field), behaviour = this.getFieldValue(behaviour_field), grade = this.getFieldValue(grade_field)})) {
            return this.getRuleOutput();
        }
        boolean mainFields = this.isValidAndDefinedField(morphology_field, morphology) && this.isValidAndDefinedField(topography_field, topography);
        boolean otherFields = this.isValidAndDefinedField(behaviour_field, behaviour) && this.isValidAndDefinedField(grade_field, grade);
        DataRecord record = this.getDataRecord();
        String mainKey = this.getMainKeyBySchemaPerspective(record);
        if (mainFields && otherFields) {
            boolean debug = logger.isTraceEnabled();
            String prefix = this.getClass().getSimpleName();
            if (debug) {
                logger.info("");
                logger.info(">>> " + prefix + "Checking record : " + mainKey);
            }
            int topographyInt = GradeBehaviourRule.topographyParser.parseTopography(topography);
            if (logger.isTraceEnabled()) {
                logger.trace("Parsed Topography code: " + topographyInt);
            }
            int matches_allowed = this.matchAllowedCombination(topography, morphology, behaviour, grade);
            if (debug) {
                logger.info(prefix + " Matches allowed combination ? " + matches_allowed);
            }
            if (matches_allowed == 3) {
                ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
                fieldValues.add(new FieldValue(topography_field, topography));
                fieldValues.add(new FieldValue(morphology_field, morphology));
                fieldValues.add(new FieldValue(behaviour_field, behaviour));
                fieldValues.add(new FieldValue(grade_field, grade));
                this.addErrorDetail(fieldValues);
                return this.getRuleOutput();
            }
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        this.setDefaultSchemaView(DefaultSchemaID.INCIDENCE_2020_DEFAULT.id);
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2020.INCIDENCE_TOPOGRAPHY.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2020.INCIDENCE_MORPHOLOGY.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2020.INCIDENCE_BEHAVIOUR.id, false);
        RuleParameter param4 = new RuleParameter(4, DefaultFieldIDencr2020.INCIDENCE_GRADE.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        defaultRuleParameters.add(param4);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
    }
}

