/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleException;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util.TNMEdition;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util.TNMValues;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020.TNMRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TNMStageRule
extends TNMRule {
    protected List<TNMEdition> allTNMEditions = new ArrayList<TNMEdition>();
    protected static Logger logger = LoggerFactory.getLogger(TNMStageRule.class);

    public TNMStageRule(RuleDefinition rule) {
        super(rule);
        if (!this.init()) {
            throw new InvalidRuleException("Initialization error");
        }
        this.setLongDescription("This rule validates the combination of topography, TNM edition, Stage, TNM, morphology, age and grade combination.\n\nThe validation is performed only when behaviour value is 2 or 3.\n\nThe TNM values are selected from pTNM if well defined, or from cTNM otherwise.");
    }

    protected boolean init() {
        this.allTNMEditions = this.initializeEditions(6, 8);
        if (this.allTNMEditions == null) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("init() - Loaded configuration files:\n" + this.getAllTNMEditionData(this.allTNMEditions));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("init() - Sample table:\n" + this.getTopographyTable(this.allTNMEditions, "6", "Table1", false));
        }
        return true;
    }

    @Override
    public List<RuleOutput> applyCheck() {
        this.initializeVariables();
        boolean debug = false;
        String recordID = null;
        if (debug) {
            logger.info("");
            logger.info(">>>>>>>>>>>>   Applying TNM rule");
            logger.info("applyCheck() - Checking recordID        : " + recordID);
            logger.info("applyCheck() - Loaded parameter values  : " + this.getAllVariables());
            logger.info("applyCheck() - Contains W-TNME          : " + this.previousOutputContainsRule(DefaultRuleID.TNM_EDITION.id));
        }
        if (debug) {
            logger.debug("applyCheck() - Input record            : " + this.ruleInput.toString());
            logger.debug("applyCheck() - Loaded parameter values : " + this.getAllVariables());
        }
        if (!this.isValidAndDefinedField(this.topography_field, this.topography)) {
            return this.getRuleOutput();
        }
        if (!this.isValidAndDefinedField(this.morphology_field, this.morphology)) {
            return this.getRuleOutput();
        }
        if (!this.isValidAndDefinedField(this.stage_field, this.stage)) {
            return this.getRuleOutput();
        }
        if (!this.isValidField(this.edition_field)) {
            return this.getRuleOutput();
        }
        if (this.previousOutputContainsRule(DefaultRuleID.MORPHOLOGY_TOPOGRAPHY.id)) {
            if (debug) {
                logger.info("applyCheck() - Skipped because triggered W-MOTO: " + this.ruleInput.toString());
            }
            return this.getRuleOutput();
        }
        if (this.previousOutputContainsRule(DefaultRuleID.TNM_EDITION.id)) {
            if (debug) {
                logger.info("applyCheck() - Skipped because triggered W-TNME: " + this.ruleInput.toString());
            }
            return this.getRuleOutput();
        }
        boolean supportedTNMTable = false;
        for (TNMEdition tableEdition : this.allTNMEditions) {
            if (logger.isTraceEnabled()) {
                logger.trace("applyCheck() - Checking TNM edition table number: " + tableEdition.getNumber());
            }
            if (!tableEdition.getNumber().equalsIgnoreCase(this.edition)) continue;
            if (debug) {
                logger.info("applyCheck() - Found match in edition   : " + tableEdition.getNumber());
            }
            supportedTNMTable = true;
            break;
        }
        if (!supportedTNMTable) {
            if (debug) {
                logger.info("applyCheck() - Skipped because TNM edition (of the record) does not match any TNM table: " + this.edition);
            }
            return this.getRuleOutput();
        }
        TNMValues tnmValues = this.selectTNMValues();
        if (debug) {
            logger.info("applyCheck() - Input Stage value        : " + this.stage);
            logger.info("applyCheck() - Selected TNM values      : " + String.valueOf(tnmValues));
        }
        if (tnmValues == null) {
            return this.getRuleOutput();
        }
        boolean isValid = this.checkTNMCombination(this.allTNMEditions, tnmValues);
        if (debug) {
            logger.info("applyCheck() - Valid record             : " + isValid);
        }
        if (!isValid) {
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID - Record's values: " + this.getAllVariables());
            }
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(this.topography_field, this.topography));
            fieldValues.add(new FieldValue(this.morphology_field, this.morphology));
            fieldValues.add(new FieldValue(this.edition_field, this.edition));
            fieldValues.add(new FieldValue(this.stage_field, this.stage));
            fieldValues.add(new FieldValue(this.pT_field, this.pT));
            fieldValues.add(new FieldValue(this.pN_field, this.pN));
            fieldValues.add(new FieldValue(this.pM_field, this.pM));
            fieldValues.add(new FieldValue(this.cT_field, this.cT));
            fieldValues.add(new FieldValue(this.cN_field, this.cN));
            fieldValues.add(new FieldValue(this.cM_field, this.cM));
            fieldValues.add(new FieldValue(this.grade_field, this.grade));
            fieldValues.add(new FieldValue(this.age_field, this.age));
            fieldValues.add(new FieldValue(this.behaviour_field, this.behaviour));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }
}

