/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020;

import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2020;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util.TNMEdition;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util.TNMEditionTable;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util.TNMEditionTableData;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util.TNMValues;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020.CrossFieldRule;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public abstract class TNMRule
extends CrossFieldRule {
    protected Field topography_field;
    protected Field morphology_field;
    protected Field edition_field;
    protected Field stage_field;
    protected Field pT_field;
    protected Field pN_field;
    protected Field pM_field;
    protected Field cT_field;
    protected Field cN_field;
    protected Field cM_field;
    protected Field grade_field;
    protected Field age_field;
    protected Field behaviour_field;
    protected String topography;
    protected String morphology;
    protected String edition;
    protected String stage;
    protected String pT;
    protected String pN;
    protected String pM;
    protected String cT;
    protected String cN;
    protected String cM;
    protected String grade;
    protected String age;
    protected String behaviour;
    protected boolean verbose;
    protected static Logger logger = LoggerFactory.getLogger(TNMRule.class);

    public TNMRule(RuleDefinition rule) {
        super(rule);
    }

    protected List<TNMEdition> initializeEditions(int startEdition, int endEdition) {
        String configurationPath = this.getRuleConfiguration().getConfigurationPath();
        if (logger.isDebugEnabled()) {
            logger.debug("initializeEditions(file) - configurationPath: " + configurationPath);
        }
        List<TNMEdition> configData = this.initializeEditions(configurationPath, startEdition, endEdition);
        if (logger.isDebugEnabled()) {
            logger.debug("initializeEditions(file) - Editions range: " + startEdition + " -> " + endEdition);
        }
        if (configData == null || configData.isEmpty()) {
            String path = configurationPath.replace("config", "configuration");
            if (logger.isWarnEnabled()) {
                logger.warn("initializeEditions(file) - File not found in directory : " + configurationPath);
                logger.warn("initializeEditions(file) - Retry with                  : " + path);
            }
            configData = this.initializeEditions(path, startEdition, endEdition);
        }
        return configData;
    }

    protected List<TNMEdition> initializeEditions(String basePath, int startEdition, int endEdition) {
        ArrayList<TNMEdition> allTNMEditions = new ArrayList<TNMEdition>();
        LoaderOptions options = new LoaderOptions();
        Constructor constructor = new Constructor(TNMEdition.class, options);
        Yaml yaml = new Yaml((BaseConstructor)constructor);
        if (logger.isDebugEnabled()) {
            logger.debug("initializeEditions(path) - Loading from directory: " + basePath);
        }
        for (int edition = startEdition; edition <= endEdition; ++edition) {
            String filename = "TNMRuleEdition" + String.valueOf(edition) + ".yaml";
            if (logger.isDebugEnabled()) {
                logger.debug("initializeEditions(path) - Loading file: " + filename);
            }
            InputStream input = null;
            try {
                FileConnection connection = new FileConnection(filename, basePath);
                connection.openConnection();
                input = connection.getInputStream();
            }
            catch (Exception e) {
                if (basePath.contains("config")) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("initializeEditions(path) - External configuration path is not defined");
                    }
                }
                logger.error("initializeEditions(path) - Error loading configuration file : " + filename + " : " + e.getMessage());
                logger.error("initializeEditions(path) - Configuration path               : " + basePath);
                return null;
            }
            if (input == null) {
                if (basePath.contains("config")) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("initializeEditions(path) - Missing external configuration path");
                    }
                } else {
                    logger.error("initializeEditions(path) - Null configuration file  : " + filename);
                    logger.error("initializeEditions(path) - Wrong configuration path : " + basePath);
                }
                return null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("initializeEditions(path) - Loading input stream: " + String.valueOf(input));
            }
            TNMEdition tnmEdition = (TNMEdition)yaml.load(input);
            if (logger.isDebugEnabled()) {
                logger.debug("initializeEditions(path) - Loaded file: " + filename);
            }
            if (tnmEdition == null) {
                return null;
            }
            tnmEdition.buildCacheData();
            allTNMEditions.add(tnmEdition);
        }
        return allTNMEditions;
    }

    protected void initializeVariables() {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        this.topography_field = ruleConfiguration.getFieldByPosition(1);
        this.morphology_field = ruleConfiguration.getFieldByPosition(2);
        this.edition_field = ruleConfiguration.getFieldByPosition(3);
        this.stage_field = ruleConfiguration.getFieldByPosition(4);
        this.pT_field = ruleConfiguration.getFieldByPosition(5);
        this.pN_field = ruleConfiguration.getFieldByPosition(6);
        this.pM_field = ruleConfiguration.getFieldByPosition(7);
        this.cT_field = ruleConfiguration.getFieldByPosition(8);
        this.cN_field = ruleConfiguration.getFieldByPosition(9);
        this.cM_field = ruleConfiguration.getFieldByPosition(10);
        this.grade_field = ruleConfiguration.getFieldByPosition(11);
        this.age_field = ruleConfiguration.getFieldByPosition(12);
        this.behaviour_field = ruleConfiguration.getFieldByPosition(13);
        this.topography = this.getFieldValue(this.topography_field);
        this.morphology = this.getFieldValue(this.morphology_field);
        this.edition = this.getFieldValue(this.edition_field);
        this.stage = this.getFieldValue(this.stage_field);
        this.pT = this.getFieldValue(this.pT_field);
        this.pN = this.getFieldValue(this.pN_field);
        this.pM = this.getFieldValue(this.pM_field);
        this.cT = this.getFieldValue(this.cT_field);
        this.cN = this.getFieldValue(this.cN_field);
        this.cM = this.getFieldValue(this.cM_field);
        this.grade = this.getFieldValue(this.grade_field);
        this.age = this.getFieldValue(this.age_field);
        this.behaviour = this.getFieldValue(this.behaviour_field);
    }

    protected TNMValues selectTNMValues() {
        boolean isPM;
        boolean isPN;
        boolean isPT;
        if (logger.isTraceEnabled()) {
            logger.trace("selectTNMValues() - Checking behaviour");
        }
        if (this.isEmpty(this.behaviour)) {
            return null;
        }
        if (!this.behaviour.equals("2") && !this.behaviour.equals("3")) {
            return null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("selectTNMValues() - Checking Topo-Morpho: " + this.isValidField(this.morphology_field) + "-" + this.isValidField(this.topography_field));
        }
        if (!this.isValidField(this.morphology_field) || !this.isValidField(this.topography_field)) {
            return null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("selectTNMValues() - Checking P-values");
        }
        if (!this.isValidField(this.pT_field) || !this.isValidField(this.pN_field)) {
            return null;
        }
        String tValue = null;
        String nValue = null;
        String mValue = null;
        if (logger.isTraceEnabled()) {
            logger.trace("selectTNMValues() - Selecting TNM values...");
        }
        boolean bl = isPT = (tValue = this.selectPathologicalClinical(this.pT_field, this.pT, this.cT_field, this.cT)) != null && tValue.equals(this.pT);
        if (tValue == null) {
            return null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("selectTNMValues() - Selected T = " + tValue);
        }
        boolean bl2 = isPN = (nValue = this.selectPathologicalClinical(this.pN_field, this.pN, this.cN_field, this.cN)) != null && nValue.equals(this.pN);
        if (nValue == null) {
            return null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("selectTNMValues() - Selected N = " + nValue);
        }
        if (!this.isValidField(this.pM_field)) {
            return null;
        }
        if (!this.isEmpty(this.pM) && "1".equals(this.pM.substring(0, 1))) {
            mValue = new String(this.pM);
        } else if ((this.isEmpty(this.pM) || this.pM_field.isUnknownValue(this.pM) || "0".equals(this.pM) || "X".equalsIgnoreCase(this.pM)) && !this.isEmpty(this.cM) && "1".equals(this.cM.substring(0, 1))) {
            mValue = new String(this.cM);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("selectTNMValues() - M value starting with 1 ? " + (mValue == null ? "NO" : mValue));
        }
        if (mValue == null) {
            mValue = this.selectPathologicalClinical(this.pM_field, this.pM, this.cM_field, this.cM);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("selectTNMValues() - Selected m = " + mValue);
        }
        if (this.isEmpty(mValue) || "X".equalsIgnoreCase(mValue)) {
            mValue = "0";
        }
        boolean bl3 = isPM = mValue != null && mValue.equals(this.pM);
        if (mValue == null) {
            return null;
        }
        TNMValues tnmValues = new TNMValues(tValue, nValue, mValue, isPT, isPN, isPM);
        if (logger.isDebugEnabled()) {
            logger.debug("selectTNMValues() - Created TNMValues : " + String.valueOf(tnmValues));
        }
        return tnmValues;
    }

    protected String selectPathologicalClinical(Field pField, String pValue, Field cField, String cValue) {
        String value = null;
        if (this.isValidAndDefinedField(pField, pValue) && !"X".equalsIgnoreCase(pValue)) {
            value = new String(pValue);
        } else if (this.isValidAndDefinedField(cField, cValue) && !"X".equalsIgnoreCase(cValue)) {
            value = new String(cValue);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("selectTNValue(): pathological = " + pValue + ", clinical = " + cValue + " -> " + value);
        }
        return value;
    }

    protected boolean checkTNMCombination(List<TNMEdition> allTNMEditions, TNMValues tnmValues) {
        List<TNMEditionTable> topographyTables;
        String recordID = null;
        this.verbose = logger.isTraceEnabled();
        this.stage = this.normalizeStage(this.stage);
        String tValue = this.normalizeT(tnmValues.getTValue());
        String nValue = this.normalizeN(tnmValues.getNValue());
        String mValue = this.normalizeM(tnmValues.getMValue());
        if (this.verbose) {
            logger.info("checkTNMCombination() - Number of TNM edition tables: " + allTNMEditions.size());
            for (TNMEdition edition : allTNMEditions) {
                logger.debug("checkTNMCombination() - Using table number " + edition.getNumber());
            }
        }
        if ((topographyTables = this.getTopographyTables(allTNMEditions, this.edition, this.topography)) == null) {
            if (this.verbose) {
                logger.info("checkTNMCombination() - INVALID because record's topography does not match any topography table");
            }
            return false;
        }
        String keyParameters = recordID + " - [topo=" + this.topography + " - morpho=" + this.morphology + " - age=" + this.age + "]";
        if (this.verbose) {
            logger.info("checkTNMCombination(): " + keyParameters + " addressed by " + topographyTables.size() + " topography tables");
        }
        for (TNMEditionTable table : topographyTables) {
            boolean skipTable;
            String tableID = table.getId();
            if (this.verbose) {
                logger.info("checkTNMCombination() - Evaluating table: " + tableID + " for edition " + this.edition);
                logger.info("checkTNMCombination() - " + tableID + " content:\n" + this.getTopographyTable(allTNMEditions, this.edition, tableID));
            }
            if (skipTable = false) {
                logger.info("checkTNMCombination() - Skipping " + tableID + " for testing purposes");
                continue;
            }
            if (!table.addressMorphology(this.morphology)) continue;
            if (this.verbose) {
                logger.info("checkTNMCombination() - " + keyParameters + " addressed by \"morphology\" " + table.getId());
            }
            if (!table.addressAge(this.age)) continue;
            String stageUpcase = this.stage.toUpperCase();
            if (this.verbose) {
                logger.info("checkTNMCombination() - " + keyParameters + " addressed by \"age\" " + table.getId());
                logger.info("checkTNMCombination() - " + keyParameters + " looking for stage: " + stageUpcase);
            }
            List<TNMEditionTableData> stageRows = table.getStageData(stageUpcase);
            if (this.verbose) {
                if (stageRows.size() > 0) {
                    logger.info("checkTNMCombination() - List of matched rows:");
                    for (TNMEditionTableData matched : stageRows) {
                        logger.info("checkTNMCombination() - " + String.valueOf(matched));
                    }
                } else {
                    logger.info("checkTNMCombination() - List of matched rows: 0");
                }
            }
            if (stageRows == null || stageRows.size() == 0) {
                if (this.verbose) {
                    logger.info("checkTNMCombination() - INVALID because topography table does not address the record's stage");
                }
                return false;
            }
            if (this.verbose) {
                logger.info("checkTNMCombination() - Records T N M Grade: " + tValue + " " + nValue + " " + mValue + " " + this.grade);
            }
            for (TNMEditionTableData row : stageRows) {
                if (!row.isSupported(tnmValues)) {
                    logger.info("checkTNMCombination() - >>>>>>>>>>>>>>>> INVALID - IS_SUPPORTED! " + recordID);
                    return false;
                }
                if (this.verbose) {
                    logger.info("checkTNMCombination() - Checking STAGE_ROW     : " + String.valueOf(row));
                }
                row.adjustAllAllowedValues(this.verbose);
                table.setVerbose(this.verbose);
                if (!table.isValidTNMCombination(row, tValue = this.evaluateCuttingOperation(tValue, 0, 4, row.getT(), "T"), nValue = this.evaluateCuttingOperation(nValue, 0, 3, row.getN(), "N"), mValue = this.evaluateCuttingOperation(mValue, 0, 1, row.getM(), "M"), this.grade)) continue;
                if (this.verbose) {
                    logger.info("checkTNMCombination() - Valid Stage and TNM combination");
                    table.setVerbose(false);
                }
                return true;
            }
            if (this.verbose) {
                logger.info("checkTNMCombination() - INVALID Stage and TNM combination");
            }
            return false;
        }
        if (this.verbose) {
            logger.info("checkTNMCombination() - Valid because no topography table addresses current record");
        }
        return true;
    }

    protected boolean validateAge(List<TNMEdition> configData, String topography, String edition, String stage, String tValue, String nValue, String mValue, String age, boolean isP) {
        stage = this.normalizeStage(stage);
        tValue = this.normalizeT(tValue);
        nValue = this.normalizeN(nValue);
        mValue = this.normalizeM(mValue);
        List<TNMEditionTable> topographyTables = this.getTopographyTables(configData, edition, topography);
        if (topographyTables == null) {
            return false;
        }
        TNMValues tnmValues = new TNMValues(tValue, nValue, mValue, isP, isP, isP);
        for (TNMEditionTable table : topographyTables) {
            if (!table.addressAge(age)) continue;
            List<TNMEditionTableData> stageRows = table.getStageData(stage);
            for (TNMEditionTableData row : stageRows) {
                if (row == null || !row.isSupported(tnmValues) || !table.isValidTNMCombination(row, tValue, nValue, mValue, null)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean validateTNM(List<TNMEdition> configData, String topography, String edition, String stage, String tValue, String nValue, String mValue, boolean isP) {
        stage = this.normalizeStage(stage);
        tValue = this.normalizeT(tValue);
        nValue = this.normalizeN(nValue);
        mValue = this.normalizeM(mValue);
        List<TNMEditionTable> topographyTables = this.getTopographyTables(configData, edition, topography);
        if (topographyTables == null) {
            return false;
        }
        TNMValues tnmValues = new TNMValues(tValue, nValue, mValue, isP, isP, isP);
        Iterator<TNMEditionTable> iterator = topographyTables.iterator();
        if (iterator.hasNext()) {
            TNMEditionTable table = iterator.next();
            List<TNMEditionTableData> stageRows = table.getStageData(stage);
            for (TNMEditionTableData row : stageRows) {
                if (row == null || !row.isSupported(tnmValues) || !table.isValidTNMCombination(row, tValue, nValue, mValue, null)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected List<TNMEditionTable> getTopographyTables(List<TNMEdition> allTNMEditions, String edition, String topography) {
        List<TNMEditionTable> tables = null;
        for (TNMEdition tnmEdition : allTNMEditions) {
            String tnmEditionID = tnmEdition.getNumber();
            if (tnmEditionID == null || !tnmEditionID.equals(edition)) continue;
            tables = tnmEdition.getTopographyTables(topography);
            break;
        }
        return tables;
    }

    protected String normalizeStage(String stage) {
        if (((String)stage).length() <= 0) {
            return stage;
        }
        String prefix = ((String)stage).substring(0, 1);
        if (prefix.equals("1")) {
            stage = "I" + ((String)stage).substring(1);
        } else if (prefix.equals("2")) {
            stage = "II" + ((String)stage).substring(1);
        } else if (prefix.equals("3")) {
            stage = "III" + ((String)stage).substring(1);
        } else if (prefix.equals("4")) {
            stage = "IV" + ((String)stage).substring(1);
        }
        return stage;
    }

    protected String normalizeT(String T) {
        return this.normalizeTNMValue(T, "T");
    }

    protected String normalizeN(String N) {
        return this.normalizeTNMValue(N, "N");
    }

    protected String normalizeM(String M) {
        return this.normalizeTNMValue(M, "M");
    }

    protected String normalizeTNMValue(String value, String expectedPrefix) {
        if (value.length() <= 0) {
            return value;
        }
        char c = value.charAt(0);
        if ((c == 'y' || c == 'Y') && (value = value.substring(1)).length() <= 0) {
            return value;
        }
        String prefix = value.substring(0, 1);
        if (!prefix.equals(expectedPrefix)) {
            return expectedPrefix + value;
        }
        return value;
    }

    protected String evaluateCuttingOperation(String actualValue, int min, int max, String allowed, String label) {
        String prefix;
        boolean debug = false;
        boolean inSitu = false;
        boolean evaluateCutting = false;
        String value = actualValue.substring(1, actualValue.length());
        if (debug) {
            logger.info("evaluateCuttingOperation() - Record " + label + " value    : " + value);
        }
        if (this.isEmpty(value)) {
            logger.warn("evaluateCuttingOperation() - Found null value (should be impossible... but happened)");
            return null;
        }
        if (value.length() >= 2) {
            prefix = value.substring(0, 2);
            inSitu = "is".equalsIgnoreCase(prefix);
            boolean bl = evaluateCutting = inSitu && value.length() > 2;
        }
        if (!inSitu && value.length() > 1) {
            prefix = value.substring(0, 1);
            int valueAsInt = this.parseIntegerValue(prefix);
            boolean bl = evaluateCutting = valueAsInt >= min && valueAsInt <= max;
        }
        if (debug) {
            logger.info("evaluateCuttingOperation() - Adjusted value    : " + value + " -> evaluateCutting: " + evaluateCutting);
        }
        if (evaluateCutting) {
            for (String allowedValue : this.getAllowedValues(allowed)) {
                if (debug) {
                    logger.info("evaluateCuttingOperation() - Original allowed  value : " + allowed);
                }
                if (value.length() != 2 || allowedValue.length() != 2) continue;
                char mainValueNumber = value.charAt(0);
                char mainAllowedNumber = allowedValue.charAt(1);
                if (debug) {
                    logger.info("evaluateCuttingOperation() - Adjusted values : record=#" + mainValueNumber + "#; allowed=#" + mainAllowedNumber + "#");
                }
                if (mainValueNumber != mainAllowedNumber) continue;
                String cutValue = actualValue.substring(0, actualValue.length() - 1);
                if (debug) {
                    logger.info("evaluateCuttingOperation() - Cutting value : " + actualValue + " ->  " + cutValue);
                }
                return cutValue;
            }
        } else {
            if (debug) {
                logger.info("evaluateCuttingOperation() - Return uncut value: #" + actualValue + "# VS allowed: #" + allowed + "#");
            }
            return actualValue;
        }
        return actualValue;
    }

    private String[] getAllowedValues(String allowed) {
        if (allowed == null) {
            return null;
        }
        if (allowed.charAt(0) == ',') {
            allowed = allowed.substring(1, allowed.length());
        }
        if (allowed.charAt(allowed.length() - 1) == ',') {
            allowed = allowed.substring(0, allowed.length() - 1);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getAllowedValues() - Adjusted allowed string: " + allowed);
        }
        Object[] tokens = allowed.split(",");
        if (logger.isTraceEnabled()) {
            logger.trace("getAllowedValues() - tokens: " + Arrays.toString(tokens));
        }
        return tokens;
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2020.INCIDENCE_TOPOGRAPHY.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2020.INCIDENCE_MORPHOLOGY.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2020.INCIDENCE_TNM_EDITION.id, false);
        RuleParameter param4 = new RuleParameter(4, DefaultFieldIDencr2020.INCIDENCE_STAGE.id, false);
        RuleParameter param5 = new RuleParameter(5, DefaultFieldIDencr2020.INCIDENCE_PT.id, false);
        RuleParameter param6 = new RuleParameter(6, DefaultFieldIDencr2020.INCIDENCE_PN.id, false);
        RuleParameter param7 = new RuleParameter(7, DefaultFieldIDencr2020.INCIDENCE_PM.id, false);
        RuleParameter param8 = new RuleParameter(8, DefaultFieldIDencr2020.INCIDENCE_CT.id, false);
        RuleParameter param9 = new RuleParameter(9, DefaultFieldIDencr2020.INCIDENCE_CN.id, false);
        RuleParameter param10 = new RuleParameter(10, DefaultFieldIDencr2020.INCIDENCE_CM.id, false);
        RuleParameter param11 = new RuleParameter(11, DefaultFieldIDencr2020.INCIDENCE_GRADE.id, false);
        RuleParameter param12 = new RuleParameter(12, DefaultFieldIDencr2020.INCIDENCE_AGE.id, false);
        RuleParameter param13 = new RuleParameter(13, DefaultFieldIDencr2020.INCIDENCE_BEHAVIOUR.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        defaultRuleParameters.add(param4);
        defaultRuleParameters.add(param5);
        defaultRuleParameters.add(param6);
        defaultRuleParameters.add(param7);
        defaultRuleParameters.add(param8);
        defaultRuleParameters.add(param9);
        defaultRuleParameters.add(param10);
        defaultRuleParameters.add(param11);
        defaultRuleParameters.add(param12);
        defaultRuleParameters.add(param13);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<LocalFile> files = new ArrayList<LocalFile>();
        files.add(new LocalFile("TNMRuleEdition6.yaml", "", "", "TNM consistency table for ICD Protocol Edition 6"));
        files.add(new LocalFile("TNMRuleEdition7.yaml", "", "", "TNM consistency table for ICD Protocol Edition 7"));
        files.add(new LocalFile("TNMRuleEdition8.yaml", "", "", "TNM consistency table for ICD Protocol Edition 8"));
        this.ruleConfiguration.setConfigurationFiles(files);
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MAX_SIZE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_UNKNOWN_VALUE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_RANGE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getAllTNMEditionData(List<TNMEdition> list) {
        StringBuilder builder = new StringBuilder();
        if (list != null) {
            String eol = "";
            for (TNMEdition tnmEdition : list) {
                if (tnmEdition == null) continue;
                builder.append(eol);
                builder.append(tnmEdition);
                eol = "\n";
            }
        }
        return builder.toString();
    }

    public String getTopographyTable(List<TNMEdition> list, String editionID, String tableID) {
        StringBuilder builder = new StringBuilder();
        builder.append("***   RAW    ***:\n");
        builder.append(this.getTopographyTable(list, editionID, tableID, false));
        builder.append("\n***  CACHED  ***:\n");
        builder.append(this.getTopographyTable(list, editionID, tableID, true));
        return builder.toString();
    }

    public String getTopographyTable(List<TNMEdition> list, String editionID, String tableID, boolean cached) {
        StringBuilder builder = new StringBuilder();
        for (TNMEdition edition : list) {
            if (!editionID.equals(edition.getNumber())) continue;
            List<TNMEditionTable> tables = edition.getTables();
            builder.append("TNMEdition: ");
            builder.append(editionID);
            builder.append(" -> ");
            boolean found = false;
            for (TNMEditionTable table : tables) {
                if (!tableID.equals(table.getId())) continue;
                found = true;
                if (cached) {
                    builder.append(table.getCacheAsString());
                    continue;
                }
                builder.append(table);
            }
            if (found) continue;
            builder.append(" none");
        }
        return builder.toString();
    }

    public String getAllVariables() {
        StringBuilder builder = new StringBuilder();
        builder.append("topography = ");
        builder.append(this.topography);
        builder.append(", ");
        builder.append("morphology = ");
        builder.append(this.morphology);
        builder.append(", ");
        builder.append("edition = ");
        builder.append(this.edition);
        builder.append(", ");
        builder.append("stage = ");
        builder.append(this.stage);
        builder.append(", ");
        builder.append("pT = ");
        builder.append(this.pT);
        builder.append(", ");
        builder.append("pN = ");
        builder.append(this.pN);
        builder.append(", ");
        builder.append("pM = ");
        builder.append(this.pM);
        builder.append(", ");
        builder.append("cT = ");
        builder.append(this.cT);
        builder.append(", ");
        builder.append("cN = ");
        builder.append(this.cN);
        builder.append(", ");
        builder.append("cM = ");
        builder.append(this.cM);
        builder.append(", ");
        builder.append("grade = ");
        builder.append(this.grade);
        builder.append(", ");
        builder.append("age = ");
        builder.append(this.age);
        builder.append(", ");
        builder.append("behaviour = ");
        builder.append(this.behaviour);
        return builder.toString();
    }
}

