/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util.TNMEditionTable;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020.TNMStageRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TNMMorphologyRule2
extends TNMStageRule {
    protected static Logger logger = LoggerFactory.getLogger(TNMMorphologyRule2.class);

    public TNMMorphologyRule2(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule checks if the combination of topography, TNM edition and morphology can be checked with respect of the target TNM edition.\nIf the topography matches a topography table in the TNM edition YAML file, but the morphology is not included in the list of morphology values for that table, this rules triggers a warning.");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        this.initializeVariables();
        boolean debug = false;
        String recordID = "none";
        if (debug) {
            logger.info("");
            logger.info(">>>>>>>>>>>>   Applying TNM rule");
            logger.info("applyCheck() - Checking recordID        : " + recordID);
            logger.info("applyCheck() - Loaded parameter values  : " + this.getAllVariables());
            logger.info("applyCheck() - Input record             : " + this.ruleInput.toString());
        }
        if (!this.isValidAndDefinedField(this.topography_field, this.topography)) {
            return this.getRuleOutput();
        }
        if (!this.isValidAndDefinedField(this.morphology_field, this.morphology)) {
            return this.getRuleOutput();
        }
        if (!this.isValidAndDefinedField(this.edition_field, this.edition)) {
            return this.getRuleOutput();
        }
        if (!this.isValidAndDefinedField(this.behaviour_field, this.behaviour)) {
            return this.getRuleOutput();
        }
        if (!this.behaviour.equals("2") && !this.behaviour.equals("3")) {
            return this.getRuleOutput();
        }
        if (debug) {
            logger.info("applyCheck(): Checking special conditions on Stage and T,N,M");
        }
        if (!this.isValidAndDefinedField(this.stage_field, this.stage)) {
            boolean atLeastOneTNM;
            boolean bl = atLeastOneTNM = this.isTNMVariableWellDefined(this.pT_field, this.pT) || this.isTNMVariableWellDefined(this.pN_field, this.pN) || this.isTNMVariableWellDefined(this.pM_field, this.pM) || this.isTNMVariableWellDefined(this.cT_field, this.cT) || this.isTNMVariableWellDefined(this.cN_field, this.cN) || this.isTNMVariableWellDefined(this.cM_field, this.cM);
            if (!atLeastOneTNM) {
                if (debug) {
                    logger.info("applyCheck(): valid because all Stage and T,N,M are not well defined (from this rule's perspective)");
                }
                return this.getRuleOutput();
            }
        }
        List<TNMEditionTable> topographyTables = this.getTopographyTables(this.allTNMEditions, this.edition, this.topography);
        if (logger.isTraceEnabled()) {
            logger.trace("applyCheck(): Topography table:\n" + String.valueOf(topographyTables));
        }
        if (topographyTables == null || topographyTables.size() == 0) {
            if (debug) {
                logger.info("applyCheck(): valid because record's topography does not match any topography table");
            }
            return this.getRuleOutput();
        }
        String keyParameters = recordID + " - [topo=" + this.topography + " - morpho=" + this.morphology + " - age=" + this.age + "]";
        if (debug) {
            logger.info("applyCheck(): Record " + keyParameters + " addressed by " + topographyTables.size() + " topography tables");
        }
        boolean isValid = false;
        for (TNMEditionTable table : topographyTables) {
            if (debug) {
                String tableID = table.getId();
                logger.info("applyCheck(): Evaluating table: " + tableID + " for edition " + this.edition);
            }
            if (!table.addressMorphology(this.morphology) || !table.addressAge(this.age)) continue;
            isValid = true;
            if (!debug) break;
            logger.info("applyCheck(): recordID " + keyParameters + " matched by " + table.getId());
            break;
        }
        if (debug) {
            logger.info("applyCheck(): Record' status: " + isValid);
        }
        if (!isValid) {
            if (debug) {
                logger.info("applyCheck(): INVALID - Record's values: " + this.getAllVariables());
            }
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(this.topography_field, this.topography));
            fieldValues.add(new FieldValue(this.morphology_field, this.morphology));
            fieldValues.add(new FieldValue(this.edition_field, this.edition));
            fieldValues.add(new FieldValue(this.stage_field, this.stage));
            fieldValues.add(new FieldValue(this.pT_field, this.pT));
            fieldValues.add(new FieldValue(this.pN_field, this.pN));
            fieldValues.add(new FieldValue(this.pM_field, this.pM));
            fieldValues.add(new FieldValue(this.cT_field, this.cT));
            fieldValues.add(new FieldValue(this.cN_field, this.cN));
            fieldValues.add(new FieldValue(this.cM_field, this.cM));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    protected boolean isTNMVariableWellDefined(Field field, String value) {
        if (!this.isValidAndDefinedField(field, value)) {
            return false;
        }
        return !"X".equalsIgnoreCase(value);
    }
}

