/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util.TNMEditionTable;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util.TNMValues;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020.TNMStageRule;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TNMMorphologyRule
extends TNMStageRule {
    protected static Logger logger = LoggerFactory.getLogger(TNMMorphologyRule.class);

    public TNMMorphologyRule(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule checks if the combination of topography, TNM edition and morphology can be checked with respect of the target TNM edition.\nIf the topography matches a topography table in the TNM edition YAML file, but the morphology is not included in the list of morphology values for that table, this rules triggers a warning.");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        this.initializeVariables();
        boolean debug = false;
        String recordID = "none";
        if (debug) {
            logger.info("");
            logger.info(">>>>>>>>>>>>   Applying TNM rule");
            logger.info("applyCheck() - Checking recordID        : " + recordID);
            logger.info("applyCheck() - Loaded parameter values  : " + this.getAllVariables());
            logger.info("applyCheck() - Input record             : " + this.ruleInput.toString());
        }
        TNMValues tnmValues = this.selectTNMValues();
        if (debug) {
            logger.info("applyCheck() - Selected TNM values      : " + String.valueOf(tnmValues));
        }
        if (tnmValues == null) {
            return this.getRuleOutput();
        }
        if (!this.isValidAndDefinedField(this.topography_field, this.topography)) {
            return this.getRuleOutput();
        }
        if (!this.isValidAndDefinedField(this.morphology_field, this.morphology)) {
            return this.getRuleOutput();
        }
        if (!this.isValidAndDefinedField(this.edition_field, this.edition)) {
            return this.getRuleOutput();
        }
        if (!this.isValidAndDefinedField(this.behaviour_field, this.behaviour)) {
            return this.getRuleOutput();
        }
        if (!this.behaviour.equals("2") && !this.behaviour.equals("3")) {
            return null;
        }
        List<TNMEditionTable> topographyTables = this.getTopographyTables(this.allTNMEditions, this.edition, this.topography);
        if (topographyTables == null || topographyTables.size() == 0) {
            if (debug) {
                logger.info("applyCheck(): valid because record's topography does not match any topography table");
            }
            return this.getRuleOutput();
        }
        String keyParameters = recordID + " - [topo=" + this.topography + " - morpho=" + this.morphology + " - age=" + this.age + "]";
        if (debug) {
            logger.info("applyCheck(): Record " + keyParameters + " addressed by " + topographyTables.size() + " topography tables");
        }
        boolean isValid = false;
        for (TNMEditionTable table : topographyTables) {
            if (debug) {
                String tableID = table.getId();
                logger.info("applyCheck(): Evaluating table: " + tableID + " for edition " + this.edition);
            }
            if (!table.addressMorphology(this.morphology) || !table.addressAge(this.age)) continue;
            isValid = true;
            if (!debug) break;
            logger.info("applyCheck(): " + keyParameters + " matched by " + table.getId());
            break;
        }
        if (!isValid) {
            if (logger.isDebugEnabled()) {
                logger.debug("applyCheck(): INVALID - Record's values: " + this.getAllVariables());
            }
            return this.getInvalidRuleOutput();
        }
        return this.getRuleOutput();
    }
}

