/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util.TNMValues;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020.TNMRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TNMEditionRule
extends TNMRule {
    protected static Logger logger = LoggerFactory.getLogger(TNMEditionRule.class);

    public TNMEditionRule(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule verifies if the combination of Topography, Stage, TNM, Morphology, Age and Grade variables meet all conditions necessary to apply the \"TNMStageRule\"  check. If all these conditions are satisfied, but the TNMEdition variable is not in range, then a W-TNME warning is raised.");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        boolean isValid;
        this.initializeVariables();
        boolean debug = false;
        String recordID = "none";
        if (debug) {
            logger.info("");
            logger.info(">>>>>>>>> Applying TNM rule");
            logger.info("applyCheck() - Checking recordID        : " + recordID);
            logger.info("applyCheck() - Loaded parameter values  : " + this.getAllVariables());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("applyCheck() - Input record            : " + this.ruleInput.toString());
            logger.debug("applyCheck() - Loaded parameter values : " + this.getAllVariables());
        }
        TNMValues tnmValues = this.selectTNMValues();
        if (debug) {
            logger.info("applyCheck() - Selected TNM values      : " + String.valueOf(tnmValues));
        }
        if (tnmValues == null) {
            return this.getRuleOutput();
        }
        if (!this.isValidAndDefinedField(this.topography_field, this.topography)) {
            return this.getRuleOutput();
        }
        if (!this.isValidAndDefinedField(this.morphology_field, this.morphology)) {
            return this.getRuleOutput();
        }
        if (!this.isValidAndDefinedField(this.stage_field, this.stage)) {
            return this.getRuleOutput();
        }
        if (!this.isValidAndDefinedField(this.grade_field, this.grade)) {
            return this.getRuleOutput();
        }
        if (!this.isValidAndDefinedField(this.age_field, this.age)) {
            return this.getRuleOutput();
        }
        if (!this.isValidAndDefinedField(this.behaviour_field, this.behaviour)) {
            return this.getRuleOutput();
        }
        if (!this.behaviour.equals("2") && !this.behaviour.equals("3")) {
            return null;
        }
        boolean bl = isValid = !this.isEmpty(this.edition);
        if (!isValid) {
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID - Record's values: " + this.getAllVariables());
            }
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(this.topography_field, this.topography));
            fieldValues.add(new FieldValue(this.morphology_field, this.morphology));
            fieldValues.add(new FieldValue(this.edition_field, this.edition));
            fieldValues.add(new FieldValue(this.stage_field, this.stage));
            fieldValues.add(new FieldValue(this.pT_field, this.pT));
            fieldValues.add(new FieldValue(this.pN_field, this.pN));
            fieldValues.add(new FieldValue(this.pM_field, this.pM));
            fieldValues.add(new FieldValue(this.cT_field, this.cT));
            fieldValues.add(new FieldValue(this.cN_field, this.cN));
            fieldValues.add(new FieldValue(this.cM_field, this.cM));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }
}

