/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2020;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurvivalTimeFollowDateUnknown
extends CrossFieldRule {
    protected static Logger logger = LoggerFactory.getLogger(SurvivalTimeFollowDateUnknown.class);

    public SurvivalTimeFollowDateUnknown(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule validates that either Survival time or Date of Follow-up is valid.\n\nThe rule applies when:\n- Survival time (Surv_time) is unknown (99999) or missing (blank), AND\n- Date of the last known vital status (MoF, YoF) is unknown or missing.\nSee Table 13 of the QC report.");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        boolean yofMissingOrUnknown;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field surv_time_field = ruleConfiguration.getFieldByPosition(1);
        Field mof_field = ruleConfiguration.getFieldByPosition(2);
        Field yof_field = ruleConfiguration.getFieldByPosition(3);
        String surv_time = this.getFieldValue(surv_time_field);
        String mof = this.getFieldValue(mof_field);
        String yof = this.getFieldValue(yof_field);
        if (!(this.isValidField(surv_time_field) && this.isValidField(mof_field) && this.isValidField(yof_field))) {
            return this.getRuleOutput();
        }
        boolean survTimeMissingOrUnknown = this.isEmpty(surv_time) || this.isFieldSetToUnknownValue(surv_time_field, surv_time);
        boolean mofMissingOrUnknown = this.isEmpty(mof) || this.isFieldSetToUnknownValue(mof_field, mof);
        boolean bl = yofMissingOrUnknown = this.isEmpty(yof) || this.isFieldSetToUnknownValue(yof_field, yof);
        if (survTimeMissingOrUnknown && (mofMissingOrUnknown || yofMissingOrUnknown)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Rule W-SUMU triggered: Surv_time=" + surv_time + ", MoF=" + mof + ", YoF=" + yof);
            }
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(surv_time_field, surv_time));
            fieldValues.add(new FieldValue(mof_field, mof));
            fieldValues.add(new FieldValue(yof_field, yof));
            this.addErrorDetail(fieldValues);
            return this.getRuleOutput();
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2020.INCIDENCE_SURVIVAL.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2020.INCIDENCE_MONTH_FU.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2020.INCIDENCE_YEAR_FU.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MAX_SIZE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_RANGE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
    }
}

