/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2020;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurvivalDateAnalysisRule
extends CrossFieldRule {
    protected static Logger logger = LoggerFactory.getLogger(SurvivalDateAnalysisRule.class);
    private static final double DAYS_PER_MONTH = 30.43675;
    private static final double RANGE_TOLERANCE = 1.0;

    public SurvivalDateAnalysisRule(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule validates that Survival time is consistent with the dates of Incidence and Follow-up.\n\n");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field survTimeField = ruleConfiguration.getFieldByPosition(1);
        Field moiField = ruleConfiguration.getFieldByPosition(2);
        Field yoiField = ruleConfiguration.getFieldByPosition(3);
        Field mofField = ruleConfiguration.getFieldByPosition(4);
        Field yofField = ruleConfiguration.getFieldByPosition(5);
        String strSurvTimeValue = this.getFieldValue(survTimeField);
        String strMoiValue = this.getFieldValue(moiField);
        String strYoiValue = this.getFieldValue(yoiField);
        String strMofValue = this.getFieldValue(mofField);
        String strYofValue = this.getFieldValue(yofField);
        if (!(this.isValidAndNotUnknownField(survTimeField, strSurvTimeValue) && this.isValidAndNotUnknownField(moiField, strMoiValue) && this.isValidAndNotUnknownField(yoiField, strYoiValue) && this.isValidAndNotUnknownField(mofField, strMofValue) && this.isValidAndNotUnknownField(yofField, strYofValue))) {
            if (logger.isDebugEnabled()) {
                logger.debug("Rule W-SUDA not applicable: one or more fields are invalid or unknown");
            }
            return this.getRuleOutput();
        }
        int intSurvTimeValue = this.parseIntegerValue(strSurvTimeValue);
        int intMoiValue = this.parseIntegerValue(strMoiValue);
        int intYoiValue = this.parseIntegerValue(strYoiValue);
        int intMofValue = this.parseIntegerValue(strMofValue);
        int intYofValue = this.parseIntegerValue(strYofValue);
        if (intSurvTimeValue == -2147483001 || intMoiValue == -2147483001 || intYoiValue == -2147483001 || intMofValue == -2147483001 || intYofValue == -2147483001) {
            if (logger.isDebugEnabled()) {
                logger.debug("Rule W-SUDA not applicable: one or more values could not be parsed as integer");
            }
            return this.getRuleOutput();
        }
        int actualMonthsDiff = this.calculateMonthDifference(intYoiValue, intMoiValue, intYofValue, intMofValue);
        double expectedMonths = (double)intSurvTimeValue / 30.43675;
        double lowerBorder = expectedMonths - 1.0;
        double upperBorder = expectedMonths + 1.0;
        if ((double)actualMonthsDiff < lowerBorder || (double)actualMonthsDiff > upperBorder) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Rule W-SUDA triggered: Surv_time=%d days, DoI=%02d/%d, DoF=%02d/%d, Actual months=%d, Expected=%.2f, Range=[%.2f, %.2f]", intSurvTimeValue, intMoiValue, intYoiValue, intMofValue, intYofValue, actualMonthsDiff, expectedMonths, lowerBorder, upperBorder));
            }
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(survTimeField, strSurvTimeValue));
            fieldValues.add(new FieldValue(moiField, strMoiValue));
            fieldValues.add(new FieldValue(yoiField, strYoiValue));
            fieldValues.add(new FieldValue(mofField, strMofValue));
            fieldValues.add(new FieldValue(yofField, strYofValue));
            this.addErrorDetail(fieldValues);
            return this.getRuleOutput();
        }
        return this.getRuleOutput();
    }

    private int calculateMonthDifference(int yearDoI, int monthDoI, int yearDoF, int monthDoF) {
        int totalMonthsDoI = yearDoI * 12 + monthDoI;
        int totalMonthsDoF = yearDoF * 12 + monthDoF;
        return totalMonthsDoF - totalMonthsDoI;
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2020.INCIDENCE_SURVIVAL.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2020.INCIDENCE_MONTH_DOI.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2020.INCIDENCE_YEAR_DOI.id, false);
        RuleParameter param4 = new RuleParameter(4, DefaultFieldIDencr2020.INCIDENCE_MONTH_FU.id, false);
        RuleParameter param5 = new RuleParameter(5, DefaultFieldIDencr2020.INCIDENCE_YEAR_FU.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        defaultRuleParameters.add(param4);
        defaultRuleParameters.add(param5);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MANDATORY.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MAX_SIZE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_UNKNOWN_VALUE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_RANGE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
    }
}

