/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2020;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurgeryBoDStatus
extends CrossFieldRule {
    protected static Logger logger = LoggerFactory.getLogger(SurgeryBoDStatus.class);

    public SurgeryBoDStatus(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule validates that Surgery and BoD are consistent and applies if Surgery is NOT 0 or NOT 'Unknown' or NOT blank and BoD!=7.\n\n");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field surgery_field = ruleConfiguration.getFieldByPosition(1);
        Field bod_field = ruleConfiguration.getFieldByPosition(2);
        String surgery = this.getFieldValue(surgery_field);
        String bod = this.getFieldValue(bod_field);
        String recordID = "N/A";
        if (logger.isTraceEnabled()) {
            logger.trace("applyCheck() - Patient " + recordID + " -> Surgery = " + surgery + " - BoD = " + bod);
        }
        if (this.isEmpty(surgery) || "0".equals(surgery) || surgery_field.isUnknownValue(surgery)) {
            return this.getRuleOutput();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("applyCheck() - Checking BoD condition for BoD: " + bod);
        }
        if ("7".equals(bod)) {
            return this.getRuleOutput();
        }
        ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
        fieldValues.add(new FieldValue(surgery_field, surgery));
        fieldValues.add(new FieldValue(bod_field, bod));
        this.addErrorDetail(fieldValues);
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2020.INCIDENCE_SURGERY.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2020.INCIDENCE_BOD.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MANDATORY.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MAX_SIZE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_UNKNOWN_VALUE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_RANGE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
    }
}

