/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2020;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoDVitalStatus
extends CrossFieldRule {
    protected static Logger logger = LoggerFactory.getLogger(BoDVitalStatus.class);

    public BoDVitalStatus(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule validates that BoD and Vital Status are consistent and applies if BoD=0 and vit_status!=2.\n\n");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field bod_field = ruleConfiguration.getFieldByPosition(1);
        Field vital_status_field = ruleConfiguration.getFieldByPosition(2);
        Field surv_time_field = ruleConfiguration.getFieldByPosition(3);
        Field yoi_field = ruleConfiguration.getFieldByPosition(5);
        Field moi_field = ruleConfiguration.getFieldByPosition(4);
        Field yof_field = ruleConfiguration.getFieldByPosition(7);
        Field mof_field = ruleConfiguration.getFieldByPosition(6);
        String bod = this.getFieldValue(bod_field);
        String vital_status = this.getFieldValue(vital_status_field);
        String surv_time = this.getFieldValue(surv_time_field);
        String yoi = this.getFieldValue(yoi_field);
        String moi = this.getFieldValue(moi_field);
        String yof = this.getFieldValue(yof_field);
        String mof = this.getFieldValue(mof_field);
        if (this.isEmpty(bod)) {
            return this.getRuleOutput();
        }
        int bod_int = this.parseIntegerValue(bod);
        int vital_status_int = this.parseIntegerValue(vital_status);
        int surv_time_int = this.parseIntegerValue(surv_time);
        int yoi_int = this.parseIntegerValue(yoi);
        int moi_int = this.parseIntegerValue(moi);
        int yof_int = this.parseIntegerValue(yof);
        int mof_int = this.parseIntegerValue(mof);
        if (!(this.isValidAndNotUnknownField(bod_field, bod) && this.isValidAndNotUnknownField(vital_status_field, vital_status) && this.isValidAndNotUnknownField(surv_time_field, surv_time) && this.isValidAndNotUnknownField(yoi_field, yoi) && this.isValidAndNotUnknownField(moi_field, moi) && this.isValidAndNotUnknownField(yof_field, yof) && this.isValidAndNotUnknownField(mof_field, mof))) {
            return this.getRuleOutput();
        }
        if (bod_int == 0 && (vital_status_int == 1 || surv_time_int > 0 || moi_int != mof_int || yoi_int != yof_int)) {
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(bod_field, bod));
            fieldValues.add(new FieldValue(vital_status_field, vital_status));
            fieldValues.add(new FieldValue(surv_time_field, surv_time));
            fieldValues.add(new FieldValue(yoi_field, yoi));
            fieldValues.add(new FieldValue(moi_field, moi));
            fieldValues.add(new FieldValue(yof_field, yof));
            fieldValues.add(new FieldValue(mof_field, mof));
            this.addErrorDetail(fieldValues);
            return this.getRuleOutput();
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2020.INCIDENCE_BOD.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2020.INCIDENCE_VITAL_STATUS.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2020.INCIDENCE_SURVIVAL.id, false);
        RuleParameter param4 = new RuleParameter(4, DefaultFieldIDencr2020.INCIDENCE_MONTH_DOI.id, false);
        RuleParameter param5 = new RuleParameter(5, DefaultFieldIDencr2020.INCIDENCE_YEAR_DOI.id, false);
        RuleParameter param6 = new RuleParameter(6, DefaultFieldIDencr2020.INCIDENCE_MONTH_FU.id, false);
        RuleParameter param7 = new RuleParameter(7, DefaultFieldIDencr2020.INCIDENCE_YEAR_FU.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        defaultRuleParameters.add(param4);
        defaultRuleParameters.add(param5);
        defaultRuleParameters.add(param6);
        defaultRuleParameters.add(param7);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MANDATORY.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MAX_SIZE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_UNKNOWN_VALUE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_RANGE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
    }
}

