/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2020;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutopsyVitalStatus
extends CrossFieldRule {
    protected static Logger logger = LoggerFactory.getLogger(AutopsyVitalStatus.class);

    public AutopsyVitalStatus(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule validates that Autopsy and Vital Status are consistent and applies if autopsy=1 e vit_status!=2.\n\n");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field autopsy_field = ruleConfiguration.getFieldByPosition(1);
        Field vital_status_field = ruleConfiguration.getFieldByPosition(2);
        Field surv_time_field = ruleConfiguration.getFieldByPosition(3);
        Field yoi_field = ruleConfiguration.getFieldByPosition(5);
        Field moi_field = ruleConfiguration.getFieldByPosition(4);
        Field yof_field = ruleConfiguration.getFieldByPosition(7);
        Field mof_field = ruleConfiguration.getFieldByPosition(6);
        String autopsy = this.getFieldValue(autopsy_field);
        String vital_status = this.getFieldValue(vital_status_field);
        String surv_time = this.getFieldValue(surv_time_field);
        String yoi = this.getFieldValue(yoi_field);
        String moi = this.getFieldValue(moi_field);
        String yof = this.getFieldValue(yof_field);
        String mof = this.getFieldValue(mof_field);
        if (this.isEmpty(autopsy)) {
            return this.getRuleOutput();
        }
        int autopsy_int = this.parseIntegerValue(autopsy);
        int vital_status_int = this.parseIntegerValue(vital_status);
        int surv_time_int = this.parseIntegerValue(surv_time);
        int yoi_int = this.parseIntegerValue(yoi);
        int moi_int = this.parseIntegerValue(moi);
        int yof_int = this.parseIntegerValue(yof);
        int mof_int = this.parseIntegerValue(mof);
        logger.debug("Rule E-AUVS check: " + autopsy_int + " " + vital_status_int + " " + surv_time + " " + yoi_int + " " + moi_int);
        if (!(this.isValidAndNotUnknownField(autopsy_field, autopsy) && this.isValidAndNotUnknownField(vital_status_field, vital_status) && this.isValidAndNotUnknownField(surv_time_field, surv_time) && this.isValidAndNotUnknownField(yoi_field, yoi) && this.isValidAndNotUnknownField(moi_field, moi) && this.isValidAndNotUnknownField(yof_field, yof) && this.isValidAndNotUnknownField(mof_field, mof))) {
            logger.debug("" + this.isValidAndNotUnknownField(autopsy_field, autopsy));
            logger.debug("" + this.isValidAndNotUnknownField(vital_status_field, vital_status));
            logger.debug("" + this.isValidAndNotUnknownField(surv_time_field, surv_time));
            logger.debug("" + this.isValidAndNotUnknownField(yoi_field, yoi));
            logger.debug("" + this.isValidAndNotUnknownField(moi_field, moi));
            logger.debug("" + this.isValidAndNotUnknownField(yof_field, yof));
            logger.debug("" + this.isValidAndNotUnknownField(mof_field, mof));
            logger.debug("Rule E-AUVS not applicable: " + autopsy_int + " " + vital_status_int + " " + surv_time + " " + yoi_int + " " + moi_int + " " + yof_int + " " + mof_int);
            return this.getRuleOutput();
        }
        if (autopsy_int == 1 && (vital_status_int == 1 || surv_time_int > 0 || moi_int != mof_int || yoi_int != yof_int)) {
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(autopsy_field, autopsy));
            fieldValues.add(new FieldValue(vital_status_field, vital_status));
            fieldValues.add(new FieldValue(surv_time_field, surv_time));
            fieldValues.add(new FieldValue(yoi_field, yoi));
            fieldValues.add(new FieldValue(moi_field, moi));
            fieldValues.add(new FieldValue(yof_field, yof));
            fieldValues.add(new FieldValue(mof_field, mof));
            this.addErrorDetail(fieldValues);
            return this.getRuleOutput();
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2020.INCIDENCE_AUTOPSY.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2020.INCIDENCE_VITAL_STATUS.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2020.INCIDENCE_SURVIVAL.id, false);
        RuleParameter param4 = new RuleParameter(4, DefaultFieldIDencr2020.INCIDENCE_MONTH_DOI.id, false);
        RuleParameter param5 = new RuleParameter(5, DefaultFieldIDencr2020.INCIDENCE_YEAR_DOI.id, false);
        RuleParameter param6 = new RuleParameter(6, DefaultFieldIDencr2020.INCIDENCE_MONTH_FU.id, false);
        RuleParameter param7 = new RuleParameter(7, DefaultFieldIDencr2020.INCIDENCE_YEAR_FU.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        defaultRuleParameters.add(param4);
        defaultRuleParameters.add(param5);
        defaultRuleParameters.add(param6);
        defaultRuleParameters.add(param7);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MANDATORY.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MAX_SIZE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_UNKNOWN_VALUE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_RANGE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
    }
}

