/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020;

import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleException;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020.CrossFieldRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AgeTumourRuleHybrid
extends CrossFieldRule {
    List<Set<String>> ageSetList = new ArrayList<Set<String>>();
    List<Set<String>> morphologySetList = new ArrayList<Set<String>>();
    List<String> behList = new ArrayList<String>();
    List<Set<String>> topographySetList = new ArrayList<Set<String>>();
    public static final int DISABLED = 0;
    public static final int HYBRID = 1;
    public static final String DISABLED_LABEL = "disabled";
    public static final String HYBRID_LABEL = "hybrid 2023";
    protected static Logger logger = LoggerFactory.getLogger(AgeTumourRuleHybrid.class);

    public AgeTumourRuleHybrid(RuleDefinition rule) {
        super(rule);
        if (!this.init()) {
            throw new InvalidRuleException("Initialization error");
        }
    }

    protected boolean init() {
        RuleConfiguration ruleConfiguration;
        List<LocalFile> files;
        if (logger.isDebugEnabled()) {
            logger.debug("init() - AgeTumourRuleHybrid : loading config data");
        }
        if (!this.loadTable3ConsistencyRules((files = (ruleConfiguration = this.getRuleConfiguration()).getConfigurationFiles()).get(0).getFileName())) {
            logger.error("init() - Error loading configuration of Table 2 consistency rules");
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("init() - AgeTumourRuleHybrid : loaded config data");
        }
        return true;
    }

    @Override
    public List<RuleOutput> applyCheck() {
        if (logger.isDebugEnabled()) {
            logger.debug("applyCheck() - starting now");
        }
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field age_field = ruleConfiguration.getFieldByPosition(1);
        Field morphology_field = ruleConfiguration.getFieldByPosition(2);
        Field topography_field = ruleConfiguration.getFieldByPosition(3);
        Field monthDoB_field = ruleConfiguration.getFieldByPosition(4);
        Field yearDoB_field = ruleConfiguration.getFieldByPosition(5);
        Field monthDoI_field = ruleConfiguration.getFieldByPosition(6);
        Field yearDoI_field = ruleConfiguration.getFieldByPosition(7);
        Field beh_field = ruleConfiguration.getFieldByPosition(8);
        String age = this.getFieldValue(age_field);
        String morphology = this.getFieldValue(morphology_field);
        String topography = this.getFieldValue(topography_field);
        String monthDoB = this.getFieldValue(monthDoB_field);
        String yearDoB = this.getFieldValue(yearDoB_field);
        String monthDoI = this.getFieldValue(monthDoI_field);
        String yearDoI = this.getFieldValue(yearDoI_field);
        String beh = this.getFieldValue(beh_field);
        Field ageCalculatedField = ruleConfiguration.getFieldByPosition(8);
        int ageFunctionID = ageCalculatedField.getFunctionID();
        if (logger.isDebugEnabled()) {
            logger.debug("applyCheck() - Using ageFunctionID = " + ageFunctionID);
        }
        if (this.containOneEmptyElement(new String[]{morphology, topography})) {
            return this.getRuleOutput();
        }
        if (age_field.isEmpty(age)) {
            if (this.containOneEmptyElement(new String[]{monthDoB, yearDoB, monthDoI, yearDoI})) {
                return this.getRuleOutput();
            }
            DataRecord record = (DataRecord)this.ruleInput;
            age = record.getFunctionValue(ageFunctionID);
        }
        if (!this.isCaseSensitive(topography_field)) {
            topography = topography.toUpperCase();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("applyCheck(): " + age + " " + topography + " " + morphology + " beh: " + beh);
        }
        for (int i = 0; i < this.ageSetList.size(); ++i) {
            if (!this.ageSetList.get(i).contains(age) || (this.morphologySetList.get(i).size() != 1 || !this.morphologySetList.get(i).contains("-")) && !this.morphologySetList.get(i).contains(morphology) || (this.topographySetList.get(i).size() != 1 || !this.topographySetList.get(i).contains("-")) && !this.topographySetList.get(i).contains(topography) || !this.behList.get(i).contains("-") && !this.behList.get(i).equals(beh)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("applyCheck() - INVALID - Morphology: " + morphology + "  Topography: " + topography + "  Age: " + age + " Beh: " + beh);
            }
            topography = this.getFieldValue(topography_field);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(age_field, age));
            if (this.topographySetList.get(i).contains(topography)) {
                fieldValues.add(new FieldValue(topography_field, topography));
            }
            if (this.morphologySetList.get(i).contains(morphology)) {
                fieldValues.add(new FieldValue(morphology_field, morphology));
            }
            if (this.behList.get(i).equals(beh)) {
                fieldValues.add(new FieldValue(beh_field, beh));
            }
            this.addErrorDetail(fieldValues);
            return this.getRuleOutput();
        }
        return this.getRuleOutput();
    }

    public boolean loadTable3ConsistencyRules(String fileName) {
        boolean debug;
        int i;
        List<String> configData = this.loadConfigurationData(fileName);
        if (configData == null) {
            return false;
        }
        String[][] matrix = new String[configData.size()][4];
        for (i = 0; i < configData.size(); ++i) {
            matrix[i] = configData.get(i).split(";");
            if (!logger.isTraceEnabled()) continue;
            logger.trace("loadTable3ConsistencyRules() - Loaded line: " + i + " -> " + Arrays.toString(matrix[i]));
        }
        for (i = 0; i < matrix.length; ++i) {
            HashSet<String> itemAge = new HashSet<String>();
            String[] ageBounds = matrix[i][0].split("-");
            int lowAge = Integer.parseInt(ageBounds[0]);
            int highAge = Integer.parseInt(ageBounds[1]);
            for (int j = lowAge; j < highAge; ++j) {
                itemAge.add(String.valueOf(j));
            }
            this.ageSetList.add(itemAge);
            HashSet<String> itemMorphology = new HashSet<String>();
            String[] groupMorphology = matrix[i][1].split(",");
            if (groupMorphology[0].equals("-")) {
                itemMorphology.add("-");
            } else {
                itemMorphology = new HashSet();
                for (int j = 0; j < groupMorphology.length; ++j) {
                    String[] morphologyItem = groupMorphology[j].split("-");
                    if (morphologyItem.length == 1) {
                        itemMorphology.add(morphologyItem[0]);
                        continue;
                    }
                    int lowMorphology = Integer.parseInt(morphologyItem[0]);
                    int highMorphology = Integer.parseInt(morphologyItem[1]);
                    for (int z = lowMorphology; z <= highMorphology; ++z) {
                        itemMorphology.add(String.valueOf(z));
                    }
                }
            }
            this.morphologySetList.add(itemMorphology);
            this.behList.add(matrix[i][2]);
            HashSet<Object> itemTopography = new HashSet<Object>();
            String[] groupTopography = matrix[i][3].split(",");
            if ("-".equals(groupTopography[0])) {
                itemTopography.add("-");
            } else {
                itemTopography = new HashSet();
                for (int j = 0; j < groupTopography.length; ++j) {
                    int upLimit;
                    int lowLimit;
                    String[] topographyItem;
                    if (groupTopography[j].length() == 3) {
                        groupTopography[j] = groupTopography[j] + "0-" + groupTopography[j] + "9";
                    }
                    if ((topographyItem = groupTopography[j].split("-")).length == 1) {
                        if (topographyItem[0].contains("*")) {
                            lowLimit = Integer.parseInt(topographyItem[0].substring(1, 3) + "0");
                            upLimit = Integer.parseInt(topographyItem[0].substring(1, 3) + "9");
                            for (int zz = lowLimit; zz <= upLimit; ++zz) {
                                itemTopography.add("C" + String.format("%03d", zz));
                            }
                            continue;
                        }
                        itemTopography.add(topographyItem[0]);
                        continue;
                    }
                    if (topographyItem[0].contains("*")) {
                        topographyItem[0] = topographyItem[0].replace('*', '0');
                    }
                    if (topographyItem[1].contains("*")) {
                        topographyItem[1] = topographyItem[1].replace('*', '9');
                    }
                    if (topographyItem[0].length() == 3) {
                        topographyItem[0] = topographyItem[0] + "0";
                    }
                    if (topographyItem[1].length() == 3) {
                        topographyItem[1] = topographyItem[1] + "9";
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("loadTable3ConsistencyRules() - Topography items: " + topographyItem[0] + "-" + topographyItem[1]);
                    }
                    lowLimit = Integer.parseInt(topographyItem[0].substring(1, 4));
                    upLimit = Integer.parseInt(topographyItem[1].substring(1, 4));
                    for (int z = lowLimit; z <= upLimit; ++z) {
                        itemTopography.add("C" + String.format("%03d", z));
                    }
                }
            }
            this.topographySetList.add(itemTopography);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("loadTable3ConsistencyRules() - Loaded configuration file");
        }
        if (debug = false) {
            logger.info("loadTable3ConsistencyRules() - Age set size: " + this.ageSetList.size());
            for (int i2 = 0; i2 < this.ageSetList.size(); ++i2) {
                logger.trace("loadTable3ConsistencyRules() - Set[" + i2 + "] -> " + String.valueOf(this.ageSetList.get(i2)));
            }
        }
        return true;
    }

    @Override
    protected void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MANDATORY.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MAX_SIZE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_UNKNOWN_VALUE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_RANGE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
        this.ruleConfiguration.setConfigurationPath("config/rules/encr2014");
        ArrayList<LocalFile> files = new ArrayList<LocalFile>();
        files.add(new LocalFile("AgeTumourRule.csv", "", "", "Age Tumor (tab. 2) error code W-AGMT"));
        this.ruleConfiguration.setConfigurationFiles(files);
    }

    public static String getImplementationType(int typeID) {
        switch (typeID) {
            case 0: {
                return DISABLED_LABEL;
            }
            case 1: {
                return HYBRID_LABEL;
            }
        }
        logger.warn("getImplementationType() - Unsupported type ID :" + typeID);
        return "Unknown";
    }
}

