/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2020;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgeBirthIncidenceRule4
extends CrossFieldRule {
    protected static Logger logger = LoggerFactory.getLogger(AgeBirthIncidenceRule4.class);

    public AgeBirthIncidenceRule4(RuleDefinition ruleDefinition) {
        super(ruleDefinition);
        this.setLongDescription("The rule verifies if Date of Incidence and Date of Birth are valid, therefore age can be calculated as (Date of Incidence - Date of Birth).\nIn this way, if the original Age value is not available (e.g. missing or wrong) and we cannot even calculate the age as the difference between DoI and DoB, an E-AGEC error is raised.");
    }

    @Override
    protected List<RuleOutput> applyCheck() {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field age_field = ruleConfiguration.getFieldByPosition(1);
        Field yearDoB_field = ruleConfiguration.getFieldByPosition(3);
        Field yearDoI_field = ruleConfiguration.getFieldByPosition(5);
        String age = this.getFieldValue(age_field);
        String yearDoB = this.getFieldValue(yearDoB_field);
        String yearDoI = this.getFieldValue(yearDoI_field);
        if (this.isValidAndDefinedField(age_field, age)) {
            return this.getRuleOutput();
        }
        boolean isValid = true;
        boolean emptyMonthOrYearIn_DoB_DoI = this.containOneEmptyElement(new String[]{yearDoB, yearDoI});
        if (!emptyMonthOrYearIn_DoB_DoI) {
            if (!this.isValidAndDefinedField(yearDoB_field, yearDoB) || !this.isValidAndDefinedField(yearDoI_field, yearDoI)) {
                isValid = false;
                if (logger.isDebugEnabled()) {
                    logger.debug("Some invalid variables in dates - YoB: " + yearDoB + " - YoI: " + yearDoI + " (Age: " + age + ")");
                }
            }
        } else {
            isValid = false;
        }
        if (!isValid) {
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(age_field, age));
            fieldValues.add(new FieldValue(yearDoB_field, yearDoB));
            fieldValues.add(new FieldValue(yearDoI_field, yearDoI));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    @Override
    protected void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2020.INCIDENCE_AGE.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2020.INCIDENCE_MONTH_DOB.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2020.INCIDENCE_YEAR_DOB.id, false);
        RuleParameter param4 = new RuleParameter(4, DefaultFieldIDencr2020.INCIDENCE_MONTH_DOI.id, false);
        RuleParameter param5 = new RuleParameter(5, DefaultFieldIDencr2020.INCIDENCE_YEAR_DOI.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        defaultRuleParameters.add(param4);
        defaultRuleParameters.add(param5);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MAX_SIZE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_RANGE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
    }
}

