/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2020;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2020.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgeBirthIncidenceRule3
extends CrossFieldRule {
    protected static Logger logger = LoggerFactory.getLogger(AgeBirthIncidenceRule3.class);

    public AgeBirthIncidenceRule3(RuleDefinition ruleDefinition) {
        super(ruleDefinition);
        this.setLongDescription("The rule calculates the age as (Date of Incidence - Date of Birth) in years and it compares it with the Age value provided in the record.\n\nThe Calculated Age must not differ more than one year from the Age value provided.");
    }

    @Override
    protected List<RuleOutput> applyCheck() {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field age_field = ruleConfiguration.getFieldByPosition(1);
        Field monthDoB_field = ruleConfiguration.getFieldByPosition(2);
        Field yearDoB_field = ruleConfiguration.getFieldByPosition(3);
        Field monthDoI_field = ruleConfiguration.getFieldByPosition(4);
        Field yearDoI_field = ruleConfiguration.getFieldByPosition(5);
        String age = this.getFieldValue(age_field);
        String monthDoB = this.getFieldValue(monthDoB_field);
        String yearDoB = this.getFieldValue(yearDoB_field);
        String monthDoI = this.getFieldValue(monthDoI_field);
        String yearDoI = this.getFieldValue(yearDoI_field);
        if (this.isEmpty(age)) {
            return this.getRuleOutput();
        }
        boolean isValid = true;
        boolean emptyMonthOrYearIn_DoB_DoI = this.containOneEmptyElement(new String[]{monthDoB, yearDoB, monthDoI, yearDoI});
        if (!(emptyMonthOrYearIn_DoB_DoI || age_field.isUnknownValue(age) || yearDoB_field.isUnknownValue(yearDoB) || yearDoI_field.isUnknownValue(yearDoI))) {
            int age_int;
            int ageCalculated = 0;
            boolean isAgeCalculated = true;
            if (this.isValidAndNotUnknownField(monthDoB_field, monthDoB) && this.isValidAndNotUnknownField(monthDoI_field, monthDoI) && this.isValidField(yearDoB_field) && this.isValidField(yearDoI_field)) {
                int monthDoB_int = Integer.parseInt(monthDoB);
                int yearDoB_int = Integer.parseInt(yearDoB);
                int monthDoI_int = Integer.parseInt(monthDoI);
                int yearDoI_int = Integer.parseInt(yearDoI);
                if (logger.isDebugEnabled()) {
                    logger.debug("Calculating age with all values: " + monthDoB_int + "/" + yearDoB_int + " -> " + monthDoI_int + "/" + yearDoI_int);
                }
                ageCalculated = (yearDoI_int * 12 + monthDoI_int - (yearDoB_int * 12 + monthDoB_int)) / 12;
            } else if (this.isValidField(yearDoB_field) && this.isValidField(yearDoI_field)) {
                int yearDoB_int = Integer.parseInt(yearDoB);
                int yearDoI_int = Integer.parseInt(yearDoI);
                ageCalculated = yearDoI_int - yearDoB_int;
            } else {
                isAgeCalculated = false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Comparing Age (" + age + ") with calculated (" + ageCalculated + ")" + this.formatDates(monthDoB, yearDoB, monthDoI, yearDoI));
            }
            if (isAgeCalculated && this.isValidField(age_field) && Math.abs((age_int = this.parseIntegerValue(age)) - ageCalculated) > 1) {
                isValid = false;
                if (logger.isDebugEnabled()) {
                    logger.debug("Wrong difference - Age: " + age + "  Calculated: " + ageCalculated + this.formatDates(monthDoB, yearDoB, monthDoI, yearDoI));
                }
            }
        }
        if (!isValid) {
            return this.getInvalidRuleOutput();
        }
        return this.getRuleOutput();
    }

    @Override
    protected void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2020.INCIDENCE_AGE.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2020.INCIDENCE_MONTH_DOB.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2020.INCIDENCE_YEAR_DOB.id, false);
        RuleParameter param4 = new RuleParameter(4, DefaultFieldIDencr2020.INCIDENCE_MONTH_DOI.id, false);
        RuleParameter param5 = new RuleParameter(5, DefaultFieldIDencr2020.INCIDENCE_YEAR_DOI.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        defaultRuleParameters.add(param4);
        defaultRuleParameters.add(param5);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MANDATORY.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MAX_SIZE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_UNKNOWN_VALUE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_RANGE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
    }

    protected String formatDates(String monthDoB, String yearDoB, String monthDoI, String yearDoI) {
        StringBuilder builder = new StringBuilder();
        builder.append(" - DoB: ");
        builder.append(monthDoB);
        builder.append("/");
        builder.append(yearDoB);
        builder.append(" - DoI: ");
        builder.append(monthDoI);
        builder.append("/");
        builder.append(yearDoI);
        return builder.toString();
    }
}

