/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleException;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopographyLateralityRule
extends CrossFieldRule {
    protected List<String> configData;
    protected static Logger logger = LoggerFactory.getLogger(TopographyLateralityRule.class);

    public TopographyLateralityRule(RuleDefinition rule) {
        super(rule);
        if (!this.init()) {
            throw new InvalidRuleException("Initialization error");
        }
        this.setLongDescription("Calculates the difference (aka \"age\") between two dates.\n\n1. If any of the year variable is missing or empty, age is set to -1.\n2. If any of the day variable is empty or unknown, the value \"15\" is used to \"guess\" the day's value.\n3. If any of the month variable is missing or empty, the age is evaluated by comparing only the year variables.\n4. if all month and year variables are correctly defined but any of the day variable is wrong (wrong datatype or out of range), then the value 0 (zero) is used for both the days.\n\nIf all variables are correctly defined the age is evaluated using the normal common sense criterion.\n");
    }

    protected boolean init() {
        this.configData = this.loadConfigurationData(this.ruleConfiguration.getConfigurationFiles().get(0).getFileName());
        return this.configData != null;
    }

    @Override
    public List<RuleOutput> applyCheck() {
        String laterality;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field topography_field = ruleConfiguration.getFieldByPosition(1);
        Field laterality_field = ruleConfiguration.getFieldByPosition(2);
        String topography = this.getFieldValue(topography_field);
        if (this.containOneEmptyElement(new String[]{topography, laterality = this.getFieldValue(laterality_field)})) {
            return this.getRuleOutput();
        }
        if (topography.equals(" ")) {
            return this.getRuleOutput();
        }
        if (!this.isIntegerValue(laterality)) {
            return this.getRuleOutput();
        }
        if (!this.isCaseSensitive(topography_field)) {
            topography = topography.toUpperCase();
        }
        if (!this.isValidAndDefinedField(topography_field, topography)) {
            return this.getRuleOutput();
        }
        if (!this.isValidAndDefinedField(laterality_field, laterality)) {
            return this.getRuleOutput();
        }
        int lateralityInt = this.parseIntegerValue(laterality);
        boolean isValid = true;
        if (this.configData.contains(topography)) {
            if (lateralityInt < 1 || lateralityInt > 4) {
                isValid = false;
            }
        } else if (!topography.equals("C342") && lateralityInt >= 1 && lateralityInt < 4) {
            isValid = false;
        }
        if (isValid && topography.equals("C342") && lateralityInt != 1) {
            isValid = false;
        }
        if (!isValid) {
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID - topography: " + topography + "  laterality: " + laterality);
            }
            topography = this.getFieldValue(topography_field);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(topography_field, topography));
            fieldValues.add(new FieldValue(laterality_field, laterality));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_TOPOGRAPHY.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_LATERALITY.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MANDATORY.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MAX_SIZE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_UNKNOWN_VALUE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_RANGE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
        ArrayList<LocalFile> files = new ArrayList<LocalFile>();
        files.add(new LocalFile("TopographyLateralityRule.csv", "", "", "List of topography values allowed"));
        this.ruleConfiguration.setConfigurationFiles(files);
    }
}

