/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TNMNodesRule
extends CrossFieldRule {
    protected static Logger logger = LoggerFactory.getLogger(TNMNodesRule.class);

    public TNMNodesRule(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule checks the consistency bewteen TNM N and number of metastatic nodes.\n");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        String pn;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field metNodes_field = ruleConfiguration.getFieldByPosition(1);
        Field pn_field = ruleConfiguration.getFieldByPosition(2);
        String metNodes = this.getFieldValue(metNodes_field);
        if (this.containOneEmptyElement(new String[]{metNodes, pn = this.getFieldValue(pn_field)})) {
            return this.getRuleOutput();
        }
        if (!this.isValidAndDefinedField(metNodes_field, metNodes)) {
            return this.getRuleOutput();
        }
        if (!this.isValidAndDefinedField(pn_field, pn)) {
            return this.getRuleOutput();
        }
        int metNodesInt = this.parseIntegerValue(metNodes);
        if (metNodesInt > 0 && "0".equals(pn)) {
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID - metNodes: " + metNodes + " differs from  pN: " + pn);
            }
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(metNodes_field, metNodes));
            fieldValues.add(new FieldValue(pn_field, pn));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_N_MET_NODES.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_PN.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
    }
}

