/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurvivalIncidenceFollowupRule
extends CrossFieldRule {
    protected static Logger logger = LoggerFactory.getLogger(SurvivalIncidenceFollowupRule.class);

    public SurvivalIncidenceFollowupRule(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("The rule verifies if Date of Last Vital Status and Date of Incidence are valid, therefore Survival can be calculated as (Date of Followup - Date of Incidence).\nIn this way, if the original Survival value is not available (e.g. missing or wrong) and we cannot even calculate it as the difference between DoF and DoI, an E-MISS error is raised.");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        boolean emptyMonthOrYearIn_DoI_DoF;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field survival_field = ruleConfiguration.getFieldByPosition(1);
        Field monthDoI_field = ruleConfiguration.getFieldByPosition(2);
        Field yearDoI_field = ruleConfiguration.getFieldByPosition(3);
        Field monthFU_field = ruleConfiguration.getFieldByPosition(4);
        Field yearFU_field = ruleConfiguration.getFieldByPosition(5);
        String survival = this.getFieldValue(survival_field);
        String monthI = this.getFieldValue(monthDoI_field);
        String yearI = this.getFieldValue(yearDoI_field);
        String monthFU = this.getFieldValue(monthFU_field);
        String yearFU = this.getFieldValue(yearFU_field);
        boolean isValid = true;
        if ((this.isEmpty(survival) || this.isFieldSetToUnknownValue(survival_field, survival)) && ((emptyMonthOrYearIn_DoI_DoF = this.containOneEmptyElement(new String[]{monthI, yearI, monthFU, yearFU})) || this.isEmpty(monthI) || this.isFieldSetToUnknownValue(monthDoI_field, monthI) || this.isEmpty(yearI) || this.isFieldSetToUnknownValue(yearDoI_field, yearI) || this.isEmpty(monthFU) || this.isFieldSetToUnknownValue(monthFU_field, monthFU) || this.isEmpty(yearFU) || this.isFieldSetToUnknownValue(yearFU_field, yearFU))) {
            isValid = false;
        }
        if (!isValid) {
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID - Survival: " + survival + "  DoI: " + monthI + "/" + yearI + "  DoF: " + monthFU + "/" + yearFU);
            }
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(survival_field, survival));
            fieldValues.add(new FieldValue(monthDoI_field, monthI));
            fieldValues.add(new FieldValue(yearDoI_field, yearI));
            fieldValues.add(new FieldValue(monthFU_field, monthFU));
            fieldValues.add(new FieldValue(yearFU_field, yearFU));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_SURVIVAL.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_MONTH_DOI.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2014.INCIDENCE_YEAR_DOI.id, false);
        RuleParameter param4 = new RuleParameter(4, DefaultFieldIDencr2014.INCIDENCE_MONTH_FU.id, false);
        RuleParameter param5 = new RuleParameter(5, DefaultFieldIDencr2014.INCIDENCE_YEAR_FU.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        defaultRuleParameters.add(param4);
        defaultRuleParameters.add(param5);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MANDATORY.id);
        preparatoryRules.add(DefaultRuleID.FIELD_RANGE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
    }
}

