/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurvivalAnalysisRule
extends CrossFieldRule {
    protected static Logger logger = LoggerFactory.getLogger(SurvivalAnalysisRule.class);

    public SurvivalAnalysisRule(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule validates the combination of vital status, basis of diagnosis and autopsy.");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        ArrayList<FieldValue> fieldValues;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field vitalStatus_field = ruleConfiguration.getFieldByPosition(1);
        Field autopsy_field = ruleConfiguration.getFieldByPosition(2);
        Field bod_field = ruleConfiguration.getFieldByPosition(3);
        Field survival_field = ruleConfiguration.getFieldByPosition(4);
        Field monthDoI_field = ruleConfiguration.getFieldByPosition(5);
        Field yearDoI_field = ruleConfiguration.getFieldByPosition(6);
        Field monthFU_field = ruleConfiguration.getFieldByPosition(7);
        Field yearFU_field = ruleConfiguration.getFieldByPosition(8);
        Field tsize_field = ruleConfiguration.getFieldByPosition(9);
        Field examNodes_field = ruleConfiguration.getFieldByPosition(10);
        Field metNodes_field = ruleConfiguration.getFieldByPosition(11);
        Field pT_field = ruleConfiguration.getFieldByPosition(12);
        Field pN_field = ruleConfiguration.getFieldByPosition(13);
        Field pM_field = ruleConfiguration.getFieldByPosition(14);
        Field cT_field = ruleConfiguration.getFieldByPosition(15);
        Field cN_field = ruleConfiguration.getFieldByPosition(16);
        Field cM_field = ruleConfiguration.getFieldByPosition(17);
        Field condT_field = ruleConfiguration.getFieldByPosition(18);
        Field condN_field = ruleConfiguration.getFieldByPosition(19);
        Field condM_field = ruleConfiguration.getFieldByPosition(20);
        Field stage_field = ruleConfiguration.getFieldByPosition(21);
        Field eod_field = ruleConfiguration.getFieldByPosition(22);
        String vitalStatus = this.getFieldValue(vitalStatus_field);
        String autopsy = this.getFieldValue(autopsy_field);
        String bod = this.getFieldValue(bod_field);
        String survival = this.getFieldValue(survival_field);
        String monthDoI = this.getFieldValue(monthDoI_field);
        String yearDoI = this.getFieldValue(yearDoI_field);
        String monthFU = this.getFieldValue(monthFU_field);
        String yearFU = this.getFieldValue(yearFU_field);
        String tsize = this.getFieldValue(tsize_field);
        String examNodes = this.getFieldValue(examNodes_field);
        String metNodes = this.getFieldValue(metNodes_field);
        String pT = this.getFieldValue(pT_field);
        String pN = this.getFieldValue(pN_field);
        String pM = this.getFieldValue(pM_field);
        String cT = this.getFieldValue(cT_field);
        String cN = this.getFieldValue(cN_field);
        String cM = this.getFieldValue(cM_field);
        String condT = this.getFieldValue(condT_field);
        String condN = this.getFieldValue(condN_field);
        String condM = this.getFieldValue(condM_field);
        String stage = this.getFieldValue(stage_field);
        String eod = this.getFieldValue(eod_field);
        if (!this.isCaseSensitive(pT_field)) {
            pT = pT.toUpperCase();
        }
        if (!this.isCaseSensitive(pN_field)) {
            pN = pN.toUpperCase();
        }
        if (!this.isCaseSensitive(pM_field)) {
            pM = pM.toUpperCase();
        }
        if (!this.isCaseSensitive(cT_field)) {
            cT = cT.toUpperCase();
        }
        if (!this.isCaseSensitive(cN_field)) {
            cN = cN.toUpperCase();
        }
        if (!this.isCaseSensitive(cM_field)) {
            cM = cM.toUpperCase();
        }
        if (!this.isCaseSensitive(condT_field)) {
            condT = condT.toUpperCase();
        }
        if (!this.isCaseSensitive(condT_field)) {
            condN = condN.toUpperCase();
        }
        if (!this.isCaseSensitive(condM_field)) {
            condM = condM.toUpperCase();
        }
        if (!this.containOneEmptyElement(new String[]{vitalStatus, autopsy, bod}) && this.isValidAndNotUnknownField(autopsy_field, autopsy) && this.isValidAndNotUnknownField(bod_field, bod) && vitalStatus.equals("1") && (!autopsy.equals("0") || bod.equals("0"))) {
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID - BoD: " + bod + "  VitalStatus: " + vitalStatus + "  Autopsy: " + autopsy);
            }
            fieldValues = new ArrayList();
            fieldValues.add(new FieldValue(vitalStatus_field, vitalStatus));
            fieldValues.add(new FieldValue(autopsy_field, autopsy));
            fieldValues.add(new FieldValue(bod_field, bod));
            this.addErrorDetail(fieldValues);
        }
        if (!this.containOneEmptyElement(new String[]{bod}) && bod.equals("0")) {
            if (this.isEmpty(vitalStatus) || !vitalStatus.equals("2")) {
                if (logger.isDebugEnabled()) {
                    logger.debug("INVALID - BoD: " + bod + "  VitalStatus: " + vitalStatus);
                }
                fieldValues = new ArrayList<FieldValue>();
                fieldValues.add(new FieldValue(bod_field, bod));
                fieldValues.add(new FieldValue(vitalStatus_field, vitalStatus));
                this.addErrorDetail(fieldValues);
            } else if (!this.containOneEmptyElement(new String[]{survival, vitalStatus}) && this.isValidAndNotUnknownField(survival_field, survival) && this.isValidAndNotUnknownField(vitalStatus_field, vitalStatus)) {
                if (!this.containOneEmptyElement(new String[]{monthDoI, monthFU, yearDoI, yearFU}) && monthDoI.equals(monthFU) && yearDoI.equals(yearFU)) {
                    if (!survival.equals("0")) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("INVALID - BoD: " + bod + "  VitalStatus: " + vitalStatus + "  Survival: " + survival);
                        }
                        fieldValues = new ArrayList();
                        fieldValues.add(new FieldValue(bod_field, bod));
                        fieldValues.add(new FieldValue(vitalStatus_field, vitalStatus));
                        fieldValues.add(new FieldValue(survival_field, survival));
                        this.addErrorDetail(fieldValues);
                    } else if (!this.containOneEmptyElement(new String[]{tsize, examNodes, metNodes, pT, pN, pM, cT, cN, cM, condT, condN, condM, stage}) && (this.isValidAndNotUnknownField(cT_field, cT) || this.isValidAndNotUnknownField(cN_field, cN) || this.isValidAndNotUnknownField(pN_field, pN) || this.isValidAndNotUnknownField(cM_field, cM) || this.isValidAndNotUnknownField(pM_field, pM) || this.isValidAndNotUnknownField(condT_field, condT) && !"X".equals(condT) || this.isValidAndNotUnknownField(condN_field, condN) && !"X".equals(condN) || this.isValidAndNotUnknownField(condM_field, condM) && !"X".equals(condM) || this.isValidAndNotUnknownField(stage_field, stage) || this.isValidAndNotUnknownField(tsize_field, tsize) || this.isValidAndNotUnknownField(examNodes_field, examNodes) || this.isValidAndNotUnknownField(metNodes_field, metNodes))) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("INVALID - BoD: " + bod + "  VitalStatus: " + vitalStatus + "  Survival: " + survival + "  DoI: " + monthDoI + "/" + yearDoI + "  DoF: " + monthFU + "/" + yearFU + "  tsize: " + tsize + "  examNodes: " + examNodes + "  metNodes: " + metNodes + "  pTNM: " + pT + "/" + pN + "/" + pM + "  cTNM: " + cT + "/" + cN + "/" + cM + "  condNM: " + condM + "/" + condN + "  Stage: " + stage + "  EoD: " + eod);
                        }
                        fieldValues = new ArrayList();
                        fieldValues.add(new FieldValue(bod_field, bod));
                        fieldValues.add(new FieldValue(vitalStatus_field, vitalStatus));
                        fieldValues.add(new FieldValue(survival_field, survival));
                        fieldValues.add(new FieldValue(monthDoI_field, monthDoI));
                        fieldValues.add(new FieldValue(yearDoI_field, yearDoI));
                        fieldValues.add(new FieldValue(monthFU_field, monthFU));
                        fieldValues.add(new FieldValue(yearFU_field, yearFU));
                        fieldValues.add(new FieldValue(tsize_field, tsize));
                        fieldValues.add(new FieldValue(examNodes_field, examNodes));
                        fieldValues.add(new FieldValue(metNodes_field, metNodes));
                        fieldValues.add(new FieldValue(pT_field, pT));
                        fieldValues.add(new FieldValue(pN_field, pN));
                        fieldValues.add(new FieldValue(pM_field, pM));
                        fieldValues.add(new FieldValue(cT_field, cT));
                        fieldValues.add(new FieldValue(cN_field, cN));
                        fieldValues.add(new FieldValue(cM_field, cM));
                        fieldValues.add(new FieldValue(condM_field, condM));
                        fieldValues.add(new FieldValue(condN_field, condN));
                        fieldValues.add(new FieldValue(stage_field, stage));
                        fieldValues.add(new FieldValue(eod_field, eod));
                        this.addErrorDetail(fieldValues);
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("INVALID - BoD: " + bod + "  VitalStatus: " + vitalStatus + "  DoI: " + monthDoI + "/" + yearDoI + "  DoF: " + monthFU + "/" + yearFU);
                    }
                    fieldValues = new ArrayList();
                    fieldValues.add(new FieldValue(bod_field, bod));
                    fieldValues.add(new FieldValue(vitalStatus_field, vitalStatus));
                    fieldValues.add(new FieldValue(monthDoI_field, monthDoI));
                    fieldValues.add(new FieldValue(yearDoI_field, yearDoI));
                    fieldValues.add(new FieldValue(monthFU_field, monthFU));
                    fieldValues.add(new FieldValue(yearFU_field, yearFU));
                    this.addErrorDetail(fieldValues);
                }
            }
        }
        if (!this.containOneEmptyElement(new String[]{autopsy, vitalStatus, survival, monthDoI, monthFU, yearDoI, yearFU}) && this.isValidAndNotUnknownField(autopsy_field, autopsy) && this.isValidAndNotUnknownField(vitalStatus_field, vitalStatus) && !survival_field.isUnknownValue(survival) && this.isValidAndNotUnknownField(monthDoI_field, monthDoI) && this.isValidAndNotUnknownField(monthFU_field, monthFU) && this.isValidAndNotUnknownField(yearDoI_field, yearDoI) && this.isValidAndNotUnknownField(yearFU_field, yearFU) && autopsy.equals("1") && vitalStatus.equals("2") && (!survival.equals("0") || !monthDoI.equals(monthFU) || !yearDoI.equals(yearFU))) {
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID - autopsy: " + autopsy + "  VitalStatus: " + vitalStatus + "  survival: " + survival + "  DoI: " + monthDoI + "/" + yearDoI + "  DoF: " + monthFU + "/" + yearFU);
            }
            fieldValues = new ArrayList();
            fieldValues.add(new FieldValue(autopsy_field, autopsy));
            fieldValues.add(new FieldValue(vitalStatus_field, vitalStatus));
            fieldValues.add(new FieldValue(survival_field, survival));
            fieldValues.add(new FieldValue(monthDoI_field, monthDoI));
            fieldValues.add(new FieldValue(yearDoI_field, yearDoI));
            fieldValues.add(new FieldValue(monthFU_field, monthFU));
            fieldValues.add(new FieldValue(yearFU_field, yearFU));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_VITAL_STATUS.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_AUTOPSY.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2014.INCIDENCE_BOD.id, false);
        RuleParameter param4 = new RuleParameter(4, DefaultFieldIDencr2014.INCIDENCE_SURVIVAL.id, false);
        RuleParameter param5 = new RuleParameter(5, DefaultFieldIDencr2014.INCIDENCE_MONTH_DOI.id, false);
        RuleParameter param6 = new RuleParameter(6, DefaultFieldIDencr2014.INCIDENCE_YEAR_DOI.id, false);
        RuleParameter param7 = new RuleParameter(7, DefaultFieldIDencr2014.INCIDENCE_MONTH_FU.id, false);
        RuleParameter param8 = new RuleParameter(8, DefaultFieldIDencr2014.INCIDENCE_YEAR_FU.id, false);
        RuleParameter param9 = new RuleParameter(9, DefaultFieldIDencr2014.INCIDENCE_TSIZE.id, false);
        RuleParameter param10 = new RuleParameter(10, DefaultFieldIDencr2014.INCIDENCE_N_EXAM_NODES.id, false);
        RuleParameter param11 = new RuleParameter(11, DefaultFieldIDencr2014.INCIDENCE_N_MET_NODES.id, false);
        RuleParameter param12 = new RuleParameter(12, DefaultFieldIDencr2014.INCIDENCE_PT.id, false);
        RuleParameter param13 = new RuleParameter(13, DefaultFieldIDencr2014.INCIDENCE_PN.id, false);
        RuleParameter param14 = new RuleParameter(14, DefaultFieldIDencr2014.INCIDENCE_PM.id, false);
        RuleParameter param15 = new RuleParameter(15, DefaultFieldIDencr2014.INCIDENCE_CT.id, false);
        RuleParameter param16 = new RuleParameter(16, DefaultFieldIDencr2014.INCIDENCE_CN.id, false);
        RuleParameter param17 = new RuleParameter(17, DefaultFieldIDencr2014.INCIDENCE_CM.id, false);
        RuleParameter param18 = new RuleParameter(18, DefaultFieldIDencr2014.INCIDENCE_CONDENSED_T.id, false);
        RuleParameter param19 = new RuleParameter(19, DefaultFieldIDencr2014.INCIDENCE_CONDENSED_N.id, false);
        RuleParameter param20 = new RuleParameter(20, DefaultFieldIDencr2014.INCIDENCE_CONDENSED_M.id, false);
        RuleParameter param21 = new RuleParameter(21, DefaultFieldIDencr2014.INCIDENCE_STAGE.id, false);
        RuleParameter param22 = new RuleParameter(22, DefaultFieldIDencr2014.INCIDENCE_EOD.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        defaultRuleParameters.add(param4);
        defaultRuleParameters.add(param5);
        defaultRuleParameters.add(param6);
        defaultRuleParameters.add(param7);
        defaultRuleParameters.add(param8);
        defaultRuleParameters.add(param9);
        defaultRuleParameters.add(param10);
        defaultRuleParameters.add(param11);
        defaultRuleParameters.add(param12);
        defaultRuleParameters.add(param13);
        defaultRuleParameters.add(param14);
        defaultRuleParameters.add(param15);
        defaultRuleParameters.add(param16);
        defaultRuleParameters.add(param17);
        defaultRuleParameters.add(param18);
        defaultRuleParameters.add(param19);
        defaultRuleParameters.add(param20);
        defaultRuleParameters.add(param21);
        defaultRuleParameters.add(param22);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
    }
}

