/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleException;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SexTopographyRule
extends CrossFieldRule {
    protected List<String> configDataMale = null;
    protected List<String> configDataFemale = null;
    protected static Logger logger = LoggerFactory.getLogger(SexTopographyRule.class);

    public SexTopographyRule(RuleDefinition rule) {
        super(rule);
        if (!this.init()) {
            throw new InvalidRuleException("Initialization error");
        }
        this.setLongDescription("This rule validates the combination of sex and topography.");
    }

    protected boolean init() {
        this.configDataMale = this.loadConfigurationData(this.ruleConfiguration.getConfigurationFiles().get(0).getFileName());
        if (this.configDataMale == null) {
            return false;
        }
        this.configDataFemale = this.loadConfigurationData(this.ruleConfiguration.getConfigurationFiles().get(1).getFileName());
        return this.configDataFemale != null;
    }

    @Override
    public List<RuleOutput> applyCheck() {
        String sex;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field topography_field = ruleConfiguration.getFieldByPosition(1);
        Field sex_field = ruleConfiguration.getFieldByPosition(2);
        String topography = this.getFieldValue(topography_field);
        if (this.containOneEmptyElement(new String[]{topography, sex = this.getFieldValue(sex_field)})) {
            return this.getRuleOutput();
        }
        if (this.isEmpty(topography)) {
            return this.getRuleOutput();
        }
        if (!this.isInteger(sex)) {
            return this.getRuleOutput();
        }
        if (!this.isCaseSensitive(topography_field)) {
            topography = topography.toUpperCase();
        }
        boolean isValid = true;
        if ("1".equals(sex)) {
            if (this.configDataMale.contains(topography)) {
                isValid = false;
            }
        } else if ("2".equals(sex) && this.configDataFemale.contains(topography)) {
            isValid = false;
        }
        if (!isValid) {
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID - Topography: " + topography + "  Sex: " + sex);
            }
            topography = this.getFieldValue(topography_field);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(sex_field, sex));
            fieldValues.add(new FieldValue(topography_field, topography));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_TOPOGRAPHY.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_SEX.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<LocalFile> files = new ArrayList<LocalFile>();
        files.add(new LocalFile("SexTopographyRule1.csv", "", "", "List of topography values forbidden for sex = 1"));
        files.add(new LocalFile("SexTopographyRule2.csv", "", "", "List of topography values forbidden for sex = 2"));
        this.ruleConfiguration.setConfigurationFiles(files);
    }
}

