/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleException;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SexMorphologyRule
extends CrossFieldRule {
    protected List<String> configDataMale = null;
    protected List<String> configDataFemale = null;
    protected static Logger logger = LoggerFactory.getLogger(SexMorphologyRule.class);

    public SexMorphologyRule(RuleDefinition rule) {
        super(rule);
        if (!this.init()) {
            throw new InvalidRuleException("Initialization error");
        }
        this.setLongDescription("This rule validates the combination of sex and morphology.\n\ne.g. female with seminoma.");
    }

    protected boolean init() {
        this.configDataMale = this.loadConfigurationData(this.ruleConfiguration.getConfigurationFiles().get(0).getFileName());
        if (this.configDataMale == null) {
            return false;
        }
        this.configDataFemale = this.loadConfigurationData(this.ruleConfiguration.getConfigurationFiles().get(1).getFileName());
        return this.configDataFemale != null;
    }

    @Override
    public List<RuleOutput> applyCheck() {
        String sex;
        String behaviour;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field morphology_field = ruleConfiguration.getFieldByPosition(1);
        Field behaviour_field = ruleConfiguration.getFieldByPosition(2);
        Field sex_field = ruleConfiguration.getFieldByPosition(3);
        String morphology = this.getFieldValue(morphology_field);
        if (this.containOneEmptyElement(new String[]{morphology, behaviour = this.getFieldValue(behaviour_field), sex = this.getFieldValue(sex_field)})) {
            return this.getRuleOutput();
        }
        if (!(this.isInteger(sex) && this.isInteger(behaviour) && this.isInteger(morphology))) {
            return this.getRuleOutput();
        }
        boolean isValid = true;
        if (behaviour.equals("3")) {
            if ("1".equals(sex)) {
                if (this.configDataMale.contains(morphology)) {
                    isValid = false;
                }
            } else if ("2".equals(sex) && this.configDataFemale.contains(morphology)) {
                isValid = false;
            }
        }
        if (!isValid) {
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID - Morphology: " + morphology + "  Behaviour: " + behaviour + "  Sex: " + sex);
            }
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(morphology_field, morphology));
            fieldValues.add(new FieldValue(behaviour_field, behaviour));
            fieldValues.add(new FieldValue(sex_field, sex));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_MORPHOLOGY.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_BEHAVIOUR.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2014.INCIDENCE_SEX.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<LocalFile> files = new ArrayList<LocalFile>();
        files.add(new LocalFile("SexMorphologyRule1.csv", "", "", "List of morphology values forbidden for sex = 1 and behaviour = 3"));
        files.add(new LocalFile("SexMorphologyRule2.csv", "", "", "List of morphology values forbidden for sex = 2 and behaviour = 3"));
        this.ruleConfiguration.setConfigurationFiles(files);
    }
}

