/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NMetExamNodesRule
extends CrossFieldRule {
    protected static Logger logger = LoggerFactory.getLogger(NMetExamNodesRule.class);

    public NMetExamNodesRule(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule validates the combination of metastatic nodes and examination nodes.");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        String examNodes;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field metNodes_field = ruleConfiguration.getFieldByPosition(1);
        Field examNodes_field = ruleConfiguration.getFieldByPosition(2);
        String metNodes = this.getFieldValue(metNodes_field);
        if (this.containOneEmptyElement(new String[]{metNodes, examNodes = this.getFieldValue(examNodes_field)})) {
            return this.getRuleOutput();
        }
        if (!this.isIntegerValue(metNodes) || this.isIntegerValue(examNodes)) {
            return this.getRuleOutput();
        }
        int metNodesInt = this.parseIntegerValue(metNodes);
        int examNodesInt = this.parseIntegerValue(examNodes);
        if (metNodesInt < 0 || metNodesInt > examNodesInt) {
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID - metNodes: " + metNodes + "  examNodes: " + examNodes);
            }
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(metNodes_field, metNodes));
            fieldValues.add(new FieldValue(examNodes_field, examNodes));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_N_MET_NODES.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_N_EXAM_NODES.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
    }
}

