/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleException;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphologyTopographyRule
extends CrossFieldRule {
    protected List<String> forbiddenValues = null;
    protected List<String> allowedValues = null;
    protected List<String> notAllowedCombinations = null;
    protected List<String> allowedCombinations = null;
    protected static Logger logger = LoggerFactory.getLogger(MorphologyTopographyRule.class);

    public MorphologyTopographyRule(RuleDefinition rule) {
        super(rule);
        if (!this.init()) {
            throw new InvalidRuleException("Initialization error");
        }
        this.setLongDescription("The rule first checks the 1st config file (list of wrong combinations): if morphology (the 'key') is found, and the topography DOES match that morphology, this rule raises a warning. If not found, then the rule checks if the morphology is found in the 2nd config file (list of valid combinations). If the morphology is found but the topography does NOT match it, this rule raises a warning.");
    }

    protected boolean init() {
        int pos;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        List<LocalFile> files = ruleConfiguration.getConfigurationFiles();
        LocalFile notAllowedList = files.get(0);
        String notAllowedListFileName = notAllowedList.getFileName();
        LocalFile allowedList = files.get(1);
        String allowedListFileName = allowedList.getFileName();
        this.forbiddenValues = this.loadConfigurationData(notAllowedListFileName);
        if (this.forbiddenValues == null) {
            return false;
        }
        this.allowedValues = this.loadConfigurationData(allowedListFileName);
        if (this.allowedValues == null) {
            return false;
        }
        this.notAllowedCombinations = new ArrayList<String>();
        for (String line : this.forbiddenValues) {
            pos = line.indexOf(59);
            if (pos >= 0) {
                line = line.substring(0, pos);
            }
            this.notAllowedCombinations.add(line);
        }
        this.allowedCombinations = new ArrayList<String>();
        for (String line : this.allowedValues) {
            pos = line.indexOf(59);
            if (pos >= 0) {
                line = line.substring(0, pos);
            }
            this.allowedCombinations.add(line);
        }
        return true;
    }

    @Override
    public List<RuleOutput> applyCheck() {
        String topography2;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field topography_field = ruleConfiguration.getFieldByPosition(1);
        Field morphology_field = ruleConfiguration.getFieldByPosition(2);
        String topography = this.getFieldValue(topography_field);
        String morphology = this.getFieldValue(morphology_field);
        if (logger.isDebugEnabled()) {
            logger.debug("Checking combination Morphology: " + morphology + " and Topography: " + topography);
        }
        if (this.containOneEmptyElement(new String[]{topography, morphology})) {
            return this.getRuleOutput();
        }
        if (!this.isCaseSensitive(topography_field)) {
            topography = topography.toUpperCase();
        }
        boolean isValid = true;
        if (this.notAllowedCombinations.contains(morphology) && this.isValidAndDefinedField(topography_field, topography)) {
            topography2 = topography.substring(0, topography.length() - 1);
            if (this.forbiddenValues.contains(morphology + ";" + topography) || this.forbiddenValues.contains(morphology + ";" + topography2)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("INVALID - (not allowed combination) Morphology: " + morphology + "  Topography: " + topography);
                }
                isValid = false;
            }
        }
        if (isValid && this.allowedCombinations.contains(morphology) && this.isValidAndDefinedField(topography_field, topography)) {
            topography2 = topography.substring(0, topography.length() - 1);
            if (!this.allowedValues.contains(morphology + ";" + topography) && !this.allowedValues.contains(morphology + ";" + topography2)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("INVALID - (not within allowed combinations) Morphology: " + morphology + "  Topography: " + topography);
                }
                isValid = false;
            }
        }
        if (!isValid) {
            topography = this.getFieldValue(topography_field);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(morphology_field, morphology));
            fieldValues.add(new FieldValue(topography_field, topography));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_TOPOGRAPHY.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_MORPHOLOGY.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<LocalFile> files = new ArrayList<LocalFile>();
        files.add(new LocalFile("MorphologyTopographyRule1.csv", "", "", "List of morphology and topography pairs NOT allowed"));
        files.add(new LocalFile("MorphologyTopographyRule2.csv", "", "", "List of morphology and topography pairs ALLOWED"));
        this.ruleConfiguration.setConfigurationFiles(files);
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MANDATORY.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MAX_SIZE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_UNKNOWN_VALUE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_RANGE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
    }
}

