/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleException;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util.RangeParser;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradeMorphologyRule
extends CrossFieldRule {
    protected Map<String, String> allowedMorphoGradeHeamatoMap;
    protected Map<String, String> allowedMorphoGradeMapHeamatoRanged;
    protected Map<String, String> allowedMorphoBehGradeCNSMap;
    protected Map<String, String> allowedMorphoBehGradeMapCNSRanged;
    protected Map<String, String> allowedMorphoBehGradeSolidMap;
    protected Map<String, String> allowedMorphoBehGradeMapSolidRanged;
    protected static RangeParser rangeParser;
    public static final String UNMATCHED = "Unmatched";
    public static final String RANGE = "-";
    public static final String COLUM_SEPARATOR = ";";
    protected static Logger logger;

    public GradeMorphologyRule(RuleDefinition rule) {
        super(rule);
        if (!this.init()) {
            throw new InvalidRuleException("Initialization error");
        }
        this.setLongDescription("This rule validates the combination of Morphology and Grade. If the target Morphology (the key) is found in the first list (Heamatological), a warning is raised when the Morpho/Grade combination is not in that list. Else (if not found in the first list), then the combination Morpho/Beh (another key) is searched in the second list (CNS), and a warning is raised if the Morpho/Beh/Grade combination is not in the second list. Finally the Morpho/Beh key is searched in the third list (Solid), and a warning is raised if the Morpho/Beh/Grade combination is not in the third list.");
    }

    protected boolean init() {
        String key;
        String[] columns;
        List<String> allowedMorphoGradeHeamatoRaw;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        List<LocalFile> files = ruleConfiguration.getConfigurationFiles();
        LocalFile localMorphologyFile_Heamato = files.get(0);
        LocalFile localMorphologyFile_CNS = files.get(1);
        LocalFile localMorphologyFile_Solid = files.get(2);
        String morphologyGradeFile_Heamato = localMorphologyFile_Heamato.getFileName();
        String morphologyGradeFile_CNS = localMorphologyFile_CNS.getFileName();
        String morphologyGradeFile_Solid = localMorphologyFile_Solid.getFileName();
        if (logger.isDebugEnabled()) {
            logger.debug("init() - Loading configuration files");
        }
        if ((allowedMorphoGradeHeamatoRaw = this.loadConfigurationData(morphologyGradeFile_Heamato)) == null) {
            return false;
        }
        List<String> allowedMorphoBehGradeCNSRaw = this.loadConfigurationData(morphologyGradeFile_CNS);
        if (allowedMorphoBehGradeCNSRaw == null) {
            return false;
        }
        List<String> allowedMorphoBehGradeSolidRaw = this.loadConfigurationData(morphologyGradeFile_Solid);
        if (allowedMorphoBehGradeSolidRaw == null) {
            return false;
        }
        ArrayList<String> allowedMorphoGradeHeamato = new ArrayList<String>();
        ArrayList<String> allowedMorphoGradeHeamatoRanged = new ArrayList<String>();
        ArrayList<String> allowedMorphoGradeCNS = new ArrayList<String>();
        ArrayList<String> allowedMorphoGradeCNSRanged = new ArrayList<String>();
        ArrayList<String> allowedMorphoBehGradeSolid = new ArrayList<String>();
        ArrayList<String> allowedMorphoBehGradeSolidRanged = new ArrayList<String>();
        for (String line : allowedMorphoGradeHeamatoRaw) {
            if (line == null) continue;
            if (line.contains(RANGE)) {
                allowedMorphoGradeHeamatoRanged.add(line);
                continue;
            }
            allowedMorphoGradeHeamato.add(line);
        }
        for (String line : allowedMorphoBehGradeCNSRaw) {
            if (line == null) continue;
            if (line.contains(RANGE)) {
                allowedMorphoGradeCNSRanged.add(line);
                continue;
            }
            allowedMorphoGradeCNS.add(line);
        }
        if (logger.isTraceEnabled()) {
            for (String line : allowedMorphoGradeCNS) {
                logger.trace("init() - File 2 - allowedMorphoGradeCNS: " + line);
            }
        }
        if (logger.isTraceEnabled()) {
            for (String line : allowedMorphoGradeCNSRanged) {
                logger.trace("init() - File 2 - allowedMorphoGradeCNSRanged: " + line);
            }
        }
        for (String line : allowedMorphoBehGradeSolidRaw) {
            if (line == null) continue;
            if (line.contains(RANGE)) {
                allowedMorphoBehGradeSolidRanged.add(line);
                continue;
            }
            allowedMorphoBehGradeSolid.add(line);
        }
        if (logger.isTraceEnabled()) {
            for (String line : allowedMorphoBehGradeSolid) {
                logger.trace("init() - File 3 - allowedMorphoBehGradeSolid: " + line);
            }
        }
        if (logger.isTraceEnabled()) {
            for (String line : allowedMorphoBehGradeSolidRanged) {
                logger.trace("init() - File 3 - allowedMorphoBehGradeSolidRanged: " + line);
            }
        }
        this.allowedMorphoGradeHeamatoMap = new HashMap<String, String>();
        this.allowedMorphoGradeMapHeamatoRanged = new HashMap<String, String>();
        this.allowedMorphoBehGradeCNSMap = new HashMap<String, String>();
        this.allowedMorphoBehGradeMapCNSRanged = new HashMap<String, String>();
        this.allowedMorphoBehGradeSolidMap = new HashMap<String, String>();
        this.allowedMorphoBehGradeMapSolidRanged = new HashMap<String, String>();
        for (String line : allowedMorphoGradeHeamato) {
            columns = line.trim().split(COLUM_SEPARATOR);
            this.allowedMorphoGradeHeamatoMap.put(columns[0], line);
            if (!logger.isTraceEnabled()) continue;
            logger.trace("init() - Mapped allowed MorphoGrade (File 1 - simple): " + columns[0] + " -> " + line);
        }
        for (String line : allowedMorphoGradeHeamatoRanged) {
            columns = line.trim().split(COLUM_SEPARATOR);
            this.allowedMorphoGradeMapHeamatoRanged.put(columns[0], line);
            if (!logger.isTraceEnabled()) continue;
            logger.trace("init() - Mapped allowed MorphoGrade (File 1 - ranged): " + columns[0] + " -> " + line);
        }
        for (String line : allowedMorphoGradeCNS) {
            int pos = line.lastIndexOf(COLUM_SEPARATOR);
            if (pos < 0) continue;
            key = line.substring(0, pos);
            this.allowedMorphoBehGradeCNSMap.put(key, line);
            if (!logger.isTraceEnabled()) continue;
            logger.trace("init() - Mapped allowed MorphoBehGrade (File 2 - simple): " + key + " -> " + line);
        }
        for (String line : allowedMorphoGradeCNSRanged) {
            int pos = line.lastIndexOf(COLUM_SEPARATOR);
            if (pos < 0) continue;
            key = line.substring(0, pos);
            this.allowedMorphoBehGradeMapCNSRanged.put(key, line);
            if (!logger.isTraceEnabled()) continue;
            logger.trace("init() - Mapped allowed MorphoBehGrade (File 2 - ranged): " + key + " -> " + line);
        }
        for (String line : allowedMorphoBehGradeSolid) {
            int pos = line.lastIndexOf(COLUM_SEPARATOR);
            if (pos < 0) continue;
            key = line.substring(0, pos);
            this.allowedMorphoBehGradeSolidMap.put(key, line);
            if (!logger.isTraceEnabled()) continue;
            logger.trace("init() - Mapped allowed MorphoBehGrade (File 3 - simple): " + key + " -> " + line);
        }
        for (String line : allowedMorphoBehGradeSolidRanged) {
            int pos = line.lastIndexOf(COLUM_SEPARATOR);
            if (pos < 0) continue;
            key = line.substring(0, pos);
            this.allowedMorphoBehGradeMapSolidRanged.put(key, line);
            if (!logger.isTraceEnabled()) continue;
            logger.trace("init() - Mapped allowed MorphoBehGrade (File 3 - ranged): " + key + " -> " + line);
        }
        return true;
    }

    @Override
    public List<RuleOutput> applyCheck() {
        String combination_3;
        boolean checkCNS;
        String topographyNumber;
        int topographyAsInt;
        String combination_1;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field morphology_field = ruleConfiguration.getFieldByPosition(1);
        Field behaviour_field = ruleConfiguration.getFieldByPosition(2);
        Field grade_field = ruleConfiguration.getFieldByPosition(3);
        Field topography_field = ruleConfiguration.getFieldByPosition(4);
        String morphology = this.getFieldValue(morphology_field);
        String behaviour = this.getFieldValue(behaviour_field);
        String grade = this.getFieldValue(grade_field);
        String topography = this.getFieldValue(topography_field);
        DataRecord record = this.getDataRecord();
        String mainKey = this.getMainKeyBySchemaPerspective(record);
        boolean debug = logger.isTraceEnabled();
        if (debug) {
            logger.info("");
            logger.info("Checking record: " + mainKey);
            logger.info("Checking morphology: " + morphology + ", Behaviour: " + behaviour + ", Grade: " + grade + ", Topography: " + topography);
        }
        if (this.containOneEmptyElement(new String[]{morphology, behaviour, grade, topography})) {
            return this.getRuleOutput();
        }
        if (!(this.isValidField(morphology_field) && this.isValidField(behaviour_field) && this.isValidField(grade_field) && this.isValidField(topography_field))) {
            return this.getRuleOutput();
        }
        boolean isValid = true;
        if (debug) {
            logger.info("Checking if Morphology & Grade is an allowed combination");
        }
        if (!UNMATCHED.equals(combination_1 = this.matchesMorphologyKey(morphology))) {
            String[] tokens;
            String allowedGradeValues;
            if (debug) {
                logger.info("Heamato - Matched morpho_grade combination: " + combination_1);
            }
            if (!(allowedGradeValues = (tokens = combination_1.trim().split(COLUM_SEPARATOR))[1]).contains(grade)) {
                if (debug) {
                    logger.info("Heamato - INVALID -> morpho_grade: " + morphology + "  Grade: " + grade);
                }
                isValid = false;
            }
        }
        if (debug) {
            logger.info("Checking for CNS pre conditions for Topography: " + topography);
        }
        boolean isCNS = (topographyAsInt = this.parseIntegerValue(topographyNumber = topography.substring(1, 4))) >= 700 && topographyAsInt <= 729 || topographyAsInt >= 751 && topographyAsInt <= 753;
        boolean bl = checkCNS = isValid && isCNS;
        if (debug) {
            logger.info("Does value " + topography + " (" + topographyAsInt + ") address CNS ? " + isCNS);
        }
        if (checkCNS) {
            if (debug) {
                logger.info("Checking CNS conditions for topography " + topography);
            }
            String combination_2 = this.matchesMorphologyBehaviourKey(morphology, behaviour, this.allowedMorphoBehGradeCNSMap, this.allowedMorphoBehGradeMapCNSRanged);
            if (debug) {
                logger.info("CNS - Matched morpho_beh combination: " + combination_2);
            }
            if (!UNMATCHED.equals(combination_2)) {
                if (debug) {
                    logger.info("CNS - Matched morpho_beh_grade combination: " + combination_2);
                }
                isValid = this.checkGrade(morphology, behaviour, grade, combination_2);
            }
        }
        if (debug) {
            logger.info("Record status after check on CNS: valid ? " + isValid);
        }
        if (isValid && !UNMATCHED.equals(combination_3 = this.matchesMorphologyBehaviourKey(morphology, behaviour, this.allowedMorphoBehGradeSolidMap, this.allowedMorphoBehGradeMapSolidRanged))) {
            if (debug) {
                logger.info("Solid - Matched morpho_beh_grade combination: " + combination_3);
            }
            isValid = this.checkGrade(morphology, behaviour, grade, combination_3);
        }
        if (debug) {
            logger.info("Record status after check on Solid: valid ? " + isValid);
        }
        if (!isValid) {
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(morphology_field, morphology));
            fieldValues.add(new FieldValue(behaviour_field, behaviour));
            fieldValues.add(new FieldValue(grade_field, grade));
            this.addErrorDetail(fieldValues);
        }
        if (debug) {
            logger.info("Return RuleOutput: ? " + String.valueOf(this.getRuleOutput()));
        }
        return this.getRuleOutput();
    }

    protected String matchesMorphologyKey(String morphology) {
        boolean debug = logger.isTraceEnabled();
        String combination = null;
        boolean simpleMatch = this.allowedMorphoGradeHeamatoMap.containsKey(morphology);
        if (simpleMatch) {
            combination = this.allowedMorphoGradeHeamatoMap.get(morphology);
        }
        if (debug) {
            logger.info("");
            logger.info("matchesMorphologyKey() - Input value (the needle): " + morphology);
            logger.info("matchesMorphologyKey() - Matched simple entry '" + morphology + "' ? " + simpleMatch);
            if (combination != null) {
                logger.info("matchesMorphologyKey() - Returning combination: " + combination);
            }
        }
        if (simpleMatch) {
            return this.allowedMorphoGradeHeamatoMap.get(morphology);
        }
        int morphoAsInt = Integer.parseInt(morphology);
        for (Map.Entry<String, String> entry : this.allowedMorphoGradeMapHeamatoRanged.entrySet()) {
            String primaryKey = entry.getKey();
            combination = entry.getValue();
            String[] morphoBounds = primaryKey.split(RANGE);
            int fromMorpho = Integer.parseInt(morphoBounds[0]);
            int toMorpho = Integer.parseInt(morphoBounds[1]);
            if (debug) {
                logger.info("matchesMorphologyKey() - Evaluating combination: " + fromMorpho + ".." + toMorpho);
            }
            if (fromMorpho > morphoAsInt || morphoAsInt > toMorpho) continue;
            if (debug) {
                String message = morphology + " found in range: " + fromMorpho + ".." + toMorpho;
                logger.info("matchesMorphologyKey() - Pair " + message);
                logger.info("matchesMorphologyKey() - Returning combination: " + combination);
            }
            return combination;
        }
        return UNMATCHED;
    }

    protected String matchesMorphologyBehaviourKey(String morphology, String behaviour, Map<String, String> simpleMap, Map<String, String> rangedMap) {
        String rangeSeparator = String.valueOf(RANGE);
        String morphoBeh = morphology + COLUM_SEPARATOR + behaviour;
        boolean simpleMatch = simpleMap.containsKey(morphoBeh);
        boolean debug = logger.isTraceEnabled();
        if (debug) {
            logger.info("matchesMorphologyBehaviourKey() - Matched simple entry '" + morphoBeh + "' ? " + simpleMatch);
        }
        if (simpleMatch) {
            return simpleMap.get(morphoBeh);
        }
        if (debug) {
            logger.info("matchesMorphologyBehaviourKey() - Input values (the needle): " + morphoBeh);
        }
        int morphoAsInt = Integer.parseInt(morphology);
        for (Map.Entry<String, String> entry : rangedMap.entrySet()) {
            String compositeKey = entry.getKey();
            String combination = entry.getValue();
            String[] columns = compositeKey.split(COLUM_SEPARATOR);
            String morphoRange = columns[0];
            String targetBeh = columns[1];
            String[] morphoBounds = morphoRange.split(rangeSeparator);
            int fromMorpho = Integer.parseInt(morphoBounds[0]);
            int toMorpho = Integer.parseInt(morphoBounds[1]);
            if (debug) {
                logger.info("matchesMorphologyBehaviourKey() - Evaluating combination: " + fromMorpho + ".." + toMorpho + " (with Beh=" + targetBeh + ")");
            }
            if (fromMorpho > morphoAsInt || morphoAsInt > toMorpho) continue;
            boolean matchesAlsoBeh = targetBeh.equalsIgnoreCase(behaviour);
            if (debug) {
                String message = morphology + "/" + behaviour + " found in range: " + fromMorpho + ".." + toMorpho + " (Beh ? " + matchesAlsoBeh + ")";
                logger.info("matchesMorphologyBehaviourKey() - Pair " + message);
                logger.info("matchesMorphologyBehaviourKey() - Returning combination: " + combination);
            }
            if (matchesAlsoBeh) {
                return combination;
            }
            return UNMATCHED;
        }
        return UNMATCHED;
    }

    protected boolean checkGrade(String morphology, String behaviour, String grade, String combo) {
        boolean debug = logger.isTraceEnabled();
        int gradeInt = this.parseIntegerValue(grade);
        String[] tokens = combo.trim().split(COLUM_SEPARATOR);
        String allowedGradeValues = tokens[2];
        if (debug) {
            logger.info("checkGrade() - Allowed list of Grade values: " + allowedGradeValues);
        }
        if (allowedGradeValues == null || allowedGradeValues.isEmpty()) {
            String message = "checkGrade() - Found null Grade definition for morpho_beh_grade combination: " + combo;
            logger.error(message);
            throw new IllegalStateException(message);
        }
        if (!allowedGradeValues.contains(RANGE)) {
            if (!allowedGradeValues.contains(grade)) {
                if (debug) {
                    logger.info("checkGrade() - INVALID -> morpho_beh_grade (simple): " + morphology + "  Behaviour: " + behaviour + "  Grade: " + grade);
                }
                return false;
            }
        } else {
            int pos = combo.lastIndexOf(COLUM_SEPARATOR);
            if (logger.isWarnEnabled()) {
                logger.warn("checkGrade() - Configuration file should not contain \"ranged\" definitions for Grade: " + allowedGradeValues);
            }
            if (pos >= 0) {
                boolean withinRange;
                String[] rangeBounds = allowedGradeValues.trim().split(RANGE);
                int lowerBound = Integer.parseInt(rangeBounds[0]);
                int upperBound = Integer.parseInt(rangeBounds[1]);
                boolean bl = withinRange = lowerBound <= gradeInt && gradeInt <= upperBound;
                if (!withinRange) {
                    if (debug) {
                        logger.info("checkGrade() - INVALID - morpho_beh_grade (ranged): " + morphology + "/" + behaviour + "/" + grade);
                        logger.info("checkGrade() - Invalid becaUse not in range: " + lowerBound + " .. " + upperBound);
                    }
                    return false;
                }
            } else {
                String message = "checkGrade() - Wrong configuration line (wrong separator?) : " + combo;
                logger.error(message);
                throw new IllegalStateException(message);
            }
        }
        return true;
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_MORPHOLOGY.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_BEHAVIOUR.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2014.INCIDENCE_GRADE.id, false);
        RuleParameter param4 = new RuleParameter(4, DefaultFieldIDencr2014.INCIDENCE_TOPOGRAPHY.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        defaultRuleParameters.add(param4);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<LocalFile> files = new ArrayList<LocalFile>();
        files.add(new LocalFile("GradeMorphology_Heamato.csv", "", "", "List of morphology values allowed - Haematological"));
        files.add(new LocalFile("GradeMorphology_CNS.csv", "", "", "List of morphology values allowed - CNS"));
        files.add(new LocalFile("GradeMorphology_Solid.csv", "", "", "List of morphology values allowed - Solid"));
        this.ruleConfiguration.setConfigurationFiles(files);
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MANDATORY.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MAX_SIZE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_RANGE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
    }

    static {
        logger = LoggerFactory.getLogger(GradeMorphologyRule.class);
        rangeParser = new RangeParser();
    }
}

