/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleException;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util.RangeParser;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util.TopographyParser;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradeBehaviourRule
extends CrossFieldRule {
    protected static RangeParser rangeParser;
    protected static TopographyParser topographyParser;
    protected String[][] allowedCombinations;
    protected String[][] notAllowedCombinations;
    public static final int UN_MATCHED = 1;
    public static final int MATCHED_OK = 2;
    public static final int MATCHED_WRONG = 3;
    public static final String COL_SEPARATOR = ";";
    public static final String ALLOWED = "Yes";
    public static final String NOT_ALLOWED = "No";
    protected static Logger logger;

    public GradeBehaviourRule(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule validates the combination of Behaviour and Grade.\n\nThe main logic states that only malignant tumours (Behaviour=3) should be graded, that is: if Behaviour < 3 and Grade != 9, the W-BEGR warning is raised.\nHowever, for some specific Topography and Morphology combinations, it's allowed to have Behaviour < 3 and a not null Grade value: see W-TBGR for further details.");
        if (!this.init()) {
            throw new InvalidRuleException("Initialization error");
        }
    }

    protected boolean init() {
        if (logger.isDebugEnabled()) {
            logger.debug(this.getClassName() + " - init() -  Loading configuration data");
        }
        if (!this.loadTable5()) {
            logger.error(this.getClassName() + "init() - Error loading configuration of Table 5 consistency rules");
            return false;
        }
        return true;
    }

    public boolean loadTable5() {
        int row;
        String value;
        boolean verbose = logger.isDebugEnabled();
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        List<LocalFile> files = ruleConfiguration.getConfigurationFiles();
        LocalFile localFileTable5 = files.get(0);
        String table5FileName = localFileTable5.getFileName();
        if (verbose) {
            logger.info("loadTable5() - Loading configuration file: " + table5FileName);
        }
        List<String> configData = this.loadConfigurationData(table5FileName);
        if (verbose) {
            logger.info("loadTable5() - Loaded configuration data: " + String.valueOf(configData));
        }
        if (configData == null) {
            return false;
        }
        int cols = 5;
        int rows = configData.size() - 1;
        ArrayList<String> expandedTopos = new ArrayList<String>();
        for (int row2 = 0; row2 < rows; ++row2) {
            String line = configData.get(row2 + 1);
            List<String> list = topographyParser.expandTopographies(line, 0);
            expandedTopos.addAll(list);
        }
        rows = expandedTopos.size();
        String[][] matrix = new String[rows][cols];
        for (int row3 = 0; row3 < rows; ++row3) {
            matrix[row3] = ((String)expandedTopos.get(row3)).split(COL_SEPARATOR);
        }
        if (verbose) {
            logger.info("loadTable5() - Configuration matrix: " + Arrays.toString((Object[])matrix));
        }
        this.sortByAllowed(matrix);
        int allowedCombinations = 0;
        int notAllowedCombinations = 0;
        for (String[] row4 : matrix) {
            value = row4[row4.length - 1];
            if (ALLOWED.equalsIgnoreCase(value)) {
                ++allowedCombinations;
                continue;
            }
            if (NOT_ALLOWED.equalsIgnoreCase(value)) {
                ++notAllowedCombinations;
                continue;
            }
            logger.error("loadTable5() - Wrong value in the \"Allowed\" column: " + value);
            return false;
        }
        if (verbose) {
            logger.info("loadTable5() - Number of allowed/not_allowed lines: " + allowedCombinations + "/" + notAllowedCombinations);
        }
        this.allowedCombinations = new String[allowedCombinations][cols + 1];
        this.notAllowedCombinations = new String[notAllowedCombinations][cols + 1];
        int allowedIndex = 0;
        int notAllowedIndex = 0;
        for (row = 0; row < rows; ++row) {
            if (logger.isTraceEnabled()) {
                logger.info("loadTable5() - Parsing line: " + Arrays.toString(matrix[row]));
            }
            Object[] combination = this.setCombination(matrix[row]);
            if (logger.isTraceEnabled()) {
                logger.info("loadTable5() - Parsed line : " + Arrays.toString(combination));
            }
            if (ALLOWED.equalsIgnoreCase(value = matrix[row][cols - 1])) {
                this.allowedCombinations[allowedIndex++] = (String[])combination.clone();
                continue;
            }
            if (!NOT_ALLOWED.equalsIgnoreCase(value)) continue;
            this.notAllowedCombinations[notAllowedIndex++] = (String[])combination.clone();
        }
        if (logger.isTraceEnabled()) {
            for (row = 0; row < allowedIndex; ++row) {
                logger.info("loadTable5() - Allowed combinations: " + Arrays.toString(this.allowedCombinations[row]));
            }
            for (row = 0; row < notAllowedIndex; ++row) {
                logger.info("loadTable5() - Not_Allowed combinations: " + Arrays.toString(this.notAllowedCombinations[row]));
            }
        }
        return this.allowedCombinations.length >= 1 || this.notAllowedCombinations.length >= 1;
    }

    protected String[][] sortByAllowed(String[][] array) {
        Arrays.sort(array, Comparator.comparing(row -> row[((String[])row).length - 1]).reversed());
        return array;
    }

    protected String[] setCombination(String[] line) {
        int cols = line.length;
        Object[] result = new String[cols + 1];
        int[] topoRange = topographyParser.expandTopographies(line[0]);
        result[0] = Integer.toString(topoRange[0]);
        result[1] = Integer.toString(topoRange[1]);
        for (int col = 2; col <= cols; ++col) {
            String value = new String(line[col - 1]);
            result[col] = col != 4 ? value : rangeParser.expandIntegersAsString(value);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("setCombination() - Parsed line: " + Arrays.toString(result));
        }
        return result;
    }

    @Override
    public List<RuleOutput> applyCheck() {
        String grade;
        String behaviour;
        String morphology;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field topography_field = ruleConfiguration.getFieldByPosition(1);
        Field morphology_field = ruleConfiguration.getFieldByPosition(2);
        Field behaviour_field = ruleConfiguration.getFieldByPosition(3);
        Field grade_field = ruleConfiguration.getFieldByPosition(4);
        String topography = this.getFieldValue(topography_field);
        if (this.containOneEmptyElement(new String[]{topography, morphology = this.getFieldValue(morphology_field), behaviour = this.getFieldValue(behaviour_field), grade = this.getFieldValue(grade_field)})) {
            return this.getRuleOutput();
        }
        boolean mainFields = this.isValidAndDefinedField(morphology_field, morphology) && this.isValidAndDefinedField(topography_field, topography);
        boolean otherFields = this.isValidAndDefinedField(behaviour_field, behaviour) && this.isValidAndDefinedField(grade_field, grade);
        DataRecord record = this.getDataRecord();
        String mainKey = this.getMainKeyBySchemaPerspective(record);
        if (mainFields && otherFields) {
            boolean debug = logger.isTraceEnabled();
            String prefix = this.getClass().getSimpleName() + " - ";
            if (debug) {
                logger.info("");
                logger.info(">>> " + prefix + "CHECK_RECORD : " + mainKey);
            }
            int topographyInt = topographyParser.parseTopography(topography);
            if (logger.isTraceEnabled()) {
                logger.trace("Parsed Topography code: " + topographyInt);
            }
            int matches_allowed = this.matchAllowedCombination(topography, morphology, behaviour, grade);
            if (debug) {
                logger.info(prefix + "Matches allowed combination ? " + this.getMatchedLabel(matches_allowed));
            }
            if (matches_allowed == 1) {
                int matches_not_allowed = this.matchNotAllowedCombination(topography, morphology, behaviour, grade);
                if (debug) {
                    logger.info(prefix + "Matches not allowed combination ? " + this.getMatchedLabel(matches_not_allowed));
                }
                if (matches_not_allowed == 3) {
                    ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
                    fieldValues.add(new FieldValue(topography_field, topography));
                    fieldValues.add(new FieldValue(morphology_field, morphology));
                    fieldValues.add(new FieldValue(behaviour_field, behaviour));
                    fieldValues.add(new FieldValue(grade_field, grade));
                    this.addErrorDetail(fieldValues);
                    if (debug) {
                        logger.info(prefix + "Invalid combination -> Returning RuleOutput: " + String.valueOf(this.getRuleOutput()));
                    }
                    return this.getRuleOutput();
                }
            }
        }
        return this.getRuleOutput();
    }

    protected int matchAllowedCombination(String topography, String morphology, String behaviour, String grade) {
        String prefix = this.getClass().getSimpleName();
        boolean debug = logger.isTraceEnabled();
        if (debug) {
            logger.info(prefix + "matchAllowedCombination() - Checking allowed combinations");
        }
        int topographyInt = topographyParser.parseTopography(topography);
        for (int row = 0; row < this.allowedCombinations.length; ++row) {
            if (!this.matchesTopography(topographyInt, this.allowedCombinations[row]) || !this.matchesMorhology(morphology, this.allowedCombinations[row]) || !this.matchesBehaviour(behaviour, this.allowedCombinations[row])) continue;
            if (debug) {
                String topoMorphoBeh = topography + "/" + morphology + "/" + behaviour;
                logger.info(prefix + "matchAllowedCombination() - Matched Topo/Morpho/Beh \"" + topoMorphoBeh + "\" for allowed combination: " + Arrays.toString(this.allowedCombinations[row]));
            }
            if (!this.allowedCombinations[row][4].contains(grade)) {
                if (debug) {
                    String topoMorpho = "Topo/Morpho: " + topography + "/" + morphology;
                    logger.info(prefix + "matchAllowedCombination() - INVALID_ALLOWED: \"" + topoMorpho + "\" -> Beh= " + behaviour + " Grade= " + grade);
                }
                return 3;
            }
            if (debug) {
                logger.info(prefix + "matchAllowedCombination() - VALID_ALLOWED: Grade " + grade + " is compatible with Behaviour " + behaviour + "-> skipping other logic");
            }
            return 2;
        }
        return 1;
    }

    protected int matchNotAllowedCombination(String topography, String morphology, String behaviour, String grade) {
        String prefix = this.getClassName() + " - ";
        boolean debug = logger.isTraceEnabled();
        if (debug) {
            logger.info(prefix + "matchNotAllowedCombination() - Checking not_allowed combinations");
        }
        int topographyInt = topographyParser.parseTopography(topography);
        for (int row = 0; row < this.notAllowedCombinations.length; ++row) {
            if (!this.matchesTopography(topographyInt, this.notAllowedCombinations[row]) || !this.matchesMorhology(morphology, this.notAllowedCombinations[row]) || !this.matchesBehaviour(behaviour, this.notAllowedCombinations[row])) continue;
            if (debug) {
                String topoMorphoBehGrade = topography + "/" + morphology + "/" + behaviour + "/" + grade;
                logger.info(prefix + "matchNotAllowedCombination() - Matched Topo/Morpho/Beh \"" + topoMorphoBehGrade + "\" for not_allowed combination: " + Arrays.toString(this.notAllowedCombinations[row]));
            }
            String targetGrade = this.notAllowedCombinations[row][4];
            boolean anyGrade = "Any".equalsIgnoreCase(targetGrade);
            if (debug) {
                logger.info(prefix + "matchNotAllowedCombination() - Any Grade      ? " + anyGrade);
                logger.info(prefix + "matchNotAllowedCombination() - Contains Grade ? " + targetGrade.contains(grade));
            }
            if (!anyGrade && !targetGrade.contains(grade)) continue;
            if (debug) {
                String topoMorpho = "Topo/Morpho: " + topography + "/" + morphology;
                logger.info(prefix + "matchNotAllowedCombination() - INVALID_NOT_ALLOWED - \"" + topoMorpho + "\" -> Beh: " + behaviour + " Grade: " + grade);
            }
            return 3;
        }
        return 1;
    }

    protected boolean matchesTopography(int topography, String[] combination) {
        int topoStart = "Any".equalsIgnoreCase(combination[0]) ? 0 : this.parseIntegerValue(combination[0]);
        int topoEnd = "Any".equalsIgnoreCase(combination[1]) ? 999 : this.parseIntegerValue(combination[1]);
        return topoStart <= topography && topography <= topoEnd;
    }

    protected boolean matchesMorhology(String morphology, String[] combination) {
        if ("Any".equalsIgnoreCase(combination[2])) {
            return true;
        }
        return combination[2].contains(morphology);
    }

    protected boolean matchesBehaviour(String behaviour, String[] combination) {
        if ("Any".equalsIgnoreCase(combination[3])) {
            return true;
        }
        return combination[3].contains(behaviour);
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_TOPOGRAPHY.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_MORPHOLOGY.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2014.INCIDENCE_BEHAVIOUR.id, false);
        RuleParameter param4 = new RuleParameter(4, DefaultFieldIDencr2014.INCIDENCE_GRADE.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        defaultRuleParameters.add(param4);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MANDATORY.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MAX_SIZE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_RANGE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
        ArrayList<LocalFile> files = new ArrayList<LocalFile>();
        files.add(new LocalFile("TopographyMorphologyBehaviourGrade.csv", "", "", "List of Morphology/Behaviour/Grade allowed values, indexed by Topography"));
        this.ruleConfiguration.setConfigurationFiles(files);
    }

    public String getMatchedLabel(int value) {
        switch (value) {
            case 1: {
                return "Ummatched";
            }
            case 2: {
                return "Matched (OK)";
            }
            case 3: {
                return "Matched wrong (error?)";
            }
        }
        return "Unknown (ERROR!)";
    }

    static {
        logger = LoggerFactory.getLogger(GradeBehaviourRule.class);
        rangeParser = new RangeParser();
        topographyParser = new TopographyParser();
    }
}

