/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleException;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditionCauseOfDeathRule
extends CrossFieldRule {
    protected List<String> configDataEdition = null;
    protected List<String> configDataCauseOfDeath = null;
    protected List<String> configDataEditionCauseOfDeath = null;
    protected static Logger logger = LoggerFactory.getLogger(EditionCauseOfDeathRule.class);

    public EditionCauseOfDeathRule(RuleDefinition rule) {
        super(rule);
        if (!this.init()) {
            throw new InvalidRuleException("Initialization error");
        }
        this.setLongDescription("This rule validates the combination of ICD edition and cause of death.\n\ne.g. cause of death=157 and ICD edition=10.");
    }

    protected boolean init() {
        this.configDataEdition = this.loadConfigurationData(this.ruleConfiguration.getConfigurationFiles().get(0).getFileName());
        if (this.configDataEdition == null) {
            return false;
        }
        this.configDataEditionCauseOfDeath = this.loadConfigurationData(this.ruleConfiguration.getConfigurationFiles().get(1).getFileName());
        if (this.configDataEditionCauseOfDeath == null) {
            return false;
        }
        this.configDataCauseOfDeath = new ArrayList<String>();
        for (String line : this.configDataEditionCauseOfDeath) {
            int pos = line.indexOf(59);
            if (pos >= 0) {
                line = line.substring(pos + 1);
            }
            this.configDataCauseOfDeath.add(line);
        }
        return true;
    }

    @Override
    public List<RuleOutput> applyCheck() {
        String edition;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field causeOfDeath_field = ruleConfiguration.getFieldByPosition(1);
        Field edition_field = ruleConfiguration.getFieldByPosition(2);
        String causeOfDeath = this.getFieldValue(causeOfDeath_field);
        if (this.containOneEmptyElement(new String[]{causeOfDeath, edition = this.getFieldValue(edition_field)})) {
            return this.getRuleOutput();
        }
        if (causeOfDeath.isEmpty() || !this.isValidAndNotUnknownField(causeOfDeath_field, causeOfDeath)) {
            return this.getRuleOutput();
        }
        if (causeOfDeath.length() > 5) {
            return this.getRuleOutput();
        }
        if (edition.isEmpty() || !this.isValidAndNotUnknownField(edition_field, edition)) {
            return this.getRuleOutput();
        }
        if (causeOfDeath.length() > 3) {
            causeOfDeath = causeOfDeath.substring(0, 3);
        }
        if (this.configDataCauseOfDeath.contains(causeOfDeath) && this.configDataEdition.contains(edition) && !this.configDataEditionCauseOfDeath.contains(edition + ";" + causeOfDeath)) {
            causeOfDeath = this.getFieldValue(causeOfDeath_field);
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID - CauseOfDeath: " + causeOfDeath + "  Edition: " + edition);
            }
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(causeOfDeath_field, causeOfDeath));
            fieldValues.add(new FieldValue(edition_field, edition));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_CAUSE_DEATH.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_ICD_EDITION.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<LocalFile> files = new ArrayList<LocalFile>();
        files.add(new LocalFile("ICDEdition.csv", "", "", "List of ICD edition allowed"));
        files.add(new LocalFile("EditionCauseOfDeathRule1.csv", "", "", "List of ICD edition and Cause of Death pairs allowed"));
        this.ruleConfiguration.setConfigurationFiles(files);
    }
}

