/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleException;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiseaseExtentRule9
extends CrossFieldRule {
    protected List<String> configData = null;
    protected static Logger logger = LoggerFactory.getLogger(DiseaseExtentRule9.class);

    public DiseaseExtentRule9(RuleDefinition rule) {
        super(rule);
        if (!this.init()) {
            throw new InvalidRuleException("Initialization error");
        }
        this.setLongDescription("This rule validates the combination of extent of disease, cN, pN and condensed N.<br/><br/>A warning is raised if topography is within (C770,C771,C772,C773,C774,C775,C778,C779) and: pN = 0, cN = 0, condN = N0.");
    }

    protected boolean init() {
        this.configData = this.loadConfigurationData(this.ruleConfiguration.getConfigurationFiles().get(0).getFileName());
        return this.configData != null;
    }

    @Override
    public List<RuleOutput> applyCheck() {
        String condN;
        String cN;
        String pN;
        String eod;
        if (logger.isTraceEnabled()) {
            logger.trace("applyCheck() - Applying rule on record: " + String.valueOf(this.getDataRecord()));
        }
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field topography_field = ruleConfiguration.getFieldByPosition(1);
        Field eod_field = ruleConfiguration.getFieldByPosition(2);
        Field pN_field = ruleConfiguration.getFieldByPosition(3);
        Field cN_field = ruleConfiguration.getFieldByPosition(4);
        Field condN_field = ruleConfiguration.getFieldByPosition(5);
        String topography = this.getFieldValue(topography_field);
        if (this.containOneEmptyElement(new String[]{topography, eod = this.getFieldValue(eod_field), pN = this.getFieldValue(pN_field), cN = this.getFieldValue(cN_field), condN = this.getFieldValue(condN_field)})) {
            return this.getRuleOutput();
        }
        if (!this.isCaseSensitive(topography_field)) {
            topography = topography.toUpperCase();
        }
        if (!this.isCaseSensitive(condN_field)) {
            condN = condN.toUpperCase();
        }
        boolean isValid = true;
        if (logger.isTraceEnabled()) {
            logger.trace("applyCheck() - condN value: #" + condN + "#");
        }
        if (this.configData.contains(topography) && "0".equals(pN) && "0".equals(cN) && "N0".equals(condN)) {
            isValid = false;
        }
        if (!isValid) {
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID - Topography: " + topography + "  EOD: " + eod + "  pN: " + pN + "  cN: " + cN + "  condN: " + condN);
            }
            topography = this.getFieldValue(topography_field);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(eod_field, eod));
            fieldValues.add(new FieldValue(topography_field, topography));
            fieldValues.add(new FieldValue(pN_field, pN));
            fieldValues.add(new FieldValue(cN_field, cN));
            fieldValues.add(new FieldValue(condN_field, condN));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_TOPOGRAPHY.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_EOD.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2014.INCIDENCE_PN.id, false);
        RuleParameter param4 = new RuleParameter(4, DefaultFieldIDencr2014.INCIDENCE_CN.id, false);
        RuleParameter param5 = new RuleParameter(5, DefaultFieldIDencr2014.INCIDENCE_CONDENSED_N.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        defaultRuleParameters.add(param4);
        defaultRuleParameters.add(param5);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<LocalFile> files = new ArrayList<LocalFile>();
        files.add(new LocalFile("DiseaseExtentRule9.csv", "", "", "List of topography values not allowed"));
        this.ruleConfiguration.setConfigurationFiles(files);
    }
}

