/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiseaseExtentRule8
extends CrossFieldRule {
    protected static Logger logger = LoggerFactory.getLogger(DiseaseExtentRule8.class);

    public DiseaseExtentRule8(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule validates the combination of behaviour and TNM/EOD.\n\nExample: \"behaviour > 2 and pTNM T = Tis\".");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        int behaviourInt;
        String pT;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field behaviour_field = ruleConfiguration.getFieldByPosition(1);
        Field pT_field = ruleConfiguration.getFieldByPosition(2);
        String behaviour = this.getFieldValue(behaviour_field);
        if (this.containOneEmptyElement(new String[]{behaviour, pT = this.getFieldValue(pT_field)})) {
            return this.getRuleOutput();
        }
        String pTCompareVal = "Tis";
        if (!this.isCaseSensitive(pT_field)) {
            pT = pT.toUpperCase();
            pTCompareVal = pTCompareVal.toUpperCase();
        }
        if (!this.isIntegerValue(behaviour)) {
            return this.getRuleOutput();
        }
        if (this.isValidAndNotUnknownField(pT_field, pTCompareVal) && (behaviourInt = this.parseIntegerValue(behaviour)) == 3 && pT.equals(pTCompareVal)) {
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID - behaviour: " + behaviour + "  pT: " + pT);
            }
            pT = this.getFieldValue(pT_field);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(behaviour_field, behaviour));
            fieldValues.add(new FieldValue(pT_field, pT));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_BEHAVIOUR.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_PT.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
    }
}

