/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiseaseExtentRule7
extends CrossFieldRule {
    protected static Logger logger = LoggerFactory.getLogger(DiseaseExtentRule7.class);

    public DiseaseExtentRule7(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule validates the combination of number of metastatic nodes and condensed N.\n\ne.g. number of metastatic nodes > 0 and condensed N = N0.\n");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        int metNodesInt;
        String condN;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field metNodes_field = ruleConfiguration.getFieldByPosition(1);
        Field condN_field = ruleConfiguration.getFieldByPosition(2);
        String metNodes = this.getFieldValue(metNodes_field);
        if (this.containOneEmptyElement(new String[]{metNodes, condN = this.getFieldValue(condN_field)})) {
            return this.getRuleOutput();
        }
        if (!this.isCaseSensitive(condN_field)) {
            condN = condN.toUpperCase();
        }
        if (!this.isIntegerValue(metNodes)) {
            return this.getRuleOutput();
        }
        if (this.isValidAndNotUnknownField(metNodes_field, metNodes) && this.isValidAndNotUnknownField(condN_field, condN) && (metNodesInt = this.parseIntegerValue(metNodes)) > 0 && condN.equals("N0")) {
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID - metNodes: " + metNodes + "  condN: " + condN);
            }
            condN = this.getFieldValue(condN_field);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(metNodes_field, metNodes));
            fieldValues.add(new FieldValue(condN_field, condN));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_N_MET_NODES.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_CONDENSED_N.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
    }
}

