/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleException;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiseaseExtentRule6
extends CrossFieldRule {
    protected List<String> configData = null;
    protected static Logger logger = LoggerFactory.getLogger(DiseaseExtentRule6.class);

    public DiseaseExtentRule6(RuleDefinition rule) {
        super(rule);
        if (!this.init()) {
            throw new InvalidRuleException("Initialization error");
        }
        this.setLongDescription("This rule validates the combination of topography and extent of disease.\n\nExample: if topography is C809, extent of disease must not be 1.\n");
    }

    protected boolean init() {
        this.configData = this.loadConfigurationData(this.ruleConfiguration.getConfigurationFiles().get(0).getFileName());
        return this.configData != null;
    }

    @Override
    public List<RuleOutput> applyCheck() {
        String eod;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field topography_field = ruleConfiguration.getFieldByPosition(1);
        Field eod_field = ruleConfiguration.getFieldByPosition(2);
        String topography = this.getFieldValue(topography_field);
        if (this.containOneEmptyElement(new String[]{topography, eod = this.getFieldValue(eod_field)})) {
            return this.getRuleOutput();
        }
        if (!this.isCaseSensitive(topography_field)) {
            topography = topography.toUpperCase();
        }
        boolean isValid = true;
        if (eod.equals("1")) {
            String digit;
            if (topography.length() > 0 && (digit = String.valueOf(topography.charAt(topography.length() - 1))).equals("8")) {
                isValid = false;
            }
            if (isValid && this.configData.contains(topography)) {
                isValid = false;
            }
        }
        if (!isValid) {
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID - Topography: " + topography + "  EOD: " + eod);
            }
            topography = this.getFieldValue(topography_field);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(topography_field, topography));
            fieldValues.add(new FieldValue(eod_field, eod));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_TOPOGRAPHY.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_EOD.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<LocalFile> files = new ArrayList<LocalFile>();
        files.add(new LocalFile("DiseaseExtentRule6.csv", "", "", "List of topography values not allowed"));
        this.ruleConfiguration.setConfigurationFiles(files);
    }
}

