/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiseaseExtentRule5
extends CrossFieldRule {
    protected static Logger logger = LoggerFactory.getLogger(DiseaseExtentRule5.class);

    public DiseaseExtentRule5(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule validates the combination of basis of diagnosis and pM.\n\nIf pM is not (MX, missing, unknown) then basis of diagnosis should be 6 or 7.\nIf pM is 1, then basis of diagnosis should be 6 or 7, and cT,pT should not be Tis.\n");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field bod_field = ruleConfiguration.getFieldByPosition(1);
        Field pm_field = ruleConfiguration.getFieldByPosition(2);
        Field ct_field = ruleConfiguration.getFieldByPosition(3);
        Field pt_field = ruleConfiguration.getFieldByPosition(4);
        String bod = this.getFieldValue(bod_field);
        String pM = this.getFieldValue(pm_field);
        String cT = this.getFieldValue(ct_field);
        String pT = this.getFieldValue(pt_field);
        boolean debug = false;
        if (this.containOneEmptyElement(new String[]{pM})) {
            return this.getRuleOutput();
        }
        if (!this.isCaseSensitive(pm_field)) {
            pM = pM.toUpperCase();
        }
        if (debug) {
            logger.info("Checking condition 2 for values: BoD=" + bod + ", pM=" + pM + ", cT=" + cT + ", pT=" + pT);
        }
        if (this.matchesPrefix(pM, "1")) {
            boolean validBoD;
            boolean bl = validBoD = "6".equals(bod) || "7".equals(bod);
            if (!validBoD || this.matchesPrefix(cT, "is") || this.matchesPrefix(pT, "is")) {
                if (debug) {
                    logger.debug("INVALID - BoD: " + bod + "  pM: " + pM + "  cT: " + cT + "  pT: " + pT);
                }
                ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
                fieldValues.add(new FieldValue(bod_field, bod));
                fieldValues.add(new FieldValue(pm_field, pM));
                fieldValues.add(new FieldValue(ct_field, cT));
                fieldValues.add(new FieldValue(pt_field, pT));
                this.addErrorDetail(fieldValues);
            }
        }
        if (debug) {
            logger.info("Checked all conditions, returning output: " + String.valueOf(this.getRuleOutput()));
        }
        return this.getRuleOutput();
    }

    protected boolean matchesPrefix(String value, String expectedPrefix) {
        if (value == null || value.trim().isEmpty()) {
            return false;
        }
        if (expectedPrefix == null || expectedPrefix.trim().isEmpty()) {
            return false;
        }
        if (value.length() < expectedPrefix.length()) {
            return false;
        }
        String prefix = value.substring(0, expectedPrefix.length());
        return prefix.equalsIgnoreCase(expectedPrefix);
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_BOD.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_PM.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2014.INCIDENCE_CT.id, false);
        RuleParameter param4 = new RuleParameter(4, DefaultFieldIDencr2014.INCIDENCE_PT.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        defaultRuleParameters.add(param4);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
    }
}

