/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiseaseExtentRule4
extends CrossFieldRule {
    protected static Logger logger = LoggerFactory.getLogger(DiseaseExtentRule4.class);

    public DiseaseExtentRule4(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule validates the combination of basis of diagnosis and pN.\n\nIf pN is not (NX, missing, unknown), then basis of diagnosis should be 7.\n");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field bod_field = ruleConfiguration.getFieldByPosition(1);
        Field pn_field = ruleConfiguration.getFieldByPosition(2);
        String bod = this.getFieldValue(bod_field);
        String pn = this.getFieldValue(pn_field);
        if (this.containOneEmptyElement(new String[]{pn})) {
            return this.getRuleOutput();
        }
        if (!this.isCaseSensitive(pn_field)) {
            pn = pn.toUpperCase();
        }
        if (!(this.isFieldSetToUnknownValue(pn_field, pn) || pn.toUpperCase().equals("X") || bod.equals("7"))) {
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID - BoD: " + bod + "  pN: " + pn);
            }
            pn = this.getFieldValue(pn_field);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(bod_field, bod));
            fieldValues.add(new FieldValue(pn_field, pn));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_BOD.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_PN.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
    }
}

