/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiseaseExtentRule3
extends CrossFieldRule {
    protected static Logger logger = LoggerFactory.getLogger(DiseaseExtentRule3.class);

    public DiseaseExtentRule3(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule validates the combination of basis of diagnosis and pT.\n\nIf pT is not (TX, missing, unknown), then basis of diagnosis should be 7.\n");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field bod_field = ruleConfiguration.getFieldByPosition(1);
        Field pt_field = ruleConfiguration.getFieldByPosition(2);
        String bod = this.getFieldValue(bod_field);
        String pt = this.getFieldValue(pt_field);
        if (this.containOneEmptyElement(new String[]{pt})) {
            return this.getRuleOutput();
        }
        if (!this.isCaseSensitive(pt_field)) {
            pt = pt.toUpperCase();
        }
        if (this.isValidAndNotUnknownField(pt_field, pt) && !pt.toUpperCase().equals("X") && !bod.equals("7")) {
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID - BoD: " + bod + "  pT: " + pt);
            }
            pt = this.getFieldValue(pt_field);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(bod_field, bod));
            fieldValues.add(new FieldValue(pt_field, pt));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_BOD.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_PT.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
    }
}

