/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiseaseExtentRule2
extends CrossFieldRule {
    protected static Logger logger = LoggerFactory.getLogger(DiseaseExtentRule2.class);

    public DiseaseExtentRule2(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule validates the combination of topography and tumour size.\n\ne.g. If topography is C80 (unknown primary site), tumour size must be missing.\n");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        String tsize;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field topography_field = ruleConfiguration.getFieldByPosition(1);
        Field tsize_field = ruleConfiguration.getFieldByPosition(2);
        String topography = this.getFieldValue(topography_field);
        if (this.containOneEmptyElement(new String[]{topography, tsize = this.getFieldValue(tsize_field)})) {
            return this.getRuleOutput();
        }
        if (!this.isCaseSensitive(topography_field)) {
            topography = topography.toUpperCase();
        }
        if ("C809".equals(topography) && this.isValidAndNotUnknownField(tsize_field, tsize)) {
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID - Topography: " + topography + "  tsize: " + tsize);
            }
            topography = this.getFieldValue(topography_field);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(topography_field, topography));
            fieldValues.add(new FieldValue(tsize_field, tsize));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_TOPOGRAPHY.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_TSIZE.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
    }
}

