/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiseaseExtentRule10
extends CrossFieldRule {
    protected static Logger logger = LoggerFactory.getLogger(DiseaseExtentRule10.class);

    public DiseaseExtentRule10(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule validates the combination of behaviour and TNM/EOD.\n\nExample: \"Behaviour is 3 and pT is equal to 'IS' or 'is'\".");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field behaviour_field = ruleConfiguration.getFieldByPosition(1);
        Field pT_field = ruleConfiguration.getFieldByPosition(2);
        Field cT_field = ruleConfiguration.getFieldByPosition(3);
        Field stage_field = ruleConfiguration.getFieldByPosition(4);
        String behaviour = this.getFieldValue(behaviour_field);
        String pT = this.getFieldValue(pT_field);
        String cT = this.getFieldValue(cT_field);
        String stage = this.getFieldValue(stage_field);
        if (!this.isValidField(behaviour_field)) {
            return this.getRuleOutput();
        }
        int behaviourValue = this.parseIntegerValue(behaviour);
        boolean isValid = true;
        switch (behaviourValue) {
            case 0: 
            case 1: 
            case 2: {
                if (2 == behaviourValue) {
                    String stagePrefix = null;
                    if (stage != null && !stage.isEmpty()) {
                        stagePrefix = stage.trim().substring(0, 1);
                    }
                    if (!"0".equals(stagePrefix)) {
                        isValid = false;
                        if (!logger.isDebugEnabled()) break;
                        logger.debug("applyCheck() - Wrong stage for data " + this.formatDebugInfo(behaviour, pT, cT, stage) + " -> valid ? " + isValid);
                        break;
                    }
                }
                if (this.isValidAndDefinedField(pT_field, pT)) {
                    String pTFirstChar = pT.substring(0, 1);
                    int pTValue = this.parseIntegerValue(pTFirstChar);
                    if (pTValue >= 1) {
                        isValid = false;
                    }
                    if (!logger.isDebugEnabled()) break;
                    logger.debug("applyCheck() - Condition 3 (beh=0..2, pT>=1) for data " + this.formatDebugInfo(behaviour, pT, cT) + " -> matched = " + !isValid);
                    break;
                }
                if (this.isValidAndDefinedField(cT_field, cT)) {
                    String cTFirstChar = cT.substring(0, 1);
                    int cTValue = this.parseIntegerValue(cTFirstChar);
                    if (cTValue >= 1) {
                        isValid = false;
                    }
                    if (!logger.isDebugEnabled()) break;
                    logger.debug("Condition 4 (beh=0..2, cT>=1) for data " + this.formatDebugInfo(behaviour, pT, cT) + " -> matched = " + !isValid);
                    break;
                }
                if (!logger.isDebugEnabled()) break;
                logger.debug("Condition 4bis (beh=0..2, cT UNDEF) -> skipped because cT is not well defined. cT = " + cT);
                break;
            }
            case 3: {
                if (this.isValidAndDefinedField(pT_field, pT)) {
                    String pTKey = "is";
                    boolean matchespTKey = false;
                    matchespTKey = this.isCaseSensitive(pT_field) ? pTKey.equals(pT) : pTKey.equalsIgnoreCase(pT);
                    if (matchespTKey) {
                        isValid = false;
                    }
                    if (!logger.isDebugEnabled()) break;
                    logger.debug("applyCheck() - Condition 1 (beh=3, pT=is) for data " + this.formatDebugInfo(behaviour, pT, cT) + " -> matched = " + matchespTKey);
                    break;
                }
                String cTKey = "is";
                boolean matchescTKey = false;
                matchescTKey = this.isCaseSensitive(cT_field) ? cTKey.equals(cT) : cTKey.equalsIgnoreCase(cT);
                if (matchescTKey) {
                    isValid = false;
                }
                if (!logger.isDebugEnabled()) break;
                logger.debug("applyCheck() - Condition 2 (beh=3, cT=is) for data " + this.formatDebugInfo(behaviour, pT, cT) + " -> matched = " + matchescTKey);
            }
        }
        if (!isValid) {
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(behaviour_field, behaviour));
            fieldValues.add(new FieldValue(pT_field, pT));
            fieldValues.add(new FieldValue(cT_field, cT));
            fieldValues.add(new FieldValue(stage_field, stage));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_BEHAVIOUR.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_PT.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2014.INCIDENCE_CT.id, false);
        RuleParameter param4 = new RuleParameter(4, DefaultFieldIDencr2014.INCIDENCE_STAGE.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        defaultRuleParameters.add(param4);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MAX_SIZE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_UNKNOWN_VALUE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_RANGE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
    }

    protected String formatDebugInfo(String behaviour, String pT, String cT) {
        return this.formatDebugInfo(behaviour, pT, cT, "N/A");
    }

    protected String formatDebugInfo(String behaviour, String pT, String cT, String stage) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("beh = ");
        builder.append(behaviour);
        builder.append(" ,pT = ");
        builder.append(pT);
        builder.append(" ,cT = ");
        builder.append(cT);
        builder.append(" ,Stage = ");
        builder.append(stage);
        builder.append("]");
        return builder.toString();
    }
}

