/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleException;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiseaseExtentRule1
extends CrossFieldRule {
    protected List<String> configData = null;
    protected static Logger logger = LoggerFactory.getLogger(DiseaseExtentRule1.class);

    public DiseaseExtentRule1(RuleDefinition rule) {
        super(rule);
        if (!this.init()) {
            throw new InvalidRuleException("Initialization error");
        }
        this.setLongDescription("This rule validates the combination of topography and number of examined and metastatic nodes.\n\nFor certain topography codes, the number of examined and metastatic nodes must be missing.\n");
    }

    protected boolean init() {
        this.configData = this.loadConfigurationData(this.ruleConfiguration.getConfigurationFiles().get(0).getFileName());
        return this.configData != null;
    }

    @Override
    public List<RuleOutput> applyCheck() {
        String metNodes;
        String examNodes;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field topography_field = ruleConfiguration.getFieldByPosition(1);
        Field examNodes_field = ruleConfiguration.getFieldByPosition(2);
        Field metNodes_field = ruleConfiguration.getFieldByPosition(3);
        String topography = this.getFieldValue(topography_field);
        if (this.containOneEmptyElement(new String[]{topography, examNodes = this.getFieldValue(examNodes_field), metNodes = this.getFieldValue(metNodes_field)})) {
            return this.getRuleOutput();
        }
        if (!this.isCaseSensitive(topography_field)) {
            topography = topography.toUpperCase();
        }
        if (this.configData.contains(topography) && (this.isValidAndNotUnknownField(examNodes_field, examNodes) || this.isValidAndNotUnknownField(metNodes_field, metNodes))) {
            if (logger.isDebugEnabled()) {
                logger.debug("INVALID - Topography: " + topography + "  examNodes: " + examNodes + "  metNodes: " + metNodes);
            }
            topography = this.getFieldValue(topography_field);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(topography_field, topography));
            fieldValues.add(new FieldValue(examNodes_field, examNodes));
            fieldValues.add(new FieldValue(metNodes_field, metNodes));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_TOPOGRAPHY.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_N_EXAM_NODES.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2014.INCIDENCE_N_MET_NODES.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<LocalFile> files = new ArrayList<LocalFile>();
        files.add(new LocalFile("DiseaseExtentRule1.csv", "", "", "List of topography values"));
        this.ruleConfiguration.setConfigurationFiles(files);
    }
}

