/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.rule.InvalidRuleException;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.CrossFieldRule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiagnosisMorphologyRuleHybrid
extends CrossFieldRule {
    protected Field morphology_field;
    protected Field bod_field;
    protected Field age_field;
    protected Field topography_field;
    protected Field behaviour_field;
    protected Field sex_field;
    protected Field grade_field;
    List<Set<String>> morphologySetList0 = new ArrayList<Set<String>>();
    List<String> behList0 = new ArrayList<String>();
    List<Set<String>> topographySetList0 = new ArrayList<Set<String>>();
    List<Set<String>> morphologySetList1 = new ArrayList<Set<String>>();
    List<String> behList1 = new ArrayList<String>();
    List<Set<String>> topographySetList1 = new ArrayList<Set<String>>();
    List<Set<String>> morphologySetList2 = new ArrayList<Set<String>>();
    List<String> behList2 = new ArrayList<String>();
    List<Set<String>> topographySetList2 = new ArrayList<Set<String>>();
    List<String> gradeList2 = new ArrayList<String>();
    List<Set<String>> morphologySetList3 = new ArrayList<Set<String>>();
    List<String> behList3 = new ArrayList<String>();
    List<Set<String>> topographySetList3 = new ArrayList<Set<String>>();
    List<Set<String>> morphologySetList4 = new ArrayList<Set<String>>();
    List<String> behList4 = new ArrayList<String>();
    List<Set<String>> morphologySetList5 = new ArrayList<Set<String>>();
    List<String> behList5 = new ArrayList<String>();
    List<Set<String>> morphologySetList6 = new ArrayList<Set<String>>();
    List<String> behList6 = new ArrayList<String>();
    List<Set<String>> morphologySetList7 = new ArrayList<Set<String>>();
    protected static Logger logger = LoggerFactory.getLogger(DiagnosisMorphologyRuleHybrid.class);

    public DiagnosisMorphologyRuleHybrid(RuleDefinition rule) {
        super(rule);
        if (!this.init()) {
            throw new InvalidRuleException("Initialization error");
        }
    }

    protected boolean init() {
        if (logger.isDebugEnabled()) {
            logger.debug("init() - Diagnosis Morphology Hybrid : loading config data");
        }
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        List<LocalFile> files = ruleConfiguration.getConfigurationFiles();
        if (logger.isDebugEnabled()) {
            logger.debug("init() - Loading configuration file (morphology values): " + files.get(0).getFileName());
        }
        if (!this.loadTable4ConsistencyRules3Col(files.get(0).getFileName(), this.morphologySetList0, this.behList0, this.topographySetList0)) {
            logger.error("init() - Error loading configuration of Table 4 consistency rules");
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("init() - Loading configuration file (morphology values): " + files.get(1).getFileName());
        }
        if (!this.loadTable4ConsistencyRules3Col(files.get(1).getFileName(), this.morphologySetList1, this.behList1, this.topographySetList1)) {
            logger.error("init() - Error loading configuration of Table 4 consistency rules");
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("init() - Loading configuration file (morphology values): " + files.get(2).getFileName());
        }
        if (!this.loadTable4ConsistencyRules4Col(files.get(2).getFileName(), this.morphologySetList2, this.behList2, this.topographySetList2, this.gradeList2)) {
            logger.error("init() - Error loading configuration of Table 4 consistency rules");
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("init() - Loading configuration file (morphology values): " + files.get(3).getFileName());
        }
        if (!this.loadTable4ConsistencyRules3Col(files.get(3).getFileName(), this.morphologySetList3, this.behList3, this.topographySetList3)) {
            logger.error("init() - Error loading configuration of Table 4 consistency rules");
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("init() - Loading configuration file (morphology values): " + files.get(4).getFileName());
        }
        if (!this.loadTable4ConsistencyRules2Col(files.get(4).getFileName(), this.morphologySetList4, this.behList4)) {
            logger.error("init() - Error loading configuration of Table 4 consistency rules");
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("init() - Loading configuration file (morphology values): " + files.get(5).getFileName());
        }
        if (!this.loadTable4ConsistencyRules2Col(files.get(5).getFileName(), this.morphologySetList5, this.behList5)) {
            logger.error("init() - Error loading configuration of Table 4 consistency rules");
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("init() - Loading configuration file (morphology values): " + files.get(6).getFileName());
        }
        if (!this.loadTable4ConsistencyRules2Col(files.get(6).getFileName(), this.morphologySetList6, this.behList6)) {
            logger.error("init() - Error loading configuration of Table 4 consistency rules");
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("init() - Loading configuration file (morphology values): " + files.get(7).getFileName());
        }
        if (!this.loadTable4ConsistencyRules1Col(files.get(7).getFileName(), this.morphologySetList7)) {
            logger.error("init() - Error loading configuration of Table 4 consistency rules");
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("init() - Diagnosis Morphology Hybrid : loaded config data (8 files)");
        }
        return true;
    }

    public boolean loadTable4ConsistencyRules3Col(String fileName, List<Set<String>> morphologySetList, List<String> behList, List<Set<String>> topographySetList) {
        int i;
        List<String> configData = this.loadConfigurationData(fileName);
        if (configData == null) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("loadTable4ConsistencyRules3Col - File " + fileName + ": size " + configData.size());
        }
        String[][] matrix = new String[configData.size()][3];
        for (i = 0; i < configData.size(); ++i) {
            matrix[i] = configData.get(i).split(";");
        }
        for (i = 0; i < matrix.length; ++i) {
            HashSet<String> itemMorphology = new HashSet<String>();
            String[] groupMorphology = matrix[i][0].split(",");
            if (groupMorphology[0].equals("-")) {
                itemMorphology.add("-");
            } else {
                itemMorphology = new HashSet();
                for (int j = 0; j < groupMorphology.length; ++j) {
                    String[] morphologyItem = groupMorphology[j].split("-");
                    if (morphologyItem.length == 1) {
                        itemMorphology.add(morphologyItem[0]);
                        continue;
                    }
                    int lowMorphology = Integer.parseInt(morphologyItem[0]);
                    int highMorphology = Integer.parseInt(morphologyItem[1]);
                    for (int z = lowMorphology; z <= highMorphology; ++z) {
                        itemMorphology.add(String.valueOf(z));
                    }
                }
            }
            morphologySetList.add(itemMorphology);
            behList.add(matrix[i][1]);
            HashSet<Object> itemTopography = new HashSet<Object>();
            String[] groupTopography = matrix[i][2].split(",");
            if (groupTopography[0].equals("-")) {
                itemTopography.add("-");
            } else {
                itemTopography = new HashSet();
                for (int j = 0; j < groupTopography.length; ++j) {
                    int upLimit;
                    int lowLimit;
                    String[] topographyItem = groupTopography[j].split("-");
                    if (topographyItem.length == 1) {
                        if (topographyItem[0].length() == 3) {
                            topographyItem[0] = topographyItem[0] + "*";
                        }
                        if (topographyItem[0].contains("*")) {
                            lowLimit = Integer.parseInt(topographyItem[0].substring(1, 3) + "0");
                            upLimit = Integer.parseInt(topographyItem[0].substring(1, 3) + "9");
                            for (int zz = lowLimit; zz <= upLimit; ++zz) {
                                itemTopography.add("C" + String.format("%03d", zz));
                            }
                            continue;
                        }
                        itemTopography.add(topographyItem[0]);
                        continue;
                    }
                    if (topographyItem[0].length() == 3) {
                        topographyItem[0] = topographyItem[0] + "*";
                    }
                    if (topographyItem[0].contains("*")) {
                        topographyItem[0] = topographyItem[0].replace('*', '0');
                    }
                    if (topographyItem[1].length() == 3) {
                        topographyItem[1] = topographyItem[1] + "*";
                    }
                    if (topographyItem[1].contains("*")) {
                        topographyItem[1] = topographyItem[1].replace('*', '9');
                    }
                    lowLimit = Integer.parseInt(topographyItem[0].substring(1, 4));
                    upLimit = Integer.parseInt(topographyItem[1].substring(1, 4));
                    for (int z = lowLimit; z <= upLimit; ++z) {
                        itemTopography.add("C" + String.format("%03d", z));
                    }
                }
            }
            topographySetList.add(itemTopography);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("--");
            logger.debug(morphologySetList.toString());
            logger.debug(behList.toString());
            logger.debug(topographySetList.toString());
            logger.debug("--");
        }
        return true;
    }

    public boolean loadTable4ConsistencyRules4Col(String fileName, List<Set<String>> morphologySetList, List<String> behList, List<Set<String>> topographySetList, List<String> gradeList) {
        int i;
        List<String> configData = this.loadConfigurationData(fileName);
        if (configData == null) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("loadTable4ConsistencyRules4Col() - File " + fileName + ": size " + configData.size());
        }
        String[][] matrix = new String[configData.size()][3];
        for (i = 0; i < configData.size(); ++i) {
            matrix[i] = configData.get(i).split(";");
        }
        for (i = 0; i < matrix.length; ++i) {
            HashSet<String> itemMorphology = new HashSet<String>();
            String[] groupMorphology = matrix[i][0].split(",");
            if (groupMorphology[0].equals("-")) {
                itemMorphology.add("-");
            } else {
                itemMorphology = new HashSet();
                for (int j = 0; j < groupMorphology.length; ++j) {
                    String[] morphologyItem = groupMorphology[j].split("-");
                    if (morphologyItem.length == 1) {
                        itemMorphology.add(morphologyItem[0]);
                        continue;
                    }
                    int lowMorphology = Integer.parseInt(morphologyItem[0]);
                    int highMorphology = Integer.parseInt(morphologyItem[1]);
                    for (int z = lowMorphology; z <= highMorphology; ++z) {
                        itemMorphology.add(String.valueOf(z));
                    }
                }
            }
            morphologySetList.add(itemMorphology);
            if (matrix[i][1].length() == 1) {
                behList.add(matrix[i][1]);
                gradeList.add("-");
            } else if (matrix[i][1].length() == 2) {
                behList.add(matrix[i][1].substring(0, 1));
                gradeList.add(matrix[i][1].substring(1, 2));
            } else {
                return false;
            }
            HashSet<Object> itemTopography = new HashSet<Object>();
            String[] groupTopography = matrix[i][2].split(",");
            if (groupTopography[0].equals("-")) {
                itemTopography.add("-");
            } else {
                itemTopography = new HashSet();
                for (int j = 0; j < groupTopography.length; ++j) {
                    int upLimit;
                    int lowLimit;
                    String[] topographyItem = groupTopography[j].split("-");
                    if (topographyItem.length == 1) {
                        if (topographyItem[0].length() == 3) {
                            topographyItem[0] = topographyItem[0] + "*";
                        }
                        if (topographyItem[0].contains("*")) {
                            lowLimit = Integer.parseInt(topographyItem[0].substring(1, 3) + "0");
                            upLimit = Integer.parseInt(topographyItem[0].substring(1, 3) + "9");
                            for (int zz = lowLimit; zz <= upLimit; ++zz) {
                                itemTopography.add("C" + String.format("%03d", zz));
                            }
                            continue;
                        }
                        itemTopography.add(topographyItem[0]);
                        continue;
                    }
                    if (topographyItem[0].length() == 3) {
                        topographyItem[0] = topographyItem[0] + "*";
                    }
                    if (topographyItem[0].contains("*")) {
                        topographyItem[0] = topographyItem[0].replace('*', '0');
                    }
                    if (topographyItem[1].length() == 3) {
                        topographyItem[1] = topographyItem[1] + "*";
                    }
                    if (topographyItem[1].contains("*")) {
                        topographyItem[1] = topographyItem[1].replace('*', '9');
                    }
                    lowLimit = Integer.parseInt(topographyItem[0].substring(1, 4));
                    upLimit = Integer.parseInt(topographyItem[1].substring(1, 4));
                    for (int z = lowLimit; z <= upLimit; ++z) {
                        itemTopography.add("C" + String.format("%03d", z));
                    }
                }
            }
            topographySetList.add(itemTopography);
        }
        return true;
    }

    public boolean loadTable4ConsistencyRules2Col(String fileName, List<Set<String>> morphologySetList, List<String> behList) {
        int i;
        List<String> configData = this.loadConfigurationData(fileName);
        if (configData == null) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("loadTable4ConsistencyRules2Col() - " + fileName + ": size " + configData.size());
        }
        String[][] matrix = new String[configData.size()][2];
        for (i = 0; i < configData.size(); ++i) {
            matrix[i] = configData.get(i).split(";");
        }
        for (i = 0; i < matrix.length; ++i) {
            HashSet<String> itemMorphology = new HashSet<String>();
            String[] groupMorphology = matrix[i][0].split(",");
            if (groupMorphology[0].equals("-")) {
                itemMorphology.add("-");
            } else {
                itemMorphology = new HashSet();
                for (int j = 0; j < groupMorphology.length; ++j) {
                    String[] morphologyItem = groupMorphology[j].split("-");
                    if (morphologyItem.length == 1) {
                        itemMorphology.add(morphologyItem[0]);
                        continue;
                    }
                    int lowMorphology = Integer.parseInt(morphologyItem[0]);
                    int highMorphology = Integer.parseInt(morphologyItem[1]);
                    for (int z = lowMorphology; z <= highMorphology; ++z) {
                        itemMorphology.add(String.valueOf(z));
                    }
                }
            }
            morphologySetList.add(itemMorphology);
            behList.add(matrix[i][1]);
        }
        return true;
    }

    public boolean loadTable4ConsistencyRules1Col(String fileName, List<Set<String>> morphologySetList) {
        int i;
        List<String> configData = this.loadConfigurationData(fileName);
        if (configData == null) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(fileName + ": size " + configData.size());
        }
        String[][] matrix = new String[configData.size()][1];
        for (i = 0; i < configData.size(); ++i) {
            matrix[i] = configData.get(i).split(";");
        }
        for (i = 0; i < matrix.length; ++i) {
            HashSet<String> itemMorphology = new HashSet<String>();
            String[] groupMorphology = matrix[i][0].split(",");
            if (groupMorphology[0].equals("-")) {
                itemMorphology.add("-");
            } else {
                itemMorphology = new HashSet();
                for (int j = 0; j < groupMorphology.length; ++j) {
                    String[] morphologyItem = groupMorphology[j].split("-");
                    if (morphologyItem.length == 1) {
                        itemMorphology.add(morphologyItem[0]);
                        continue;
                    }
                    int lowMorphology = Integer.parseInt(morphologyItem[0]);
                    int highMorphology = Integer.parseInt(morphologyItem[1]);
                    for (int z = lowMorphology; z <= highMorphology; ++z) {
                        itemMorphology.add(String.valueOf(z));
                    }
                }
            }
            morphologySetList.add(itemMorphology);
        }
        return true;
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_MORPHOLOGY.id, false);
        RuleParameter param2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_BOD.id, false);
        RuleParameter param3 = new RuleParameter(3, DefaultFieldIDencr2014.INCIDENCE_AGE.id, false);
        RuleParameter param4 = new RuleParameter(4, DefaultFieldIDencr2014.INCIDENCE_TOPOGRAPHY.id, false);
        RuleParameter param5 = new RuleParameter(5, DefaultFieldIDencr2014.INCIDENCE_BEHAVIOUR.id, false);
        RuleParameter param6 = new RuleParameter(6, DefaultFieldIDencr2014.INCIDENCE_SEX.id, false);
        RuleParameter param7 = new RuleParameter(7, DefaultFieldIDencr2014.INCIDENCE_GRADE.id, false);
        defaultRuleParameters.add(param1);
        defaultRuleParameters.add(param2);
        defaultRuleParameters.add(param3);
        defaultRuleParameters.add(param4);
        defaultRuleParameters.add(param5);
        defaultRuleParameters.add(param6);
        defaultRuleParameters.add(param7);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<LocalFile> files = new ArrayList<LocalFile>();
        files.add(new LocalFile("DiagnosisMorphologyRuleBoD0.csv", "", "", "Morphology too specific (tab. 4 - BoD0) error code W-BDMO"));
        files.add(new LocalFile("DiagnosisMorphologyRuleBoD1.csv", "", "", "Morphology too specific (tab. 4 - BoD1) error code W-BDMO"));
        files.add(new LocalFile("DiagnosisMorphologyRuleBoD2.csv", "", "", "Morphology too specific (tab. 4 - BoD2) error code W-BDMO"));
        files.add(new LocalFile("DiagnosisMorphologyRuleBoD4.csv", "", "", "Morphology too specific (tab. 4 - BoD4) error code W-BDMO"));
        files.add(new LocalFile("DiagnosisMorphologyRuleBoD5.csv", "", "", "Morphology not enough specific  (tab. 4 - BoD5) error code W-BDMS - reverse logic"));
        files.add(new LocalFile("DiagnosisMorphologyRuleBoD6.csv", "", "", "Morphology not enough specific  (tab. 4 - BoD6) error code W-BDMS - reverse logic"));
        files.add(new LocalFile("DiagnosisMorphologyRuleBoD7.csv", "", "", "Morphology not enough specific  (tab. 4 - BoD7) error code W-BDMS - reverse logic"));
        files.add(new LocalFile("DiagnosisMorphologyRuleBoD8.csv", "", "", "Morphology not enough specific  (tab. 4 - BoD8) error code W-BDMS"));
        this.ruleConfiguration.setConfigurationFiles(files);
    }
}

