/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.DiagnosisMorphologyRuleHybrid;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosisMorphologyRule5
extends DiagnosisMorphologyRuleHybrid {
    protected static Logger logger = LoggerFactory.getLogger(DiagnosisMorphologyRule5.class);

    public DiagnosisMorphologyRule5(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule validates whether morphology is not specific enough according to the basis of diagnosis.\n\nThe rule uses a list of valid combinations of basis of diagnosis and morphology, when BoD is 5 or 7.\n");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        int i;
        this.morphology_field = this.ruleConfiguration.getFieldByPosition(1);
        this.bod_field = this.ruleConfiguration.getFieldByPosition(2);
        this.age_field = this.ruleConfiguration.getFieldByPosition(3);
        this.topography_field = this.ruleConfiguration.getFieldByPosition(4);
        this.behaviour_field = this.ruleConfiguration.getFieldByPosition(5);
        this.sex_field = this.ruleConfiguration.getFieldByPosition(6);
        String morphology = this.getFieldValue(this.morphology_field);
        String bod = this.getFieldValue(this.bod_field);
        String topography = this.getFieldValue(this.topography_field);
        String behaviour = this.getFieldValue(this.behaviour_field);
        if (logger.isDebugEnabled()) {
            logger.debug("applyCheck() rule_5 -  - Bod: " + bod + " Morphology: " + morphology + "  Topography: " + topography + "  Behaviour: " + behaviour);
        }
        if (this.containOneEmptyElement(new String[]{morphology, bod})) {
            return this.getRuleOutput();
        }
        if (!this.isIntegerValue(bod)) {
            return this.getRuleOutput();
        }
        int bodInt = this.parseIntegerValue(bod);
        if (bodInt < 4 || bodInt > 8) {
            return this.getRuleOutput();
        }
        if (!this.isCaseSensitive(this.topography_field)) {
            topography = topography.toUpperCase();
        }
        if (bodInt == 5) {
            for (i = 0; i < this.morphologySetList4.size(); ++i) {
                if (!((Set)this.morphologySetList4.get(i)).contains(morphology) || !((String)this.behList4.get(i)).equals(behaviour)) continue;
                logger.debug("applyCheck() - INVALID - Bod: " + bod + " Morphology: " + morphology + "  Behaviour: " + behaviour);
                ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
                fieldValues.add(new FieldValue(this.bod_field, bod));
                fieldValues.add(new FieldValue(this.morphology_field, morphology));
                fieldValues.add(new FieldValue(this.behaviour_field, behaviour));
                this.addErrorDetail(fieldValues);
                return this.getRuleOutput();
            }
        }
        if (bodInt == 6) {
            for (i = 0; i < this.morphologySetList5.size(); ++i) {
                if (!((Set)this.morphologySetList5.get(i)).contains(morphology) || !((String)this.behList5.get(i)).equals(behaviour)) continue;
                logger.debug("applyCheck() - INVALID - Bod: " + bod + " Morphology: " + morphology + "  Behaviour: " + behaviour);
                ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
                fieldValues.add(new FieldValue(this.bod_field, bod));
                fieldValues.add(new FieldValue(this.morphology_field, morphology));
                fieldValues.add(new FieldValue(this.behaviour_field, behaviour));
                this.addErrorDetail(fieldValues);
                return this.getRuleOutput();
            }
        }
        if (bodInt == 7) {
            for (i = 0; i < this.morphologySetList6.size(); ++i) {
                if (!((Set)this.morphologySetList6.get(i)).contains(morphology) || !((String)this.behList6.get(i)).equals(behaviour)) continue;
                logger.debug("applyCheck() - INVALID - Bod: " + bod + " Morphology: " + morphology + "  Behaviour: " + behaviour);
                ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
                fieldValues.add(new FieldValue(this.bod_field, bod));
                fieldValues.add(new FieldValue(this.morphology_field, morphology));
                fieldValues.add(new FieldValue(this.behaviour_field, behaviour));
                this.addErrorDetail(fieldValues);
                return this.getRuleOutput();
            }
        }
        if (bodInt == 8) {
            boolean found = false;
            for (int i2 = 0; i2 < this.morphologySetList7.size(); ++i2) {
                if (!((Set)this.morphologySetList7.get(i2)).contains(morphology)) continue;
                found = true;
                break;
            }
            if (!found) {
                if (logger.isDebugEnabled()) {
                    logger.debug("applyCheck() - INVALID - Bod: " + bod + " Morphology: " + morphology);
                }
                ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
                fieldValues.add(new FieldValue(this.bod_field, bod));
                fieldValues.add(new FieldValue(this.morphology_field, morphology));
                this.addErrorDetail(fieldValues);
            }
            return this.getRuleOutput();
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
    }
}

