/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr2014.DiagnosisMorphologyRuleHybrid;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosisMorphologyRule4
extends DiagnosisMorphologyRuleHybrid {
    protected static Logger logger = LoggerFactory.getLogger(DiagnosisMorphologyRule4.class);

    public DiagnosisMorphologyRule4(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule validates whether morphology is too specific according to the basis of diagnosis.\n\nThe rule uses a list of valid combinations of basis of diagnosis and morphology, when BoD is between 0 and 4.\n");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        this.morphology_field = this.ruleConfiguration.getFieldByPosition(1);
        this.bod_field = this.ruleConfiguration.getFieldByPosition(2);
        this.age_field = this.ruleConfiguration.getFieldByPosition(3);
        this.topography_field = this.ruleConfiguration.getFieldByPosition(4);
        this.behaviour_field = this.ruleConfiguration.getFieldByPosition(5);
        this.sex_field = this.ruleConfiguration.getFieldByPosition(6);
        this.grade_field = this.ruleConfiguration.getFieldByPosition(7);
        String morphology = this.getFieldValue(this.morphology_field);
        String bod = this.getFieldValue(this.bod_field);
        String topography = this.getFieldValue(this.topography_field);
        String behaviour = this.getFieldValue(this.behaviour_field);
        String grade = this.getFieldValue(this.grade_field);
        if (logger.isDebugEnabled()) {
            logger.debug("applyCheck() rule_4 -  - Bod: " + bod + " Morphology: " + morphology + "  Topography: " + topography + "  Behaviour: " + behaviour + " Grade: " + grade);
        }
        if (this.containOneEmptyElement(new String[]{morphology, bod})) {
            return this.getRuleOutput();
        }
        if (!this.isIntegerValue(bod)) {
            return this.getRuleOutput();
        }
        int bodInt = this.parseIntegerValue(bod);
        if (bodInt < 0 || bodInt > 4) {
            return this.getRuleOutput();
        }
        if (!this.isCaseSensitive(this.topography_field)) {
            topography = topography.toUpperCase();
        }
        if (bodInt == 0) {
            boolean found = false;
            for (int i = 0; i < this.morphologySetList0.size(); ++i) {
                if (!((Set)this.morphologySetList0.get(i)).contains(morphology) || !((String)this.behList0.get(i)).equals(behaviour) || !((Set)this.topographySetList0.get(i)).contains("-") && !((Set)this.topographySetList0.get(i)).contains(topography)) continue;
                found = true;
                if (!logger.isDebugEnabled()) break;
                logger.debug("FOUND: " + morphology + " " + behaviour + " " + topography);
                break;
            }
            if (!found) {
                if (logger.isDebugEnabled()) {
                    logger.debug("applyCheck() - INVALID - Bod: " + bod + " Morphology: " + morphology + "  Topography: " + topography + "  Behaviour: " + behaviour);
                }
                ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
                fieldValues.add(new FieldValue(this.bod_field, bod));
                fieldValues.add(new FieldValue(this.morphology_field, morphology));
                fieldValues.add(new FieldValue(this.topography_field, topography));
                fieldValues.add(new FieldValue(this.behaviour_field, behaviour));
                this.addErrorDetail(fieldValues);
            }
            return this.getRuleOutput();
        }
        if (bodInt == 1) {
            boolean found = false;
            for (int i = 0; i < this.morphologySetList1.size(); ++i) {
                if (!((Set)this.morphologySetList1.get(i)).contains(morphology) || !((String)this.behList1.get(i)).equals(behaviour) || !((Set)this.topographySetList1.get(i)).contains("-") && !((Set)this.topographySetList1.get(i)).contains(topography)) continue;
                found = true;
                break;
            }
            if (!found) {
                if (logger.isDebugEnabled()) {
                    logger.debug("applyCheck() - INVALID - Bod: " + bod + " Morphology: " + morphology + "  Topography: " + topography + "  Behaviour: " + behaviour);
                }
                ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
                fieldValues.add(new FieldValue(this.bod_field, bod));
                fieldValues.add(new FieldValue(this.morphology_field, morphology));
                fieldValues.add(new FieldValue(this.topography_field, topography));
                fieldValues.add(new FieldValue(this.behaviour_field, behaviour));
                this.addErrorDetail(fieldValues);
            }
            return this.getRuleOutput();
        }
        if (bodInt == 2) {
            boolean found = false;
            for (int i = 0; i < this.morphologySetList2.size(); ++i) {
                if (!((Set)this.morphologySetList2.get(i)).contains(morphology) || !((String)this.behList2.get(i)).equals(behaviour) || !((Set)this.topographySetList2.get(i)).contains("-") && !((Set)this.topographySetList2.get(i)).contains(topography) || !((String)this.gradeList2.get(i)).equals("-") && !((String)this.gradeList2.get(i)).equals(grade)) continue;
                found = true;
                break;
            }
            if (!found) {
                if (logger.isDebugEnabled()) {
                    logger.debug("applyCheck() - INVALID - Bod: " + bod + " Morphology: " + morphology + "  Topography: " + topography + "  Behaviour: " + behaviour + " Grade: " + grade);
                }
                ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
                fieldValues.add(new FieldValue(this.bod_field, bod));
                fieldValues.add(new FieldValue(this.morphology_field, morphology));
                fieldValues.add(new FieldValue(this.topography_field, topography));
                fieldValues.add(new FieldValue(this.behaviour_field, behaviour));
                fieldValues.add(new FieldValue(this.grade_field, grade));
                this.addErrorDetail(fieldValues);
            }
            return this.getRuleOutput();
        }
        if (bodInt == 3) {
            if (logger.isDebugEnabled()) {
                logger.debug("applyCheck() - INVALID - Bod: " + bod + " Morphology: " + morphology + "  Topography: " + topography + "  Behaviour: " + behaviour);
            }
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(this.bod_field, bod));
            fieldValues.add(new FieldValue(this.morphology_field, morphology));
            fieldValues.add(new FieldValue(this.topography_field, topography));
            fieldValues.add(new FieldValue(this.behaviour_field, behaviour));
            this.addErrorDetail(fieldValues);
            return this.getRuleOutput();
        }
        if (bodInt == 4) {
            boolean found = false;
            for (int i = 0; i < this.morphologySetList3.size(); ++i) {
                if (!((Set)this.morphologySetList3.get(i)).contains(morphology) || !((String)this.behList3.get(i)).equals(behaviour) || !((Set)this.topographySetList3.get(i)).contains("-") && !((Set)this.topographySetList3.get(i)).contains(topography)) continue;
                found = true;
                break;
            }
            if (!found) {
                if (logger.isDebugEnabled()) {
                    logger.debug("applyCheck() - INVALID - Bod: " + bod + " Morphology: " + morphology + "  Topography: " + topography + "  Behaviour: " + behaviour);
                }
                ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
                fieldValues.add(new FieldValue(this.bod_field, bod));
                fieldValues.add(new FieldValue(this.morphology_field, morphology));
                fieldValues.add(new FieldValue(this.topography_field, topography));
                fieldValues.add(new FieldValue(this.behaviour_field, behaviour));
                this.addErrorDetail(fieldValues);
            }
            return this.getRuleOutput();
        }
        return this.getRuleOutput();
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
    }
}

